/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitMergeAction
extends GitRepositoryAction {
    GitMergeAction() {
    }

    @Nullable
    protected abstract DialogState displayDialog(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3);

    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        DialogState dialogState = this.displayDialog(project, gitRoots, defaultRoot);
        if (dialogState == null) {
            return;
        }
        final VirtualFile selectedRoot = dialogState.selectedRoot;
        final Computable<GitLineHandler> handlerProvider = dialogState.handlerProvider;
        final Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, "Before update");
        new Task.Backgroundable(project, dialogState.progressTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
                Git git = Git.getInstance();
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(selectedRoot, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(selectedRoot);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitMergeAction.this.getActionName());){
                    GitCommandResult result2 = git.runCommand((Computable<GitLineHandler>)((Computable)() -> {
                        GitLineHandler handler = (GitLineHandler)handlerProvider.compute();
                        handler.addLineListener(localChangesDetector);
                        handler.addLineListener(untrackedFilesDetector);
                        handler.addLineListener(mergeConflict);
                        return handler;
                    }));
                    GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot(selectedRoot);
                    assert (repository != null) : "Repository can't be null for root " + selectedRoot;
                    String revision = repository.getCurrentRevision();
                    if (revision == null) {
                        return;
                    }
                    GitRevisionNumber currentRev = new GitRevisionNumber(revision);
                    GitMergeAction.this.handleResult(result2, project, mergeConflict, localChangesDetector, untrackedFilesDetector, repository, currentRev, beforeLabel);
                }
            }
        }.queue();
    }

    private void handleResult(GitCommandResult result2, Project project, GitSimpleEventDetector mergeConflictDetector, GitLocalChangesWouldBeOverwrittenDetector localChangesDetector, GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector, GitRepository repository, GitRevisionNumber currentRev, Label beforeLabel) {
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        VirtualFile root = repository.getRoot();
        if (result2.success() || mergeConflictDetector.hasHappened()) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
            ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
            GitMergeUtil.showUpdates(project, exceptions, root, currentRev, beforeLabel, this.getActionName(), ActionInfo.UPDATE);
            repositoryManager.updateRepository(root);
            GitMergeAction.showErrors(project, this.getActionName(), exceptions);
        } else if (localChangesDetector.wasMessageDetected()) {
            LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, repository.getRoot(), this.getActionName(), localChangesDetector.getRelativeFilePaths());
        } else if (untrackedFilesDetector.wasMessageDetected()) {
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, untrackedFilesDetector.getRelativeFilePaths(), this.getActionName(), null);
        } else {
            GitUIUtil.notifyError(project, "Git " + this.getActionName() + " Failed", result2.getErrorOutputAsJoinedString(), true, null);
            repositoryManager.updateRepository(root);
        }
    }

    protected static class DialogState {
        final VirtualFile selectedRoot;
        final String progressTitle;
        final Computable<GitLineHandler> handlerProvider;

        DialogState(@NotNull VirtualFile root, @NotNull String title, @NotNull Computable<GitLineHandler> provider) {
            this.selectedRoot = root;
            this.progressTitle = title;
            this.handlerProvider = provider;
        }
    }
}

