/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.GitResetDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitResetHead
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.getString("reset.action.name");
    }

    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        final GitResetDialog d = new GitResetDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        new Task.Backgroundable(project, GitBundle.getString("resetting.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                try (AccessToken ignored = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitResetHead.this.getActionName());){
                    GitCommandResult result2 = Git.getInstance().runCommand(d.handler());
                    if (!result2.success()) {
                        VcsNotifier.getInstance((Project)project).notifyError(GitBundle.getString("resetting.title"), result2.getErrorOutputAsHtmlString());
                    }
                }
            }

            public void onFinished() {
                GitRepositoryManager.getInstance(project).updateRepository(d.getGitRoot());
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{d.getGitRoot()});
            }
        }.queue();
    }
}

