/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtilRt;
import git4idea.GitVcs;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class GitResolveConflictsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = (Project)ObjectUtils.notNull((Object)event.getProject());
        GitVcs vcs = GitVcs.getInstance(project);
        TreeSet<VirtualFile> conflictedFiles = new TreeSet<VirtualFile>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (Change change : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            VirtualFile file;
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if (before != null && (file = before.getFile().getVirtualFile()) != null) {
                conflictedFiles.add(file);
            }
            if (after == null || (file = after.getFile().getVirtualFile()) == null) continue;
            conflictedFiles.add(file);
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog((List)ContainerUtilRt.newArrayList(conflictedFiles), vcs.getMergeProvider());
    }

    private static boolean isEnabled(@NotNull Project project) {
        Collection changes = ChangeListManager.getInstance((Project)project).getAllChanges();
        if (changes.size() > 1000) {
            return true;
        }
        return changes.stream().anyMatch(it -> it.getFileStatus() == FileStatus.MERGED_WITH_CONFLICTS);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabled(GitResolveConflictsAction.isEnabled(project));
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(e.getPresentation().isEnabled());
        }
    }
}

