/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import git4idea.GitVcs;
import git4idea.annotate.GitFileAnnotation;
import git4idea.config.GitVcsApplicationSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitToggleAnnotationOptionsActionProvider
implements AnnotationGutterActionProvider {
    private static final GitVcsApplicationSettings SETTINGS = GitVcsApplicationSettings.getInstance();

    @NotNull
    public AnAction createAction(@NotNull FileAnnotation annotation) {
        return new MyGroup(annotation);
    }

    private static void resetAllAnnotations(@NotNull Project project) {
        ProjectLevelVcsManager.getInstance((Project)project).getVcsHistoryCache().clearAnnotations();
        ProjectLevelVcsManager.getInstance((Project)project).getAnnotationLocalChangesListener().reloadAnnotationsForVcs(GitVcs.getKey());
    }

    private static class ToggleOuterMovementsWhitespaces
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Project myProject;

        ToggleOuterMovementsWhitespaces(@NotNull Project project) {
            super("Detect Movements Across Files");
            this.myProject = project;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return SETTINGS.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            if (enabled) {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER);
            } else {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER);
            }
            GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.myProject);
        }
    }

    private static class ToggleInnerMovementsWhitespaces
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Project myProject;

        ToggleInnerMovementsWhitespaces(@NotNull Project project) {
            super("Detect Movements Within File");
            this.myProject = project;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return SETTINGS.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER || SETTINGS.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            if (enabled) {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER);
            } else {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.NONE);
            }
            GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.myProject);
        }
    }

    private static class ToggleIgnoreWhitespaces
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Project myProject;

        ToggleIgnoreWhitespaces(@NotNull Project project) {
            super("Ignore Whitespaces");
            this.myProject = project;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return SETTINGS.isIgnoreWhitespaces();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            SETTINGS.setIgnoreWhitespaces(enabled);
            GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.myProject);
        }
    }

    private static class MyGroup
    extends ActionGroup {
        private final FileAnnotation myAnnotation;

        MyGroup(@NotNull FileAnnotation annotation) {
            super("Options", true);
            this.myAnnotation = annotation;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myAnnotation instanceof GitFileAnnotation) {
                return new AnAction[]{new ToggleIgnoreWhitespaces(this.myAnnotation.getProject()), new ToggleInnerMovementsWhitespaces(this.myAnnotation.getProject()), new ToggleOuterMovementsWhitespaces(this.myAnnotation.getProject())};
            }
            return AnAction.EMPTY_ARRAY;
        }
    }
}

