/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.annotate.GitFileAnnotation;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitAnnotationProvider
implements AnnotationProviderEx {
    private final Project myProject;
    @NonNls
    private static final String SUBJECT_KEY = "summary";
    @NonNls
    private static final String FILENAME_KEY = "filename";
    @NonNls
    private static final String PREVIOUS_KEY = "previous";
    @NonNls
    private static final String AUTHOR_KEY = "author";
    @NonNls
    private static final String AUTHOR_EMAIL_KEY = "author-mail";
    @NonNls
    private static final String COMMITTER_TIME_KEY = "committer-time";
    @NonNls
    private static final String AUTHOR_TIME_KEY = "author-time";
    private static final Logger LOG = Logger.getInstance(GitAnnotationProvider.class);
    @NotNull
    private final VcsHistoryCache myCache;
    @NotNull
    private final VcsUserRegistry myUserRegistry;

    public GitAnnotationProvider(@NotNull Project project) {
        this.myProject = project;
        this.myCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
    }

    public boolean isCaching() {
        return true;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        return this.annotate(file, null);
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, @Nullable VcsFileRevision revision) throws VcsException {
        if (file.isDirectory()) {
            throw new VcsException("Cannot annotate a directory");
        }
        FilePath currentFilePath = VcsUtil.getFilePath((String)file.getPath());
        FilePath realFilePath = revision == null ? VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)currentFilePath) : ((VcsFileRevisionEx)revision).getPath();
        VcsRevisionNumber revisionNumber = revision != null ? revision.getRevisionNumber() : null;
        return this.annotate(realFilePath, revisionNumber, file);
    }

    public boolean isAnnotationValid(@NotNull FilePath path, @NotNull VcsRevisionNumber revisionNumber) {
        return GitContentRevision.getRepositoryIfSubmodule(this.myProject, path) == null;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        GitFileRevision fileRevision = new GitFileRevision(this.myProject, path, (GitRevisionNumber)revision);
        VcsVirtualFile file = new VcsVirtualFile(path.getPath(), (VcsFileRevision)fileRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
        return this.annotate(path, revision, (VirtualFile)file);
    }

    private static void setProgressIndicatorText(@Nullable String text) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(text);
        }
    }

    @NotNull
    private GitFileAnnotation annotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        Object annotatedData;
        VcsRevisionNumber actualRevision;
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        VcsRevisionNumber vcsRevisionNumber = actualRevision = revision != null ? revision : vcs.getDiffProvider().getCurrentRevision(file);
        if (actualRevision != null && (annotatedData = this.myCache.getAnnotation(repositoryFilePath, GitVcs.getKey(), actualRevision)) instanceof CachedData) {
            return this.restoreFromCache(repositoryFilePath, file, actualRevision, (CachedData)annotatedData);
        }
        GitFileAnnotation fileAnnotation = this.doAnnotate(repositoryFilePath, actualRevision, file);
        if (actualRevision != null) {
            this.myCache.putAnnotation(repositoryFilePath, GitVcs.getKey(), actualRevision, (Object)this.cacheData(fileAnnotation));
        }
        return fileAnnotation;
    }

    @NotNull
    private GitFileAnnotation doAnnotate(@NotNull FilePath repositoryFilePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", file.getName()));
        VirtualFile root = GitUtil.getGitRoot(repositoryFilePath);
        GitBinaryHandler h = new GitBinaryHandler(this.myProject, root, GitCommand.BLAME);
        h.setStdoutSuppressed(true);
        h.addParameters("--porcelain", "-l", "-t");
        h.addParameters("--encoding=UTF-8");
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        if (settings.isIgnoreWhitespaces()) {
            h.addParameters("-w");
        }
        if (settings.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER) {
            h.addParameters("-M");
        } else if (settings.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER) {
            h.addParameters("-C");
        }
        if (revision == null) {
            h.addParameters("HEAD");
        } else {
            h.addParameters(revision.asString());
        }
        h.endOptions();
        h.addRelativePaths(repositoryFilePath);
        String output = new String(h.run(), CharsetToolkit.UTF8_CHARSET);
        GitFileAnnotation fileAnnotation = this.parseAnnotations(revision, file, root, output);
        this.loadFileHistoryInBackground(fileAnnotation);
        this.loadCommitMessagesFromLog(root, fileAnnotation);
        return fileAnnotation;
    }

    private void loadCommitMessagesFromLog(@NotNull VirtualFile root, @NotNull GitFileAnnotation annotation) {
        VcsLogManager logManager = VcsProjectLog.getInstance((Project)this.myProject).getLogManager();
        if (logManager == null) {
            return;
        }
        VcsLogData dataManager = logManager.getDataManager();
        IndexDataGetter getter = dataManager.getIndex().getDataGetter();
        if (getter == null) {
            return;
        }
        Set revisions = ContainerUtil.map2Set(annotation.getLines(), it -> it.getRevisionNumber());
        for (GitRevisionNumber revision : revisions) {
            int commitIndex;
            String commitMessage;
            if (annotation.getCommitMessage((VcsRevisionNumber)revision) != null || (commitMessage = getter.getFullMessage(commitIndex = dataManager.getCommitIndex(HashImpl.build((String)revision.asString()), root))) == null) continue;
            annotation.setCommitMessage((VcsRevisionNumber)revision, commitMessage);
        }
    }

    private void loadFileHistoryInBackground(@NotNull GitFileAnnotation fileAnnotation) {
        List fileRevisions = (List)BackgroundTaskUtil.computeInBackgroundAndTryWait(() -> (List)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
            try {
                VirtualFile file = fileAnnotation.getFile();
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                VcsRevisionNumber currentRevision = fileAnnotation.getCurrentRevision();
                if (file.isInLocalFileSystem() || currentRevision == null) {
                    return this.loadFileHistory(filePath);
                }
                return GitFileHistory.collectHistoryForRevision(this.myProject, filePath, currentRevision, new String[0]);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }), revisions -> {
            if (revisions == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                GitFileAnnotation newFileAnnotation = new GitFileAnnotation(fileAnnotation);
                newFileAnnotation.setRevisions((List<VcsFileRevision>)revisions);
                fileAnnotation.reload(newFileAnnotation);
            }, this.myProject.getDisposed());
        }, (long)300L);
        if (fileRevisions != null) {
            fileAnnotation.setRevisions(fileRevisions);
        }
    }

    @Nullable
    private List<VcsFileRevision> loadFileHistory(@NotNull FilePath filePath) throws VcsException {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        GitHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
        VcsAbstractHistorySession cachedSession = this.myCache.getFull(filePath, vcs.getKeyInstanceMethod(), (VcsCacheableHistorySessionFactory)historyProvider);
        if (cachedSession != null && !ContainerUtil.isEmpty((Collection)cachedSession.getRevisionList())) {
            return cachedSession.getRevisionList();
        }
        VcsAbstractHistorySession session = historyProvider.createSessionFor(filePath);
        if (session == null) {
            return null;
        }
        this.myCache.put(filePath, null, vcs.getKeyInstanceMethod(), session, (VcsCacheableHistorySessionFactory)historyProvider, true);
        return session.getRevisionList();
    }

    @NotNull
    private GitFileAnnotation parseAnnotations(@Nullable VcsRevisionNumber revision, @NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull String output) throws VcsException {
        Interner pathInterner = new Interner();
        try {
            ArrayList<GitFileAnnotation.LineInfo> lines = new ArrayList<GitFileAnnotation.LineInfo>();
            HashMap<String, GitFileAnnotation.LineInfo> commits2 = new HashMap<String, GitFileAnnotation.LineInfo>();
            StringScanner s = new StringScanner(output);
            while (s.hasMoreData()) {
                String commitHash = s.spaceToken();
                if (commitHash.equals(GitRevisionNumber.NOT_COMMITTED_HASH)) {
                    commitHash = null;
                }
                s.spaceToken();
                String s1 = s.spaceToken();
                int lineNum = Integer.parseInt(s1);
                s.nextLine();
                GitFileAnnotation.LineInfo commit2 = (GitFileAnnotation.LineInfo)commits2.get(commitHash);
                if (commit2 != null || commitHash == null) {
                    while (s.hasMoreData() && !s.startsWith('\t')) {
                        s.nextLine();
                    }
                } else {
                    Date committerDate = null;
                    FilePath filePath = null;
                    String subject = null;
                    String authorName = null;
                    String authorEmail = null;
                    Date authorDate = null;
                    String previousRevision = null;
                    FilePath previousFilePath = null;
                    while (s.hasMoreData() && !s.startsWith('\t')) {
                        int index;
                        String key = s.spaceToken();
                        String value = s.line();
                        if (SUBJECT_KEY.equals(key)) {
                            subject = value;
                            continue;
                        }
                        if (AUTHOR_KEY.equals(key)) {
                            authorName = value;
                            continue;
                        }
                        if (AUTHOR_TIME_KEY.equals(key)) {
                            authorDate = GitUtil.parseTimestamp(value);
                            continue;
                        }
                        if (COMMITTER_TIME_KEY.equals(key)) {
                            committerDate = GitUtil.parseTimestamp(value);
                            continue;
                        }
                        if (FILENAME_KEY.equals(key)) {
                            filePath = VcsUtil.getFilePath((VirtualFile)root, (String)value);
                            continue;
                        }
                        if (AUTHOR_EMAIL_KEY.equals(key)) {
                            authorEmail = value;
                            if (!authorEmail.startsWith("<") || !authorEmail.endsWith(">")) continue;
                            authorEmail = authorEmail.substring(1, authorEmail.length() - 1);
                            continue;
                        }
                        if (!PREVIOUS_KEY.equals(key) || (index = value.indexOf(32)) == -1) continue;
                        previousRevision = value.substring(0, index);
                        previousFilePath = VcsUtil.getFilePath((VirtualFile)root, (String)value.substring(index + 1));
                    }
                    if (authorDate == null || committerDate == null || filePath == null || authorName == null || authorEmail == null || subject == null) {
                        throw new VcsException("Output for line " + lineNum + " lacks necessary data");
                    }
                    GitRevisionNumber revisionNumber = new GitRevisionNumber(commitHash);
                    VcsUser author = this.myUserRegistry.createUser(authorName, authorEmail);
                    GitRevisionNumber previousRevisionNumber = previousRevision != null ? new GitRevisionNumber(previousRevision) : null;
                    filePath = (FilePath)pathInterner.intern(filePath);
                    if (previousFilePath != null) {
                        previousFilePath = (FilePath)pathInterner.intern(previousFilePath);
                    }
                    commit2 = new GitFileAnnotation.LineInfo(this.myProject, revisionNumber, filePath, committerDate, authorDate, author, subject, previousRevisionNumber, previousFilePath);
                    commits2.put(commitHash, commit2);
                }
                s.nextLine();
                int expectedLineNum = lines.size() + 1;
                if (lineNum != expectedLineNum) {
                    throw new VcsException("Adding for info for line " + lineNum + " but we are expecting it to be for " + expectedLineNum);
                }
                lines.add(commit2);
            }
            return new GitFileAnnotation(this.myProject, file, revision, lines);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Couldn't parse annotation: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output.txt", output)});
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    private GitFileAnnotation restoreFromCache(@NotNull FilePath repositoryFilePath, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull CachedData data) throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(repositoryFilePath);
        GitFileAnnotation fileAnnotation = new GitFileAnnotation(this.myProject, file, revisionNumber, data.lines);
        this.loadFileHistoryInBackground(fileAnnotation);
        this.loadCommitMessagesFromLog(root, fileAnnotation);
        return fileAnnotation;
    }

    @NotNull
    private CachedData cacheData(@NotNull GitFileAnnotation annotation) {
        return new CachedData(annotation.getLines());
    }

    private static class CachedData {
        public final List<GitFileAnnotation.LineInfo> lines;

        CachedData(List<GitFileAnnotation.LineInfo> lines) {
            this.lines = lines;
        }
    }
}

