/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBPoint;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.branch.GitCompareUtilKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0003;<=B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J0\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u00142\u0006\u0010!\u001a\u00020\u000eH\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020)J2\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H,00H\u0082\b\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u001cH\u0002J\u0010\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u000205H\u0002J\u0016\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\u000eJ\b\u00106\u001a\u00020\u001cH\u0002J\u0006\u00107\u001a\u00020\u001cJ\b\u00108\u001a\u00020\u001cH\u0002J\u0018\u00109\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010:\u001a\u00020)H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lgit4idea/branch/DeepComparator;", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "ui", "Lcom/intellij/vcs/log/VcsLogUi;", "parent", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;Lcom/intellij/openapi/Disposable;)V", "comparedBranch", "", "nonPickedCommits", "Lgnu/trove/TIntHashSet;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "dispose", "", "getRepositories", "providers", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "branchToCompare", "getStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "isSelected", "", "hasHighlightingOrInProgress", "measureTimeMillis", "R", "root", "actionName", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "notifyUnhighlight", "startTask", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "stopTask", "stopTaskAndUnhighlight", "unhighlight", "update", "refreshHappened", "Companion", "Factory", "MyTask", "intellij.vcs.git"})
public final class DeepComparator
implements VcsLogHighlighter,
Disposable {
    private ProgressIndicator progressIndicator;
    private String comparedBranch;
    private Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches;
    private TIntHashSet nonPickedCommits;
    private final Project project;
    private final GitRepositoryManager repositoryManager;
    private final VcsLogData vcsLogData;
    private final VcsLogUi ui;
    private static final Logger LOG;
    private static final String HIGHLIGHTING_CANCELLED = "Highlighting of non-picked commits has been cancelled";
    public static final Companion Companion;

    private final VcsLogStorage getStorage() {
        return this.vcsLogData.getStorage();
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, boolean isSelected) {
        block5: {
            block4: {
                if (this.nonPickedCommits == null) break block4;
                TIntHashSet tIntHashSet = this.nonPickedCommits;
                if (tIntHashSet == null) {
                    Intrinsics.throwNpe();
                }
                if (!tIntHashSet.contains(commitId)) break block5;
            }
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        return VcsCommitStyleFactory.foreground((Color)((Color)MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND));
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (this.comparedBranch == null) {
            return;
        }
        String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)dataPack.getFilters(), (VcsLogRefs)dataPack.getRefs());
        if (Intrinsics.areEqual((Object)this.comparedBranch, (Object)singleFilteredBranch) ^ true) {
            LOG.debug("Branch filter changed. Compared branch: " + this.comparedBranch + ", filtered branch: " + singleFilteredBranch);
            this.stopTaskAndUnhighlight();
            this.notifyUnhighlight();
            return;
        }
        if (refreshHappened) {
            Map<GitRepository, GitBranch> repositories;
            this.stopTask();
            Map map2 = dataPack.getLogProviders();
            String string = this.comparedBranch;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(repositories = this.getRepositories(map2, string), this.repositoriesWithCurrentBranches)) {
                this.startTask(dataPack);
            } else {
                LOG.debug("Repositories with current branches changed. Actual:\n" + repositories + "\nExpected:\n" + this.repositoriesWithCurrentBranches);
                this.unhighlight();
            }
        }
    }

    public final void startTask(@NotNull VcsLogDataPack dataPack, @NotNull String branchToCompare) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.comparedBranch != null) {
            LOG.error("Already comparing with branch " + this.comparedBranch);
            return;
        }
        Map<GitRepository, GitBranch> repositories = this.getRepositories(this.ui.getDataPack().getLogProviders(), branchToCompare);
        if (repositories.isEmpty()) {
            LOG.debug("Could not find suitable repositories for selected branch " + this.comparedBranch);
            return;
        }
        this.comparedBranch = branchToCompare;
        this.repositoriesWithCurrentBranches = repositories;
        this.startTask(dataPack);
    }

    public final void stopTaskAndUnhighlight() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopTask();
        this.unhighlight();
    }

    public final boolean hasHighlightingOrInProgress() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.comparedBranch != null;
    }

    private final void startTask(VcsLogDataPack dataPack) {
        LOG.debug("Highlighting requested for " + this.repositoriesWithCurrentBranches);
        Map<GitRepository, ? extends GitBranch> map2 = this.repositoriesWithCurrentBranches;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        String string = this.comparedBranch;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MyTask task = new MyTask(map2, dataPack, string);
        this.progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task;
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            Intrinsics.throwNpe();
        }
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void stopTask() {
        if (this.progressIndicator != null) {
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator == null) {
                Intrinsics.throwNpe();
            }
            progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }

    private final void unhighlight() {
        this.nonPickedCommits = null;
        this.comparedBranch = null;
        this.repositoriesWithCurrentBranches = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, GitBranch> getRepositories(Map<VirtualFile, ? extends VcsLogProvider> providers, String branchToCompare) {
        void $receiver$iv$iv;
        GitRepository gitRepository;
        Object it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)providers.keySet();
        Iterable destination$iv$iv = new ArrayList();
        Iterator $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if ((GitRepository)this.repositoryManager.getRepositoryForRoot((VirtualFile)it) == null) continue;
            GitRepository it$iv$iv = gitRepository;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            GitRepository repository = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(repository.getCurrentBranch() != null && repository.getBranches().findBranchByName(branchToCompare) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv2;
            it = (GitRepository)element$iv$iv;
            boolean bl = false;
            GitLocalBranch gitLocalBranch = it.getCurrentBranch();
            if (gitLocalBranch == null) {
                Intrinsics.throwNpe();
            }
            gitRepository = new Pair(it, (Object)gitLocalBranch);
            map2.put(gitRepository.getFirst(), gitRepository.getSecond());
        }
        return destination$iv$iv2;
    }

    private final void notifyUnhighlight() {
        if (this.ui instanceof AbstractVcsLogUi) {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(HIGHLIGHTING_CANCELLED, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(5000L).createBalloon();
            VcsLogGraphTable component = ((AbstractVcsLogUi)this.ui).getTable();
            balloon.show(new RelativePoint((Component)component, (Point)new JBPoint(component.getWidth() / 2, component.getVisibleRect().y)), Balloon.Position.below);
            Disposer.register((Disposable)this, (Disposable)((Disposable)balloon));
        }
    }

    public void dispose() {
        this.stopTaskAndUnhighlight();
    }

    private final <R> R measureTimeMillis(VirtualFile root, String actionName, Function0<? extends R> block) {
        int $i$f$measureTimeMillis = 0;
        long start = System.currentTimeMillis();
        Object result2 = block.invoke();
        if (result2 != null) {
            DeepComparator.LOG.debug(actionName + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start)) + " for " + root.getName());
        }
        return (R)result2;
    }

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogData vcsLogData, @NotNull VcsLogUi ui, @NotNull Disposable parent) {
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.vcsLogData = vcsLogData;
        this.ui = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(DeepComparator.class);
    }

    public static final /* synthetic */ ProgressIndicator access$getProgressIndicator$p(DeepComparator $this) {
        return $this.progressIndicator;
    }

    public static final /* synthetic */ TIntHashSet access$getNonPickedCommits$p(DeepComparator $this) {
        return $this.nonPickedCommits;
    }

    public static final /* synthetic */ Object access$measureTimeMillis(DeepComparator $this, VirtualFile root, String actionName, Function0 block) {
        return $this.measureTimeMillis(root, actionName, block);
    }

    @JvmStatic
    @NotNull
    public static final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi) {
        return Companion.getInstance(project, dataProvider, logUi);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J<\u0010\u001a\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\tH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgit4idea/branch/DeepComparator$MyTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/GitBranch;", "vcsLogDataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "comparedBranch", "", "(Lgit4idea/branch/DeepComparator;Ljava/util/Map;Lcom/intellij/vcs/log/VcsLogDataPack;Ljava/lang/String;)V", "collectedNonPickedCommits", "Lgnu/trove/TIntHashSet;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "getCommitsByIndexFast", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceBranch", "getCommitsByIndexReliable", "targetBranch", "getCommitsByPatch", "getCommitsFromGit", "currentBranch", "getCommitsFromIndex", "sourceBranchRef", "Lcom/intellij/vcs/log/VcsRef;", "targetBranchRef", "sourceBranchCommits", "reliable", "", "onFinished", "", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.vcs.git"})
    private final class MyTask
    extends Task.Backgroundable {
        private final DataPack dataPack;
        private final TIntHashSet collectedNonPickedCommits;
        private VcsException exception;
        private final Map<GitRepository, GitBranch> repositoriesWithCurrentBranches;
        private final String comparedBranch;

        public void run(@NotNull ProgressIndicator indicator) {
            try {
                this.repositoriesWithCurrentBranches.forEach(new BiConsumer<GitRepository, GitBranch>(this){
                    final /* synthetic */ MyTask this$0;

                    public final void accept(@NotNull GitRepository repo, @NotNull GitBranch currentBranch) {
                        TIntHashSet tIntHashSet;
                        if (Registry.is((String)"git.log.use.index.for.picked.commits.highlighting")) {
                            if (Registry.is((String)"git.log.fast.picked.commits.highlighting")) {
                                tIntHashSet = MyTask.access$getCommitsByIndexFast(this.this$0, repo.getRoot(), MyTask.access$getComparedBranch$p(this.this$0));
                                if (tIntHashSet == null) {
                                    tIntHashSet = MyTask.access$getCommitsByIndexReliable(this.this$0, repo.getRoot(), MyTask.access$getComparedBranch$p(this.this$0), currentBranch.getName());
                                }
                            } else {
                                tIntHashSet = MyTask.access$getCommitsByIndexReliable(this.this$0, repo.getRoot(), MyTask.access$getComparedBranch$p(this.this$0), currentBranch.getName());
                            }
                        } else {
                            tIntHashSet = MyTask.access$getCommitsByPatch(this.this$0, repo.getRoot(), MyTask.access$getComparedBranch$p(this.this$0), currentBranch.getName());
                        }
                        TIntHashSet commits2 = tIntHashSet;
                        TroveUtil.addAll((TIntHashSet)MyTask.access$getCollectedNonPickedCommits$p(this.this$0), (TIntHashSet)commits2);
                    }
                    {
                        this.this$0 = myTask;
                    }
                });
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.exception = e;
            }
        }

        public void onFinished() {
            DeepComparator.this.progressIndicator = null;
        }

        public void onSuccess() {
            if (this.exception != null) {
                DeepComparator.this.nonPickedCommits = null;
                VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.getProject());
                String string = "Couldn't compare with branch " + this.comparedBranch;
                VcsException vcsException = this.exception;
                if (vcsException == null) {
                    Intrinsics.throwNpe();
                }
                vcsNotifier.notifyError(string, vcsException.getMessage());
                return;
            }
            DeepComparator.this.nonPickedCommits = this.collectedNonPickedCommits;
        }

        private final TIntHashSet getCommitsByPatch(VirtualFile root, String targetBranch, String sourceBranch) {
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with git";
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            TIntHashSet result$iv = this.getCommitsFromGit(root, targetBranch, sourceBranch);
            if (result$iv != null) {
                LOG.debug(actionName$iv + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start$iv)) + " for " + root.getName());
            }
            return result$iv;
        }

        private final TIntHashSet getCommitsByIndexReliable(VirtualFile root, String sourceBranch, String targetBranch) {
            TIntHashSet resultFromIndex;
            TIntHashSet tIntHashSet;
            TIntHashSet resultFromGit = this.getCommitsByPatch(root, targetBranch, sourceBranch);
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with index reliable";
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            DataPack dataPack = this.dataPack;
            if (dataPack == null || (dataPack = dataPack.getRefsModel()) == null || (dataPack = DataPackUtilKt.findBranch((RefsModel)dataPack, (String)sourceBranch, (VirtualFile)root)) == null) {
                return resultFromGit;
            }
            DataPack sourceBranchRef = dataPack;
            VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)this.dataPack.getRefsModel(), (String)"HEAD", (VirtualFile)root);
            if (vcsRef == null) {
                return resultFromGit;
            }
            VcsRef targetBranchRef = vcsRef;
            TIntHashSet result$iv = this.getCommitsFromIndex(this.dataPack, root, (VcsRef)sourceBranchRef, targetBranchRef, resultFromGit, true);
            if (result$iv != null) {
                LOG.debug(actionName$iv + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start$iv)) + " for " + root.getName());
            }
            if ((tIntHashSet = (resultFromIndex = result$iv)) == null) {
                tIntHashSet = resultFromGit;
            }
            return tIntHashSet;
        }

        private final TIntHashSet getCommitsByIndexFast(VirtualFile root, String sourceBranch) {
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) {
                return null;
            }
            DeepComparator deepComparator = DeepComparator.this;
            String actionName$iv = "Getting non picked commits with index fast";
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            DataPack dataPack = this.dataPack;
            if (dataPack == null || (dataPack = dataPack.getRefsModel()) == null || (dataPack = DataPackUtilKt.findBranch((RefsModel)dataPack, (String)sourceBranch, (VirtualFile)root)) == null) {
                return null;
            }
            DataPack sourceBranchRef = dataPack;
            VcsRef vcsRef = DataPackUtilKt.findBranch((RefsModel)this.dataPack.getRefsModel(), (String)"HEAD", (VirtualFile)root);
            if (vcsRef == null) {
                return null;
            }
            VcsRef targetBranchRef = vcsRef;
            TIntHashSet tIntHashSet = DataPackUtilKt.subgraphDifference((DataPack)this.dataPack, (VcsRef)sourceBranchRef, (VcsRef)targetBranchRef, (VcsLogStorage)DeepComparator.this.getStorage());
            if (tIntHashSet == null) {
                return null;
            }
            TIntHashSet sourceBranchCommits = tIntHashSet;
            TIntHashSet result$iv = this.getCommitsFromIndex(this.dataPack, root, (VcsRef)sourceBranchRef, targetBranchRef, sourceBranchCommits, false);
            if (result$iv != null) {
                LOG.debug(actionName$iv + " took " + StopWatch.formatTime((long)(System.currentTimeMillis() - start$iv)) + " for " + root.getName());
            }
            return result$iv;
        }

        private final TIntHashSet getCommitsFromGit(VirtualFile root, String currentBranch, String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(this.getProject(), root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            TIntHashSet pickedCommits = new TIntHashSet();
            handler.addLineListener(new GitLineHandlerListener(this, pickedCommits, root){
                final /* synthetic */ MyTask this$0;
                final /* synthetic */ TIntHashSet $pickedCommits;
                final /* synthetic */ VirtualFile $root;

                /*
                 * WARNING - void declaration
                 */
                public final void onLineAvailable(String l, Key<Object> $noName_1) {
                    String line = l;
                    if (StringsKt.startsWith$default((String)line, (String)"+", (boolean)false, (int)2, null)) {
                        try {
                            int firstSpace;
                            void $receiver$iv;
                            String string = line;
                            int n = 2;
                            String string2 = string;
                            if (string2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = string2.substring(n);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                            string = string3;
                            CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $receiver$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = it <= ' ';
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if ((firstSpace = StringsKt.indexOf$default((CharSequence)(line = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)' ', (int)0, (boolean)false, (int)6, null)) > 0) {
                                String string4 = line;
                                int n2 = 0;
                                String string5 = string4;
                                if (string5 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string6 = string5.substring(n2, firstSpace);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                line = string6;
                            }
                            this.$pickedCommits.add(DeepComparator.access$getStorage$p(this.this$0.DeepComparator.this).getCommitIndex(HashImpl.build((String)line), this.$root));
                        }
                        catch (Exception e) {
                            DeepComparator.access$getLOG$cp().error("Couldn't parse line [" + line + ']');
                        }
                    }
                }
                {
                    this.this$0 = myTask;
                    this.$pickedCommits = tIntHashSet;
                    this.$root = virtualFile;
                }
            });
            Git.getInstance().runCommandWithoutCollectingOutput(handler);
            return pickedCommits;
        }

        private final TIntHashSet getCommitsFromIndex(DataPack dataPack, VirtualFile root, VcsRef sourceBranchRef, VcsRef targetBranchRef, TIntHashSet sourceBranchCommits, boolean reliable) {
            if (dataPack == null) {
                return null;
            }
            if (sourceBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) {
                return null;
            }
            IndexDataGetter indexDataGetter = DeepComparator.this.vcsLogData.getIndex().getDataGetter();
            if (indexDataGetter == null) {
                return null;
            }
            IndexDataGetter dataGetter = indexDataGetter;
            TIntHashSet tIntHashSet = DataPackUtilKt.subgraphDifference((DataPack)dataPack, (VcsRef)targetBranchRef, (VcsRef)sourceBranchRef, (VcsLogStorage)DeepComparator.this.getStorage());
            if (tIntHashSet == null) {
                return null;
            }
            TIntHashSet targetBranchCommits = tIntHashSet;
            if (targetBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            TIntHashSet match2 = GitCompareUtilKt.match(dataGetter, root, sourceBranchCommits, targetBranchCommits, reliable);
            TroveUtil.removeAll((TIntHashSet)sourceBranchCommits, (TIntHashSet)match2);
            if (!match2.isEmpty()) {
                LOG.debug("Using index, detected " + match2.size() + " commits in " + sourceBranchRef.getName() + '#' + root.getName() + " that were picked to the current branch" + (reliable ? " with different patch id but matching cherry-picked suffix" : " with matching author, author time and message"));
            }
            return sourceBranchCommits;
        }

        @NotNull
        public String toString() {
            return "Task for '" + this.comparedBranch + "' in " + this.repositoriesWithCurrentBranches;
        }

        public MyTask(@NotNull Map<GitRepository, ? extends GitBranch> repositoriesWithCurrentBranches, @NotNull VcsLogDataPack vcsLogDataPack, String comparedBranch) {
            super(DeepComparator.this.project, "Comparing Branches...");
            this.repositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.comparedBranch = comparedBranch;
            VcsLogDataPack vcsLogDataPack2 = vcsLogDataPack;
            if (!(vcsLogDataPack2 instanceof VisiblePack)) {
                vcsLogDataPack2 = null;
            }
            VisiblePack visiblePack = (VisiblePack)vcsLogDataPack2;
            Object object = visiblePack != null ? visiblePack.getDataPack() : null;
            if (!(object instanceof DataPack)) {
                object = null;
            }
            this.dataPack = (DataPack)object;
            this.collectedNonPickedCommits = new TIntHashSet();
        }

        public static final /* synthetic */ TIntHashSet access$getCommitsByIndexFast(MyTask $this, VirtualFile root, String sourceBranch) {
            return $this.getCommitsByIndexFast(root, sourceBranch);
        }

        public static final /* synthetic */ String access$getComparedBranch$p(MyTask $this) {
            return $this.comparedBranch;
        }

        public static final /* synthetic */ TIntHashSet access$getCommitsByIndexReliable(MyTask $this, VirtualFile root, String sourceBranch, String targetBranch) {
            return $this.getCommitsByIndexReliable(root, sourceBranch, targetBranch);
        }

        public static final /* synthetic */ TIntHashSet access$getCommitsByPatch(MyTask $this, VirtualFile root, String targetBranch, String sourceBranch) {
            return $this.getCommitsByPatch(root, targetBranch, sourceBranch);
        }

        public static final /* synthetic */ TIntHashSet access$getCollectedNonPickedCommits$p(MyTask $this) {
            return $this.collectedNonPickedCommits;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/branch/DeepComparator$Factory;", "Lcom/intellij/vcs/log/ui/highlighters/VcsLogHighlighterFactory;", "()V", "createHighlighter", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "logDataManager", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getId", "", "getTitle", "showMenuItem", "", "intellij.vcs.git"})
    public static final class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logDataManager, @NotNull VcsLogUi logUi) {
            return Companion.getInstance(logDataManager.getProject(), logDataManager, logUi);
        }

        @NotNull
        public String getId() {
            return "CHERRY_PICKED_COMMITS";
        }

        @NotNull
        public String getTitle() {
            return "Cherry Picked Commits";
        }

        public boolean showMenuItem() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/branch/DeepComparator$Companion;", "", "()V", "HIGHLIGHTING_CANCELLED", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lgit4idea/branch/DeepComparator;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi) {
            return ((DeepComparatorHolder)ServiceManager.getService((Project)project, DeepComparatorHolder.class)).getInstance(dataProvider, logUi);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

