/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || ui == null || dataProvider == null) {
            return false;
        }
        return DeepComparator.getInstance(project, dataProvider, ui).hasHighlightingOrInProgress();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || ui == null || dataProvider == null) {
            return;
        }
        DeepComparator dc = DeepComparator.getInstance(project, dataProvider, ui);
        if (selected) {
            VcsLogUsageTriggerCollector.triggerUsage((AnActionEvent)e, (Object)((Object)this));
            VcsLogDataPack dataPack = ui.getDataPack();
            String singleBranchName = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)ui.getFilterUi().getFilters(), (VcsLogRefs)dataPack.getRefs());
            if (singleBranchName == null) {
                DeepCompareAction.selectBranchAndPerformAction(ui, e, (Consumer<String>)((Consumer)selectedBranch -> {
                    ui.getFilterUi().setFilter((VcsLogFilter)VcsLogFilterObject.fromBranch((String)selectedBranch));
                    dc.startTask(dataPack, (String)selectedBranch);
                }), DeepCompareAction.getGitRoots(project, ui));
                return;
            }
            dc.startTask(dataPack, singleBranchName);
        } else {
            dc.stopTaskAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogUi ui, @NotNull AnActionEvent event, final @NotNull Consumer<String> consumer, @NotNull Collection<VirtualFile> visibleRoots) {
        VcsLogDataPack dataPack = ui.getDataPack();
        ActionGroup actionGroup = new BranchPopupBuilder(dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull String name, @NotNull Collection<? extends VcsRef> refs) {
                return new DumbAwareAction(name){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        consumer.consume((Object)name);
                    }
                };
            }
        }.build();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Select Branch to Compare", actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else if (ui instanceof AbstractVcsLogUi) {
            popup.showInCenterOf((Component)((AbstractVcsLogUi)ui).getTable());
        } else {
            popup.showInBestPositionFor(event.getDataContext());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            Set visibleRoots = VcsLogUtil.getVisibleRoots((VcsLogUi)ui);
            Set allRoots = visibleRoots;
            if (allRoots.isEmpty()) {
                allRoots = ContainerUtil.map2Set((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots(), VcsRoot::getPath);
            }
            e.getPresentation().setEnabled(DeepCompareAction.hasGitRoots(project, visibleRoots));
            e.getPresentation().setVisible(DeepCompareAction.hasGitRoots(project, allRoots));
        }
    }

    @NotNull
    private static Collection<VirtualFile> getGitRoots(@NotNull Project project, @NotNull VcsLogUi ui) {
        return ContainerUtil.filter((Collection)VcsLogUtil.getVisibleRoots((VcsLogUi)ui), root -> DeepCompareAction.isGitRoot(project, root));
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
        return ContainerUtil.exists(roots, root -> DeepCompareAction.isGitRoot(project, root));
    }

    private static boolean isGitRoot(@NotNull Project project, @NotNull VirtualFile root) {
        return GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root) != null;
    }
}

