/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchIncomingOutgoingManager
implements GitRepositoryChangeListener,
GitAuthenticationListener {
    private static final Logger LOG = Logger.getInstance(GitBranchIncomingOutgoingManager.class);
    @NotNull
    private final Object LOCK = new Object();
    @NotNull
    private final Set<GitRepository> myDirtyReposPull = new HashSet<GitRepository>();
    @NotNull
    private final Set<GitRepository> myDirtyReposPush = new HashSet<GitRepository>();
    private boolean myUseForceAuthentication;
    @NotNull
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToPull = ContainerUtil.newConcurrentMap();
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToPush = ContainerUtil.newConcurrentMap();
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myErrorMap = MultiMap.createConcurrentSet();
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitVcsSettings myGitSettings;
    @Nullable
    private ScheduledFuture<?> myPeriodicalUpdater;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @Nullable
    private MessageBusConnection myConnection;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myAuthSuccessMap = MultiMap.createConcurrentSet();

    GitBranchIncomingOutgoingManager(@NotNull Project project, @NotNull Git git, @NotNull GitVcsSettings gitProjectSettings, @NotNull GitRepositoryManager repositoryManager) {
        this.myProject = project;
        this.myGit = git;
        this.myGitSettings = gitProjectSettings;
        this.myRepositoryManager = repositoryManager;
        this.myQueue = new MergingUpdateQueue("GitBranchIncomingOutgoingManager", 1000, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public boolean hasIncomingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        return this.getBranchesToPull(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean hasOutgoingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        return this.getBranchesToPush(repository).contains(new GitLocalBranch(localBranchName));
    }

    @NotNull
    public static GitBranchIncomingOutgoingManager getInstance(@NotNull Project project) {
        return (GitBranchIncomingOutgoingManager)ServiceManager.getService((Project)project, GitBranchIncomingOutgoingManager.class);
    }

    public boolean hasAuthenticationProblems() {
        return !this.myErrorMap.isEmpty();
    }

    public boolean supportsIncomingOutgoing() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public void startScheduling() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myConnection == null) {
                this.myConnection = this.myProject.getMessageBus().connect();
                this.myConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
                this.myConnection.subscribe(GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS, (Object)this);
            }
            this.forceUpdateBranches(false);
            if (this.myPeriodicalUpdater == null) {
                int updateTime = this.myGitSettings.getBranchInfoUpdateTime();
                this.myPeriodicalUpdater = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateBranchesToPull(), updateTime, updateTime, TimeUnit.MINUTES);
                Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                    public void dispose() {
                        GitBranchIncomingOutgoingManager.this.stopScheduling();
                    }
                });
            }
        });
    }

    public void stopScheduling() {
        if (this.myPeriodicalUpdater != null) {
            this.myPeriodicalUpdater.cancel(true);
            this.myPeriodicalUpdater = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdateBranches(boolean useForceAuthentication) {
        Object object = this.LOCK;
        synchronized (object) {
            if (useForceAuthentication) {
                this.myUseForceAuthentication = true;
            }
            List<GitRepository> repositories = this.myRepositoryManager.getRepositories();
            this.myDirtyReposPull.addAll(repositories);
            this.myDirtyReposPush.addAll(repositories);
        }
        this.scheduleUpdate();
        new Task.Backgroundable(this.myProject, "Update Branches Info..."){

            public void run(@NotNull ProgressIndicator indicator) {
                Semaphore semaphore = new Semaphore(0);
                GitBranchIncomingOutgoingManager.this.myQueue.queue(Update.create((Object)((Object)this), () -> semaphore.release()));
                GitBranchIncomingOutgoingManager.this.myQueue.flush();
                try {
                    while (!indicator.isCanceled() && !semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }
        }.queue();
    }

    private void scheduleUpdate() {
        if (!this.myGitSettings.shouldUpdateBranchInfo()) {
            return;
        }
        this.myQueue.queue(Update.create((Object)"update", () -> {
            boolean useForceAuthentication;
            ArrayList<GitRepository> toPush;
            ArrayList<GitRepository> toPull;
            Object object = this.LOCK;
            synchronized (object) {
                toPull = new ArrayList<GitRepository>(this.myDirtyReposPull);
                toPush = new ArrayList<GitRepository>(this.myDirtyReposPush);
                useForceAuthentication = this.myUseForceAuthentication;
                this.myDirtyReposPull.clear();
                this.myDirtyReposPush.clear();
                this.myUseForceAuthentication = false;
            }
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
                for (GitRepository r : toPush) {
                    this.myLocalBranchesToPush.put(r, this.calculateBranchesToPush(r));
                }
                for (GitRepository r : toPull) {
                    this.myLocalBranchesToPull.put(r, this.calculateBranchesToPull(r, useForceAuthentication));
                }
            });
        }));
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesToPull(@Nullable GitRepository repository) {
        return GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesToPull);
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesToPush(@Nullable GitRepository repository) {
        return GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesToPush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesToPull() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposPull.addAll(this.myRepositoryManager.getRepositories());
        }
        this.scheduleUpdate();
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToPull(@NotNull GitRepository repository, boolean useForceAuthentication) {
        HashMap result2 = ContainerUtil.newHashMap();
        GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository).entrySet().forEach(entry -> result2.putAll(this.calcBranchesToPullForRemote(repository, (GitRemote)entry.getKey(), (Collection)entry.getValue(), this.getAuthenticationMode(repository, (GitRemote)entry.getKey(), useForceAuthentication))));
        return result2;
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calcBranchesToPullForRemote(@NotNull GitRepository repository, @NotNull GitRemote gitRemote, @NotNull Collection<GitBranchTrackInfo> trackInfoList, GitAuthenticationMode mode) {
        HashMap result2 = ContainerUtil.newHashMap();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<String, Hash> remoteNameWithHash = this.lsRemote(repository, gitRemote, ContainerUtil.map(trackInfoList, info -> info.getRemoteBranch().getNameForRemoteOperations()), mode);
        for (Map.Entry<String, Hash> hashEntry : remoteNameWithHash.entrySet()) {
            String remoteBranchName = hashEntry.getKey();
            Hash remoteHash = hashEntry.getValue();
            trackInfoList.forEach(info -> {
                GitRemoteBranch remoteBranch = info.getRemoteBranch();
                Hash localHashForRemoteBranch = branchesCollection.getHash(remoteBranch);
                Hash localHash = branchesCollection.getHash(info.getLocalBranch());
                if (localHashForRemoteBranch == null) {
                    return;
                }
                if (StringUtil.equals((CharSequence)remoteBranchName, (CharSequence)GitRefUtil.addRefsHeadsPrefixIfNeeded(remoteBranch.getNameForRemoteOperations()))) {
                    if (!localHashForRemoteBranch.equals(remoteHash)) {
                        result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                    } else if (this.hasCommitsForBranch(repository, info.getLocalBranch(), localHash, localHashForRemoteBranch, true)) {
                        result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                    }
                }
            });
        }
        return result2;
    }

    @NotNull
    private GitAuthenticationMode getAuthenticationMode(@NotNull GitRepository repository, @NotNull GitRemote remote, boolean useForceAuthentication) {
        if (useForceAuthentication) {
            return GitAuthenticationMode.FULL;
        }
        if (this.myAuthSuccessMap.get((Object)repository).contains(remote)) {
            return GitAuthenticationMode.SILENT;
        }
        return GitAuthenticationMode.NONE;
    }

    @NotNull
    private Map<String, Hash> lsRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> branchRefNames, @NotNull GitAuthenticationMode authenticationMode) {
        HashMap result2 = ContainerUtil.newHashMap();
        if (!this.supportsIncomingOutgoing()) {
            return result2;
        }
        if (authenticationMode == GitAuthenticationMode.NONE) {
            this.myErrorMap.putValue((Object)repository, (Object)remote);
            return result2;
        }
        VcsFileUtil.chunkArguments(branchRefNames).forEach(refs -> {
            ArrayList params = ContainerUtil.newArrayList((Object[])new String[]{"--heads", remote.getName()});
            params.addAll(refs);
            GitCommandResult lsRemoteResult = this.myGit.runCommand((Computable<GitLineHandler>)((Computable)() -> this.createLsRemoteHandler(repository, remote, params, authenticationMode)));
            if (lsRemoteResult.success()) {
                Map hashWithNameMap = ContainerUtil.map2MapNotNull(lsRemoteResult.getOutput(), GitRefUtil::parseRefsLine);
                result2.putAll(GitRefUtil.getResolvedHashes(hashWithNameMap));
                this.myErrorMap.remove((Object)repository, (Object)remote);
                this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
            } else {
                this.myErrorMap.putValue((Object)repository, (Object)remote);
            }
        });
        return result2;
    }

    @NotNull
    private GitLineHandler createLsRemoteHandler(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> params, @NotNull GitAuthenticationMode authenticationMode) {
        GitLineHandler h = new GitLineHandler(this.myProject, repository.getRoot(), GitCommand.LS_REMOTE, authenticationMode == GitAuthenticationMode.NONE ? Collections.singletonList("credential.helper=") : ContainerUtil.emptyList());
        h.setIgnoreAuthenticationMode(authenticationMode);
        h.addParameters(params);
        h.setUrls(remote.getUrls());
        return h;
    }

    private boolean shouldUpdateBranchesToPull(@NotNull GitRepository repository) {
        Map<GitLocalBranch, Hash> cachedBranchesToPull = this.myLocalBranchesToPull.get(repository);
        return cachedBranchesToPull == null || ContainerUtil.exists(repository.getBranchTrackInfos(), info -> !Objects.equals(repository.getBranches().getHash(info.getRemoteBranch()), cachedBranchesToPull.get(info.getLocalBranch())));
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToPush(@NotNull GitRepository gitRepository) {
        HashMap branchesToPush = ContainerUtil.newHashMap();
        GitBranchesCollection branchesCollection = gitRepository.getBranches();
        for (GitLocalBranch branch : branchesCollection.getLocalBranches()) {
            Hash localHashForRemoteBranch;
            GitPushTarget pushTarget = GitPushSupport.getPushTargetIfExist(gitRepository, branch);
            Hash hash = localHashForRemoteBranch = pushTarget != null ? branchesCollection.getHash(pushTarget.getBranch()) : null;
            Hash localHash = branchesCollection.getHash(branch);
            if (!this.hasCommitsForBranch(gitRepository, branch, localHash, localHashForRemoteBranch, false)) continue;
            branchesToPush.put(branch, localHashForRemoteBranch);
        }
        return branchesToPush;
    }

    private boolean hasCommitsForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch localBranch, @Nullable Hash localBranchHash, @Nullable Hash localHashForRemoteBranch, boolean incoming) {
        if (!this.supportsIncomingOutgoing()) {
            return false;
        }
        if (localHashForRemoteBranch == null || Objects.equals(localBranchHash, localHashForRemoteBranch)) {
            return false;
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        handler.setSilent(true);
        String branchName = localBranch.getName();
        handler.addParameters("--count", incoming ? branchName + ".." + branchName + "@{u}" : localHashForRemoteBranch.asString() + ".." + branchName);
        try {
            String output = this.myGit.runCommand(handler).getOutputOrThrow(new int[0]).trim();
            return !StringUtil.startsWithChar((CharSequence)output, (char)'0');
        }
        catch (VcsException e) {
            LOG.warn("Can't get outgoing info (git rev-list " + branchName + " failed):" + e.getMessage());
            return false;
        }
    }

    @NotNull
    private static Collection<GitLocalBranch> getBranches(@Nullable GitRepository repository, @NotNull Map<GitRepository, Map<GitLocalBranch, Hash>> branchCollection) {
        if (repository != null) {
            Map<GitLocalBranch, Hash> branchHashMap = branchCollection.get(repository);
            return branchHashMap != null ? branchHashMap.keySet() : Collections.emptySet();
        }
        return (Collection)StreamEx.of(branchCollection.values()).flatMap(StreamEx::ofKeys).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryChanged(@NotNull GitRepository repository) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposPush.add(repository);
            if (this.shouldUpdateBranchesToPull(repository)) {
                this.myDirtyReposPull.add(repository);
            }
        }
        this.scheduleUpdate();
    }

    @Override
    public void authenticationSucceeded(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        MultiMap<GitRemote, GitBranchTrackInfo> trackInfoByRemotes;
        Collection remotes = this.myErrorMap.get((Object)repository);
        this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
        if (remotes.contains(remote) && (trackInfoByRemotes = GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository)).containsKey((Object)remote)) {
            Map<GitLocalBranch, Hash> newBranchMap = this.calcBranchesToPullForRemote(repository, remote, trackInfoByRemotes.get((Object)remote), GitAuthenticationMode.SILENT);
            this.myLocalBranchesToPull.compute(repository, (r, branchHashMap) -> {
                if (branchHashMap == null) {
                    return ContainerUtil.newHashMap((Map)newBranchMap);
                }
                branchHashMap.putAll(newBranchMap);
                return branchHashMap;
            });
        }
    }

    @NotNull
    private static MultiMap<GitRemote, GitBranchTrackInfo> groupTrackInfoByRemotes(@NotNull GitRepository repository) {
        return ContainerUtil.groupBy(repository.getBranchTrackInfos(), GitBranchTrackInfo::getRemote);
    }
}

