/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDialog;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCheckoutNewBranchOperation;
import git4idea.branch.GitCheckoutOperation;
import git4idea.branch.GitCreateBranchOperation;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.branch.GitDeleteRemoteBranchOperation;
import git4idea.branch.GitDeleteRemoteTagOperation;
import git4idea.branch.GitDeleteTagOperation;
import git4idea.branch.GitMergeOperation;
import git4idea.branch.GitRebaseParams;
import git4idea.branch.GitRenameBranchOperation;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.history.GitHistoryUtils;
import git4idea.history.GitStringInterner;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesHelper;
import git4idea.util.GitLocalCommitCompareInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitBranchWorker {
    private static final Logger LOG = Logger.getInstance(GitBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitBranchUiHandler myUiHandler;
    @NotNull
    private final GitVcs myVcs;

    public GitBranchWorker(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler) {
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myVcs = GitVcs.getInstance(this.myProject);
    }

    public void checkoutNewBranch(@NotNull String name, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        repositories = ContainerUtil.filter(repositories, repository -> {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            return currentBranch == null || !currentBranch.getName().equals(name);
        });
        if (!repositories.isEmpty()) {
            new GitCheckoutNewBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, name).execute();
        } else {
            LOG.error("Creating new branch the same as current in all repositories: " + name);
        }
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        GitBranchWorker.updateInfo(startPoints.keySet());
        new GitCreateBranchOperation(this.myProject, this.myGit, this.myUiHandler, name, startPoints).execute();
    }

    public void createNewTag(@NotNull String name, @NotNull String reference, @NotNull List<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            this.myGit.createNewTag(repository, name, null, reference);
            repository.getRepositoryFiles().refreshTagsFiles();
        }
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, startPoint, false, true, newBranchName).execute();
    }

    public void checkout(@NotNull String reference, boolean detach, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories, reference, detach, false, null).execute();
    }

    public void deleteBranch(@NotNull String branchName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void deleteTag(@NotNull String tagName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories, tagName).execute();
    }

    public void deleteRemoteTag(@NotNull String tagName, @NotNull Map<GitRepository, String> repositories) {
        GitBranchWorker.updateInfo(repositories.keySet());
        new GitDeleteRemoteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories, tagName).execute();
    }

    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteRemoteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void merge(@NotNull String branchName, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitMergeOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branchName, deleteOnMerge).execute();
    }

    public void rebase(@NotNull List<GitRepository> repositories, @NotNull String branchName) {
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(this.myVcs.getVersion(), branchName), this.myUiHandler.getProgressIndicator());
    }

    public void rebaseOnCurrent(@NotNull List<GitRepository> repositories, @NotNull String branchName) {
        GitBranchWorker.updateInfo(repositories);
        GitRebaseUtils.rebase(this.myProject, repositories, new GitRebaseParams(this.myVcs.getVersion(), branchName, null, "HEAD", false, false), this.myUiHandler.getProgressIndicator());
    }

    public void renameBranch(@NotNull String currentName, @NotNull String newName, @NotNull List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitRenameBranchOperation(this.myProject, this.myGit, this.myUiHandler, currentName, newName, repositories).execute();
    }

    public void compare(@NotNull String branchName, @NotNull List<GitRepository> repositories, @NotNull GitRepository selectedRepository) {
        try {
            CommitCompareInfo myCompareInfo = this.loadCommitsToCompare(repositories, branchName);
            ApplicationManager.getApplication().invokeLater(() -> this.displayCompareDialog(branchName, GitBranchUtil.getCurrentBranchOrRev(repositories), myCompareInfo, selectedRepository));
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Can't Compare with Branch", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CommitCompareInfo loadCommitsToCompare(List<GitRepository> repositories, String branchName) throws VcsException {
        GitStringInterner.clearAndEnable();
        try {
            GitLocalCommitCompareInfo compareInfo = new GitLocalCommitCompareInfo(this.myProject, branchName);
            for (GitRepository repository : repositories) {
                List<GitCommit> headToBranch = GitHistoryUtils.history(this.myProject, repository.getRoot(), ".." + branchName);
                List<GitCommit> branchToHead = GitHistoryUtils.history(this.myProject, repository.getRoot(), branchName + "..");
                compareInfo.put(repository, headToBranch, branchToHead);
                compareInfo.putTotalDiff(repository, GitBranchWorker.loadTotalDiff(repository, branchName));
            }
            Object object = compareInfo;
            return object;
        }
        finally {
            GitStringInterner.clearAndDisable();
        }
    }

    @NotNull
    public static Collection<Change> loadTotalDiff(@NotNull Repository repository, @NotNull String branchName) throws VcsException {
        return GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), branchName, null, true);
    }

    private void displayCompareDialog(@NotNull String branchName, @NotNull String currentBranch, @NotNull CommitCompareInfo compareInfo, @NotNull GitRepository selectedRepository) {
        if (compareInfo.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)String.format("<html>There are no changes between <code>%s</code> and <code>%s</code></html>", currentBranch, branchName), (String)"No Changes Detected");
        } else {
            new CompareBranchesDialog((CompareBranchesHelper)new GitCompareBranchesHelper(this.myProject), branchName, currentBranch, compareInfo, (Repository)selectedRepository, false).show();
        }
    }

    private static void updateInfo(@NotNull Collection<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }
}

