/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\u001a,\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\r\u001a@\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"suffixPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "suffixStart", "", "match", "Lgnu/trove/TIntHashSet;", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceBranchCommits", "targetBranchCommits", "reliable", "", "selectSourceCommits", "", "", "targetCommit", "sourceCandidates", "sourceCandidatesExtended", "intellij.vcs.git"})
public final class GitCompareUtilKt {
    private static final String suffixStart = "cherry picked from commit";
    private static final Pattern suffixPattern = Pattern.compile("cherry picked from commit.*\\)");

    @NotNull
    public static final TIntHashSet match(@NotNull IndexDataGetter $receiver, @NotNull VirtualFile root, @NotNull TIntHashSet sourceBranchCommits, @NotNull TIntHashSet targetBranchCommits, boolean reliable) {
        Map timeToSourceCommit2 = TroveUtil.group((TIntHashSet)sourceBranchCommits, (IntFunction)new IntFunction<T>($receiver){
            final /* synthetic */ IndexDataGetter $this_match;

            @Nullable
            public final Long apply(int it) {
                return this.$this_match.getAuthorTime(it);
            }
            {
                this.$this_match = indexDataGetter;
            }
        });
        Map authorToSourceCommit2 = TroveUtil.group((TIntHashSet)sourceBranchCommits, (IntFunction)new IntFunction<T>($receiver){
            final /* synthetic */ IndexDataGetter $this_match;

            @Nullable
            public final VcsUser apply(int it) {
                return this.$this_match.getAuthor(it);
            }
            {
                this.$this_match = indexDataGetter;
            }
        });
        TIntHashSet result2 = new TIntHashSet();
        for (int targetCommit : targetBranchCommits) {
            Long time = $receiver.getAuthorTime(targetCommit);
            VcsUser author = $receiver.getAuthor(targetCommit);
            TIntHashSet tIntHashSet = (TIntHashSet)authorToSourceCommit2.get(author);
            if (tIntHashSet == null) {
                tIntHashSet = new TIntHashSet();
            }
            TIntHashSet commitsForAuthor = tIntHashSet;
            TIntHashSet[] tIntHashSetArray = new TIntHashSet[2];
            TIntHashSet tIntHashSet2 = (TIntHashSet)timeToSourceCommit2.get(time);
            if (tIntHashSet2 == null) {
                tIntHashSet2 = new TIntHashSet();
            }
            tIntHashSetArray[0] = tIntHashSet2;
            tIntHashSetArray[1] = commitsForAuthor;
            Set sourceCandidates = TroveUtil.intersect((TIntHashSet[])tIntHashSetArray);
            Collection collection = sourceCandidates;
            if (!(!collection.isEmpty())) continue;
            TroveUtil.addAll((TIntHashSet)result2, (Collection)GitCompareUtilKt.selectSourceCommits($receiver, targetCommit, root, sourceCandidates, commitsForAuthor, reliable));
        }
        return result2;
    }

    @NotNull
    public static /* synthetic */ TIntHashSet match$default(IndexDataGetter indexDataGetter, VirtualFile virtualFile, TIntHashSet tIntHashSet, TIntHashSet tIntHashSet2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return GitCompareUtilKt.match(indexDataGetter, virtualFile, tIntHashSet, tIntHashSet2, bl);
    }

    private static final Set<Integer> selectSourceCommits(@NotNull IndexDataGetter $receiver, int targetCommit, VirtualFile root, Set<Integer> sourceCandidates, TIntHashSet sourceCandidatesExtended, boolean reliable) {
        String string = $receiver.getFullMessage(targetCommit);
        if (string == null) {
            return SetsKt.emptySet();
        }
        String targetMessage = string;
        Set result2 = new LinkedHashSet();
        Matcher matcher = suffixPattern.matcher(targetMessage);
        while (matcher.find()) {
            CharSequence match2 = targetMessage.subSequence(matcher.start(), matcher.end());
            CharSequence hashesString = match2.subSequence(suffixStart.length(), match2.length() - 1);
            List hashesCandidates = StringsKt.split$default((CharSequence)hashesString, (String[])new String[]{",", " ", ";"}, (boolean)false, (int)0, (int)6, null);
            for (String h : hashesCandidates) {
                if (!VcsLogUtil.HASH_REGEX.matcher(h).matches()) continue;
                Hash hash = HashImpl.build((String)h);
                int index = $receiver.getLogStorage().getCommitIndex(hash, root);
                if (!sourceCandidatesExtended.contains(index)) continue;
                result2.add(index);
            }
            if (!ContainerUtil.intersects((Collection)sourceCandidates, (Collection)result2)) continue;
            return result2;
        }
        if (!reliable) {
            Set inexactMatches = new LinkedHashSet();
            Set exactMatches = new LinkedHashSet();
            Object object = sourceCandidates.iterator();
            while (object.hasNext()) {
                String sourceMessage;
                int sourceCandidate = ((Number)object.next()).intValue();
                if ($receiver.getFullMessage(sourceCandidate) == null) {
                    return SetsKt.emptySet();
                }
                if (!StringsKt.contains$default((CharSequence)targetMessage, (CharSequence)sourceMessage, (boolean)false, (int)2, null)) continue;
                if (targetMessage.length() == sourceMessage.length()) {
                    exactMatches.add(sourceCandidate);
                    continue;
                }
                inexactMatches.add(sourceCandidate);
            }
            object = exactMatches;
            Integer match3 = (Integer)CollectionsKt.singleOrNull((Iterable)(!object.isEmpty() ? exactMatches : inexactMatches));
            if (match3 != null) {
                return SetsKt.setOf((Object)match3);
            }
        }
        return SetsKt.emptySet();
    }
}

