/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

class GitMergeOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitMergeOperation.class);
    public static final String ROLLBACK_PROPOSAL = "You may rollback (reset to the commit before merging) not to let branches diverge.";
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final String myBranchToMerge;
    private final GitBrancher.DeleteOnMergeOption myDeleteOnMerge;
    @NotNull
    private final Map<GitRepository, Boolean> myConflictedRepositories = new HashMap<GitRepository, Boolean>();
    private GitPreservingProcess myPreservingProcess;

    GitMergeOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String branchToMerge, GitBrancher.DeleteOnMergeOption deleteOnMerge) {
        super(project, git, uiHandler, repositories);
        this.myBranchToMerge = branchToMerge;
        this.myDeleteOnMerge = deleteOnMerge;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        LOG.info("starting");
        GitMergeOperation.saveAllDocuments();
        boolean fatalErrorHappened = false;
        int alreadyUpToDateRepositories = 0;
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getOperationName());){
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository = this.next();
                LOG.info("next repository: " + repository);
                VirtualFile root = repository.getRoot();
                Collection<Change> changes = GitChangeUtils.getDiff(repository, "HEAD", this.myBranchToMerge, false);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByMerge = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                GitSimpleEventDetector alreadyUpToDateDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.ALREADY_UP_TO_DATE);
                GitCommandResult result2 = this.myGit.merge(repository, this.myBranchToMerge, Collections.emptyList(), localChangesDetector, unmergedFiles, untrackedOverwrittenByMerge, mergeConflict, alreadyUpToDateDetector);
                if (result2.success()) {
                    LOG.info("Merged successfully");
                    GitUtil.updateAndRefreshVfs(repository, changes);
                    this.markSuccessful(repository);
                    if (!alreadyUpToDateDetector.hasHappened()) continue;
                    ++alreadyUpToDateRepositories;
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    LOG.info("Unmerged files error!");
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LOG.info("Local changes would be overwritten by merge!");
                    boolean smartMergeSucceeded = this.proposeSmartMergePerformAndNotify(repository, localChangesDetector);
                    if (smartMergeSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (mergeConflict.hasHappened()) {
                    LOG.info("Merge conflict");
                    this.myConflictedRepositories.put(repository, Boolean.FALSE);
                    GitUtil.updateAndRefreshVfs(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                if (untrackedOverwrittenByMerge.wasMessageDetected()) {
                    LOG.info("Untracked files would be overwritten by merge!");
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByMerge.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                LOG.info("Unknown error. " + result2);
                this.fatalError(this.getCommonErrorTitle(), result2.getErrorOutputAsJoinedString());
                fatalErrorHappened = true;
            }
            if (fatalErrorHappened) {
                this.notifyAboutRemainingConflicts();
            } else {
                boolean allConflictsResolved = this.resolveConflicts();
                if (allConflictsResolved) {
                    if (alreadyUpToDateRepositories < this.getRepositories().size()) {
                        this.notifySuccess();
                    } else {
                        this.notifySuccess("Already up-to-date");
                    }
                }
            }
            this.restoreLocalChanges();
        }
    }

    private void notifyAboutRemainingConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            new MyMergeConflictResolver().notifyUnresolvedRemain();
        }
    }

    @Override
    protected void notifySuccess(@NotNull String message) {
        switch (this.myDeleteOnMerge) {
            case DELETE: {
                super.notifySuccess(message);
                ApplicationManager.getApplication().invokeLater(() -> {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.deleteBranch(this.myBranchToMerge, new ArrayList<GitRepository>(this.getRepositories()));
                });
                break;
            }
            case PROPOSE: {
                String description = message + "<br/><a href='delete'>Delete " + this.myBranchToMerge + "</a>";
                VcsNotifier.getInstance((Project)this.myProject).notifySuccess("", description, (NotificationListener)new DeleteMergedLocalBranchNotificationListener());
                break;
            }
            case NOTHING: {
                super.notifySuccess(message);
            }
        }
    }

    private boolean resolveConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            return new MyMergeConflictResolver().merge();
        }
        return true;
    }

    private boolean proposeSmartMergePerformAndNotify(@NotNull GitRepository repository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByMerge) {
        Collection<String> absolutePaths;
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByMerge, (String)this.myCurrentHeads.get(repository), this.myBranchToMerge);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        GitSmartOperationDialog.Choice decision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByMerge.getRelativeFilePaths()), "merge", null);
        if (decision == GitSmartOperationDialog.Choice.SMART) {
            return this.doSmartMerge(allConflictingRepositories);
        }
        this.fatalLocalChangesError(this.myBranchToMerge);
        return false;
    }

    private void restoreLocalChanges() {
        if (this.myPreservingProcess != null) {
            this.myPreservingProcess.load();
        }
    }

    private boolean doSmartMerge(@NotNull Collection<GitRepository> repositories) {
        AtomicBoolean success = new AtomicBoolean();
        this.myPreservingProcess = new GitPreservingProcess(this.myProject, this.myGit, GitUtil.getRootsFromRepositories(repositories), "merge", this.myBranchToMerge, GitVcsSettings.UpdateChangesPolicy.STASH, this.getIndicator(), () -> success.set(this.doMerge(repositories)));
        this.myPreservingProcess.execute((Computable<Boolean>)((Computable)this.myConflictedRepositories::isEmpty));
        return success.get();
    }

    private boolean doMerge(@NotNull Collection<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
            GitCommandResult result2 = this.myGit.merge(repository, this.myBranchToMerge, Collections.emptyList(), mergeConflict);
            if (!result2.success()) {
                if (mergeConflict.hasHappened()) {
                    this.myConflictedRepositories.put(repository, Boolean.TRUE);
                    GitUtil.updateAndRefreshVfs(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result2.getErrorOutputAsJoinedString());
                return false;
            }
            GitUtil.updateAndRefreshVfs(repository);
            this.markSuccessful(repository);
        }
        return true;
    }

    @NotNull
    private String getCommonErrorTitle() {
        return "Could Not Merge " + this.myBranchToMerge;
    }

    @Override
    protected void rollback() {
        LOG.info("starting rollback...");
        ArrayList<GitRepository> repositoriesForSmartRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForSimpleRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForMergeRollback = new ArrayList<GitRepository>();
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            if (this.myConflictedRepositories.containsKey(repository)) {
                repositoriesForMergeRollback.add(repository);
                continue;
            }
            if (this.thereAreLocalChangesIn(repository)) {
                repositoriesForSmartRollback.add(repository);
                continue;
            }
            repositoriesForSimpleRollback.add(repository);
        }
        LOG.info("for smart rollback: " + DvcsUtil.getShortNames(repositoriesForSmartRollback) + "; for simple rollback: " + DvcsUtil.getShortNames(repositoriesForSimpleRollback) + "; for merge rollback: " + DvcsUtil.getShortNames(repositoriesForMergeRollback));
        GitCompoundResult result2 = this.smartRollback(repositoriesForSmartRollback);
        for (GitRepository repository : repositoriesForSimpleRollback) {
            result2.append(repository, this.rollback(repository));
        }
        for (GitRepository repository : repositoriesForMergeRollback) {
            result2.append(repository, this.rollbackMerge(repository));
        }
        this.myConflictedRepositories.clear();
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", result2.getErrorOutputWithReposIndication());
        }
        LOG.info("rollback finished.");
    }

    @NotNull
    private GitCompoundResult smartRollback(@NotNull Collection<GitRepository> repositories) {
        LOG.info("Starting smart rollback...");
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<VirtualFile> roots = GitUtil.getRootsFromRepositories(repositories);
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myGit, roots, "merge", this.myBranchToMerge, GitVcsSettings.UpdateChangesPolicy.STASH, this.getIndicator(), () -> {
            for (GitRepository repository : repositories) {
                result2.append(repository, this.rollback(repository));
            }
        });
        preservingProcess.execute();
        LOG.info("Smart rollback completed.");
        return result2;
    }

    @NotNull
    private GitCommandResult rollback(@NotNull GitRepository repository) {
        return this.myGit.reset(repository, GitResetMode.HARD, this.getInitialRevision(repository), new GitLineHandlerListener[0]);
    }

    @NotNull
    private GitCommandResult rollbackMerge(@NotNull GitRepository repository) {
        GitCommandResult result2 = this.myGit.resetMerge(repository, null);
        GitUtil.updateAndRefreshVfs(repository);
        return result2;
    }

    private boolean thereAreLocalChangesIn(@NotNull GitRepository repository) {
        return !this.myChangeListManager.getChangesIn(repository.getRoot()).isEmpty();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return String.format("Merged <b><code>%s</code></b> to <b><code>%s</code></b>", this.myBranchToMerge, GitMergeOperation.stringifyBranchesByRepos(this.myCurrentHeads));
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return "However merge has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>" + ROLLBACK_PROPOSAL;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        return "merge";
    }

    private class DeleteMergedLocalBranchNotificationListener
    extends NotificationListener.Adapter {
        private DeleteMergedLocalBranchNotificationListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (event.getDescription().equalsIgnoreCase("delete")) {
                notification.expire();
                GitBrancher.getInstance(GitMergeOperation.this.myProject).deleteBranch(GitMergeOperation.this.myBranchToMerge, new ArrayList<GitRepository>(GitMergeOperation.this.getRepositories()));
            }
        }
    }

    private class MyMergeConflictResolver
    extends GitMergeCommittingConflictResolver {
        MyMergeConflictResolver() {
            super(GitMergeOperation.this.myProject, GitMergeOperation.this.myGit, new GitMerger(GitMergeOperation.this.myProject), GitUtil.getRootsFromRepositories(GitMergeOperation.this.myConflictedRepositories.keySet()), new GitConflictResolver.Params(GitMergeOperation.this.myProject), true);
        }

        @Override
        protected void notifyUnresolvedRemain() {
            this.notifyWarning(GitMergeOperation.this.myBranchToMerge + " Merged with Conflicts", "");
        }
    }
}

