/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitRebaseEditorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseParams {
    @NotNull
    private final GitVersion myVersion;
    @Nullable
    private final String myBranch;
    @Nullable
    private final String myNewBase;
    @NotNull
    private final String myUpstream;
    private final boolean myInteractive;
    private final boolean myPreserveMerges;
    @Nullable
    private final GitRebaseEditorHandler myEditorHandler;

    @NotNull
    public static GitRebaseParams editCommits(@NotNull GitVersion version, @NotNull String base, @Nullable GitRebaseEditorHandler editorHandler, boolean preserveMerges) {
        return new GitRebaseParams(version, null, null, base, true, preserveMerges, editorHandler);
    }

    public GitRebaseParams(@NotNull GitVersion version, @NotNull String upstream) {
        this(version, null, null, upstream, false, false);
    }

    public GitRebaseParams(@NotNull GitVersion version, @Nullable String branch, @Nullable String newBase, @NotNull String upstream, boolean interactive, boolean preserveMerges) {
        this(version, branch, newBase, upstream, interactive, preserveMerges, null);
    }

    private GitRebaseParams(@NotNull GitVersion version, @Nullable String branch, @Nullable String newBase, @NotNull String upstream, boolean interactive, boolean preserveMerges, @Nullable GitRebaseEditorHandler editorHandler) {
        this.myVersion = version;
        this.myBranch = StringUtil.nullize((String)branch, (boolean)true);
        this.myNewBase = StringUtil.nullize((String)newBase, (boolean)true);
        this.myUpstream = upstream;
        this.myInteractive = interactive;
        this.myPreserveMerges = preserveMerges;
        this.myEditorHandler = editorHandler;
    }

    @NotNull
    public List<String> asCommandLineArguments() {
        ArrayList args = ContainerUtil.newArrayList();
        if (this.myInteractive) {
            args.add("--interactive");
        }
        if (this.myPreserveMerges) {
            if (GitVersionSpecialty.REBASE_MERGES_REPLACES_PRESERVE_MERGES.existsIn(this.myVersion)) {
                args.add("--rebase-merges");
            } else {
                args.add("--preserve-merges");
            }
        }
        if (this.myNewBase != null) {
            args.addAll(Arrays.asList("--onto", this.myNewBase));
        }
        args.add(this.myUpstream);
        if (this.myBranch != null) {
            args.add(this.myBranch);
        }
        return args;
    }

    @Nullable
    public String getNewBase() {
        return this.myNewBase;
    }

    @NotNull
    public String getUpstream() {
        return this.myUpstream;
    }

    public String toString() {
        return StringUtil.join(this.asCommandLineArguments(), (String)" ");
    }

    public boolean isInteractive() {
        return this.myInteractive;
    }

    @Nullable
    public String getBranch() {
        return this.myBranch;
    }

    @Nullable
    public GitRebaseEditorHandler getEditorHandler() {
        return this.myEditorHandler;
    }
}

