/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import git4idea.DialogManager;
import git4idea.ui.ChangesBrowserWithRollback;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitSmartOperationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitSmartOperationDialog.class);
    private static final int FORCE_EXIT_CODE = 2;
    @NotNull
    private final JComponent myFileBrowser;
    @NotNull
    private final String myOperationTitle;
    @Nullable
    private final String myForceButton;

    @NotNull
    static Choice show(@NotNull Project project, @NotNull List<Change> changes, @NotNull Collection<String> paths, @NotNull String operationTitle, @Nullable String forceButtonTitle) {
        Object fileBrowser = !changes.isEmpty() ? new ChangesBrowserWithRollback(project, changes) : new GitSimplePathsBrowser(project, paths);
        GitSmartOperationDialog dialog = new GitSmartOperationDialog(project, (JComponent)fileBrowser, operationTitle, forceButtonTitle);
        if (fileBrowser instanceof Disposable) {
            Disposer.register((Disposable)dialog.getDisposable(), (Disposable)fileBrowser);
        }
        DialogManager.show(dialog);
        return Choice.fromDialogExitCode(dialog.getExitCode());
    }

    private GitSmartOperationDialog(@NotNull Project project, @NotNull JComponent fileBrowser, @NotNull String operationTitle, @Nullable String forceButton) {
        super(project);
        this.myFileBrowser = fileBrowser;
        this.myOperationTitle = operationTitle;
        this.myForceButton = forceButton;
        String capitalizedOperation = StringUtil.capitalize((String)this.myOperationTitle);
        this.setTitle("Git " + capitalizedOperation + " Problem");
        this.setOKButtonText("Smart " + capitalizedOperation);
        this.getOKAction().putValue("ShortDescription", "Stash local changes, " + operationTitle + ", unstash");
        this.setCancelButtonText("Don't " + capitalizedOperation);
        this.getCancelAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        if (this.myForceButton != null) {
            return new Action[]{new ForceCheckoutAction(this.myForceButton, this.myOperationTitle)};
        }
        return new Action[0];
    }

    protected JComponent createNorthPanel() {
        JBLabel description = new JBLabel("<html>Your local changes to the following files would be overwritten by " + this.myOperationTitle + ".<br/>" + ApplicationNamesInfo.getInstance().getFullProductName() + " can stash the changes, " + this.myOperationTitle + " and unstash them after that.</html>");
        description.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        return description;
    }

    protected JComponent createCenterPanel() {
        return this.myFileBrowser;
    }

    protected String getDimensionServiceKey() {
        return GitSmartOperationDialog.class.getName();
    }

    private class ForceCheckoutAction
    extends AbstractAction {
        ForceCheckoutAction(@NotNull String buttonTitle, String operationTitle) {
            super(buttonTitle);
            this.putValue("ShortDescription", StringUtil.capitalize((String)operationTitle) + " and overwrite local changes");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitSmartOperationDialog.this.close(2);
        }
    }

    public static enum Choice {
        SMART,
        FORCE,
        CANCEL;


        @NotNull
        private static Choice fromDialogExitCode(int exitCode) {
            if (exitCode == 0) {
                return SMART;
            }
            if (exitCode == 2) {
                return FORCE;
            }
            if (exitCode == 1) {
                return CANCEL;
            }
            LOG.error("Unexpected exit code: " + exitCode);
            return CANCEL;
        }
    }
}

