/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.dvcs.push.ui.PushUtils;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import git4idea.config.GitVcsSettings;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushAfterCommitDialog
extends VcsPushDialog {
    private JCheckBox myDontShowAgainCheckbox;

    public GitPushAfterCommitDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        super(project, selectedRepositories, currentRepo);
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        this.myDontShowAgainCheckbox = new JCheckBox("For Commit and Push to non-protected branches, preview commits before push");
        this.myDontShowAgainCheckbox.setSelected(GitVcsSettings.getInstance(this.myProject).shouldPreviewPushOnCommitAndPush());
        JPanel basePanel = super.createOptionsPanel();
        if (PushUtils.getProhibitedTarget((VcsPushUi)this) != null) {
            return basePanel;
        }
        return JBUI.Panels.simplePanel().addToCenter((Component)basePanel).addToBottom((Component)this.myDontShowAgainCheckbox);
    }

    public void push(boolean forcePush) {
        GitVcsSettings settings;
        if (!this.myDontShowAgainCheckbox.isSelected() && (settings = GitVcsSettings.getInstance(this.myProject)).shouldPreviewPushOnCommitAndPush()) {
            settings.setPreviewPushProtectedOnly(true);
        }
        super.push(forcePush);
    }

    public void showOrPush() {
        boolean hasProtectedBranch = PushUtils.getProhibitedTarget((VcsPushUi)this) != null;
        GitVcsSettings vcsSettings = GitVcsSettings.getInstance(this.myProject);
        boolean showDialog = vcsSettings.shouldPreviewPushOnCommitAndPush();
        boolean showOnlyProtected = vcsSettings.isPreviewPushProtectedOnly();
        if (showDialog && (!showOnlyProtected || hasProtectedBranch) || !this.canPush()) {
            this.show();
        } else {
            this.push(false);
        }
    }
}

