/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitApplyChangesProcess;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;

    public GitCherryPicker(@NotNull Project project, @NotNull Git git) {
        this.myProject = project;
        this.myGit = git;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    public void cherryPick(@NotNull List<? extends VcsFullCommitDetails> commits2) {
        GitApplyChangesProcess applyProcess = new GitApplyChangesProcess(this.myProject, commits2, this.isAutoCommit(), "cherry-pick", "applied", (Function4<? super GitRepository, ? super Hash, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)((Function4)(repository, commit2, autoCommit, listeners) -> this.myGit.cherryPick((GitRepository)repository, commit2.asString(), (boolean)autoCommit, this.shouldAddSuffix((GitRepository)repository, (Hash)commit2), listeners.toArray(new GitLineHandlerListener[0]))), (Function1<? super GitCommandResult, Boolean>)((Function1)result2 -> GitCherryPicker.isNothingToCommitMessage(result2)), (Function2<? super GitRepository, ? super VcsFullCommitDetails, String>)((Function2)(repository, commit2) -> this.createCommitMessage((GitRepository)repository, (VcsFullCommitDetails)commit2)), true, (Function1<? super GitRepository, Unit>)((Function1)repository -> this.cancelCherryPick((GitRepository)repository)));
        applyProcess.execute();
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result2) {
        String stdout = result2.getOutputAsJoinedString();
        return stdout.contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    @NotNull
    private String createCommitMessage(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit2) {
        String message = commit2.getFullMessage();
        if (this.shouldAddSuffix(repository, (Hash)commit2.getId())) {
            message = message + "\n\n(cherry picked from commit " + ((Hash)commit2.getId()).asString() + ")";
        }
        return message;
    }

    private boolean shouldAddSuffix(@NotNull GitRepository repository, @NotNull Hash commit2) {
        return this.mySettings.shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository, commit2);
    }

    private Unit cancelCherryPick(@NotNull GitRepository repository) {
        if (this.isAutoCommit()) {
            GitCherryPicker.removeCherryPickHead(repository);
        }
        return Unit.INSTANCE;
    }

    private static void removeCherryPickHead(@NotNull GitRepository repository) {
        File cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead();
        if (cherryPickHeadFile.exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    @NotNull
    public String getActionTitle() {
        return "Cherry-Pick";
    }

    private boolean isAutoCommit() {
        return GitVcsSettings.getInstance(this.myProject).isAutoCommitOnCherryPick();
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        return roots.stream().allMatch(r -> this.myRepositoryManager.getRepositoryForRoot((VirtualFile)r) != null);
    }
}

