/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitHttpAuthenticator;
import java.io.File;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.http.GitAskPassApp;
import org.jetbrains.git4idea.http.GitAskPassXmlRpcHandler;
import org.jetbrains.git4idea.ssh.GitXmlRpcHandlerService;
import org.jetbrains.git4idea.util.ScriptGenerator;

public abstract class GitHttpAuthService
extends GitXmlRpcHandlerService<GitHttpAuthenticator> {
    protected static final GitHttpAuthenticator STUB_AUTHENTICATOR = new GitHttpAuthenticator(){

        @Override
        @NotNull
        public String askPassword(@NotNull String url) {
            return "";
        }

        @Override
        @NotNull
        public String askUsername(@NotNull String url) {
            return "";
        }

        @Override
        public void saveAuthData() {
        }

        @Override
        public void forgetPassword() {
        }

        @Override
        public boolean wasCancelled() {
            return false;
        }
    };

    protected GitHttpAuthService() {
        super("intellij-git-askpass", GitAskPassXmlRpcHandler.HANDLER_NAME, GitAskPassApp.class);
    }

    @Override
    protected void customizeScriptGenerator(@NotNull ScriptGenerator generator) {
    }

    @Override
    @NotNull
    protected Object createRpcRequestHandlerDelegate() {
        return new InternalRequestHandlerDelegate();
    }

    @NotNull
    public abstract GitHttpAuthenticator createAuthenticator(@NotNull Project var1, @NotNull Collection<String> var2, @NotNull File var3, @NotNull GitAuthenticationGate var4, @NotNull GitAuthenticationMode var5);

    @NotNull
    public static <T> T getDefaultValueIfCancelled(@NotNull Computable<? extends T> operation, @NotNull T defaultValue) {
        try {
            return (T)operation.compute();
        }
        catch (ProcessCanceledException pce) {
            return defaultValue;
        }
    }

    public class InternalRequestHandlerDelegate
    implements GitAskPassXmlRpcHandler {
        @NotNull
        public String askUsername(String token, @NotNull String url) {
            return GitHttpAuthService.getDefaultValueIfCancelled(() -> ((GitHttpAuthenticator)GitHttpAuthService.this.getHandler(UUID.fromString(token))).askUsername(url), "");
        }

        @NotNull
        public String askPassword(String token, @NotNull String url) {
            return GitHttpAuthService.getDefaultValueIfCancelled(() -> ((GitHttpAuthenticator)GitHttpAuthService.this.getHandler(UUID.fromString(token))).askPassword(url), "");
        }
    }
}

