/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitImplBase;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitPushParams;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitImpl
extends GitImplBase {
    private static final Logger LOG = Logger.getInstance(Git.class);
    private static final List<String> REBASE_CONFIG_PARAMS = Collections.singletonList("core.commentChar=\u0001");

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public Set<VirtualFile> ignoredFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths) throws VcsException {
        HashSet<VirtualFile> ignoredFiles = new HashSet<VirtualFile>();
        if (paths == null) {
            ignoredFiles.addAll(this.ignoredFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkPaths((VirtualFile)root, paths)) {
                ignoredFiles.addAll(this.ignoredFilesNoChunk(project, root, relativePaths));
            }
        }
        return ignoredFiles;
    }

    @Override
    @NotNull
    public Set<VirtualFile> ignoredFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> paths) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STATUS);
        h.setSilent(true);
        h.addParameters("--ignored", "--porcelain", "-z");
        if (paths != null) {
            h.addParameters(paths);
        }
        h.endOptions();
        String output = this.runCommand(h).getOutputOrThrow(new int[0]);
        return GitImpl.parseFiles(root, output, "!! ");
    }

    @NotNull
    private static Set<VirtualFile> parseFiles(@NotNull VirtualFile root, @Nullable String output, @NotNull String fileStatusPrefix) {
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            return Collections.emptySet();
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (String relPath : output.split("\u0000")) {
            ProgressManager.checkCanceled();
            if (!fileStatusPrefix.isEmpty() && !relPath.startsWith(fileStatusPrefix)) continue;
            String relativePath = relPath.substring(fileStatusPrefix.length());
            VirtualFile f = VfsUtil.findFileByIoFile((File)new File(root.getPath(), relativePath), (boolean)true);
            if (f == null) {
                LOG.info(String.format("VirtualFile for path [%s] is null", relPath));
                continue;
            }
            files.add(f);
        }
        return files;
    }

    @Override
    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<VirtualFile> files) throws VcsException {
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, relativePaths));
            }
        }
        return untrackedFiles;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> untrackedFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        String output = this.runCommand(h).getOutputOrThrow(new int[0]);
        return GitImpl.parseFiles(root, output, "");
    }

    @Override
    @NotNull
    public GitCommandResult clone(@NotNull Project project, @NotNull File parentDirectory, @NotNull String url, @NotNull String clonedDirectoryName, GitLineHandlerListener ... listeners) {
        return this.runCommand(() -> {
            GitLineHandler handler = new GitLineHandler(project, parentDirectory, GitCommand.CLONE);
            handler.setSilent(false);
            handler.setStderrSuppressed(false);
            handler.setUrl(url);
            handler.addParameters("--progress");
            if (GitVersionSpecialty.CLONE_RECURSE_SUBMODULES.existsIn(project) && Registry.is((String)"git.clone.recurse.submodules")) {
                handler.addParameters("--recurse-submodules");
            }
            handler.addParameters(url);
            handler.endOptions();
            handler.addParameters(clonedDirectoryName);
            GitImpl.addListeners(handler, listeners);
            return handler;
        });
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository, String ... params) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository, @NotNull List<String> parameters, @NotNull String range) {
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        return this.runCommand(diff);
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository repository, @NotNull Collection<String> attributes, @NotNull Collection<VirtualFile> files) {
        List relativeFilePaths = ContainerUtil.map(files, file -> VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (VirtualFile)file));
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
        h.addParameters("--stdin");
        h.addParameters(new ArrayList<String>(attributes));
        h.endOptions();
        h.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(relativeFilePaths, h.getCharset()));
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository, @NotNull String message) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h.addParameters("save");
        h.addParameters(message);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        return this.runCommand(handler);
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        return this.runCommand(mergeHandler);
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(detach ? reference + "^0" : reference);
        } else {
            h.addParameters("-b", newBranch, reference);
        }
        h.endOptions();
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository, @NotNull String branchName, @Nullable GitLineHandlerListener listener) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener != null) {
            h.addLineListener(listener);
        }
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository, @NotNull String tagName, @Nullable GitLineHandlerListener listener, @NotNull String reference) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener != null) {
            h.addLineListener(listener);
        }
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult deleteTag(@NotNull GitRepository repository, @NotNull String tagName, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters("-d");
        h.addParameters(tagName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult branchContains(@NotNull GitRepository repository, @NotNull String commit2) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.addParameters("--contains", commit2);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String startPoint) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters(branchName);
        h.addParameters(startPoint);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository repository, @NotNull String currentName, @NotNull String newName, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-m", currentName, newName);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository, @NotNull GitResetMode mode, @NotNull String target, GitLineHandlerListener ... listeners) {
        return this.reset(repository, mode.getArgument(), target, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository, @Nullable String revision) {
        return this.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
    }

    @NotNull
    private GitCommandResult reset(@NotNull GitRepository repository, @NotNull String argument, @Nullable String target, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        return this.runCommand(handler);
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository, @NotNull String branchName) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        return this.doPush(repository, remote, Collections.singleton(url), spec, false, updateTracking, false, Collections.emptyList(), null, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull GitPushParams pushParams, GitLineHandlerListener ... listeners) {
        return this.doPush(repository, pushParams.getRemote().getName(), pushParams.getRemote().getPushUrls(), pushParams.getSpec(), pushParams.isForce(), pushParams.shouldSetupTracking(), pushParams.shouldSkipHooks(), pushParams.getForceWithLease(), pushParams.getTagMode(), listeners);
    }

    @NotNull
    private GitCommandResult doPush(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull Collection<String> remoteUrls, @NotNull String spec, boolean force, boolean updateTracking, boolean skipHook, List<GitPushParams.ForceWithLease> forceWithLease, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        return this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
            h.setUrls(remoteUrls);
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            GitImpl.addListeners(h, listeners);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository)) {
                h.addParameters("--progress");
            }
            h.addParameters("--porcelain");
            h.addParameters(remoteName);
            h.addParameters(spec);
            if (updateTracking) {
                h.addParameters("--set-upstream");
            }
            if (GitVersionSpecialty.SUPPORTS_FORCE_PUSH_WITH_LEASE.existsIn(repository) && !forceWithLease.isEmpty()) {
                for (GitPushParams.ForceWithLease lease : forceWithLease) {
                    String parameter = lease.getParameter();
                    if (parameter != null) {
                        h.addParameters("--force-with-lease=" + parameter);
                        continue;
                    }
                    h.addParameters("--force-with-lease");
                }
            } else if (force) {
                h.addParameters("--force");
            }
            if (tagMode != null) {
                h.addParameters(tagMode);
            }
            if (skipHook) {
                h.addParameters("--no-verify");
            }
            return h;
        });
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository, String ... params) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        return this.runCommand(handler);
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, GitLineHandlerListener ... listeners) {
        return this.cherryPick(repository, hash, autoCommit, true, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, boolean addCherryPickedFromSuffix, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        if (addCherryPickedFromSuffix) {
            handler.addParameters("-x");
        }
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        return this.runCommand(handler);
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<GitLineHandlerListener> listeners, String ... params) {
        return this.fetch(repository, remote, listeners, (GitAuthenticationGate)null, params);
    }

    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<GitLineHandlerListener> listeners, @Nullable GitAuthenticationGate authenticationGate, String ... params) {
        return this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
            if (authenticationGate != null) {
                h.setAuthenticationGate(authenticationGate);
            }
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            h.setUrls(remote.getUrls());
            h.addParameters(remote.getName());
            h.addParameters(params);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository)) {
                h.addParameters("--progress");
            }
            if (GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(repository)) {
                h.addParameters("--prune");
            }
            GitImpl.addListeners(h, listeners);
            return h;
        });
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository, @NotNull String name, @NotNull String url) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult removeRemote(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("remove", remote.getName());
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult renameRemote(@NotNull GitRepository repository, @NotNull String oldName, @NotNull String newName) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("rename", oldName, newName);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult setRemoteUrl(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull String newUrl) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("set-url", remoteName, newUrl);
        return this.runCommand(h);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        return this.doLsRemote(project, workingDir, url, Collections.singleton(url), Collections.emptyList(), new String[0]);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        return this.lsRemoteRefs(project, workingDir, remote, Collections.emptyList(), additionalParameters);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemoteRefs(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, @NotNull List<String> refs, String ... additionalParameters) {
        return this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getUrls(), refs, additionalParameters);
    }

    @Override
    @NotNull
    public GitCommandResult remotePrune(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        return this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE.writeLockingCommand());
            h.setStdoutSuppressed(false);
            h.addParameters("prune");
            h.addParameters(remote.getName());
            h.setUrls(remote.getUrls());
            return h;
        });
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebase(@NotNull GitRepository repository, @NotNull GitRebaseParams parameters, GitLineHandlerListener ... listeners) {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(parameters.asCommandLineArguments());
        GitImpl.addListeners(handler, listeners);
        if (parameters.isInteractive()) {
            GitRebaseEditorHandler editorHandler = parameters.getEditorHandler();
            if (editorHandler == null) {
                editorHandler = this.createEditor(project, root, handler, true);
            }
            return this.runWithEditor(handler, editorHandler);
        }
        return GitRebaseCommandResult.normal(this.runCommand(handler));
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseAbort(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REBASE);
        handler.addParameters("--abort");
        GitImpl.addListeners(handler, listeners);
        return GitRebaseCommandResult.normal(this.runCommand(handler));
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseContinue(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        return this.rebaseResume(repository, GitRebaseResumeMode.CONTINUE, listeners);
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseSkip(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        return this.rebaseResume(repository, GitRebaseResumeMode.SKIP, listeners);
    }

    @NotNull
    private GitRebaseCommandResult rebaseResume(@NotNull GitRepository repository, @NotNull GitRebaseResumeMode rebaseMode, @NotNull GitLineHandlerListener[] listeners) {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(rebaseMode.asCommandLineArgument());
        GitImpl.addListeners(handler, listeners);
        return this.runWithEditor(handler, this.createEditor(project, root, handler, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private GitRebaseCommandResult runWithEditor(@NotNull GitLineHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        service.configureHandler(handler, editorHandler.getHandlerNo());
        try {
            GitCommandResult result2 = this.runCommand(handler);
            if (editorHandler.wasCommitListEditorCancelled()) {
                GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.cancelledInCommitList(result2);
                return gitRebaseCommandResult;
            }
            if (editorHandler.wasUnstructuredEditorCancelled()) {
                GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.cancelledInCommitMessage(result2);
                return gitRebaseCommandResult;
            }
            GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(result2);
            return gitRebaseCommandResult;
        }
        finally {
            service.unregisterHandler(editorHandler.getHandlerNo());
        }
    }

    @VisibleForTesting
    @NotNull
    protected GitInteractiveRebaseEditorHandler createEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(GitRebaseEditorService.getInstance(), project, root);
        if (!commitListAware) {
            editor.setRebaseEditorShown();
        }
        return editor;
    }

    @Override
    @NotNull
    public GitCommandResult revert(@NotNull GitRepository repository, @NotNull String commit2, boolean autoCommit, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REVERT);
        handler.addParameters(commit2);
        if (!autoCommit) {
            handler.addParameters("--no-commit");
        }
        GitImpl.addListeners(handler, listeners);
        return this.runCommand(handler);
    }

    @NotNull
    private GitCommandResult doLsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String remoteId, @NotNull Collection<String> authenticationUrls, @NotNull List<String> refs, String ... additionalParameters) {
        return this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
            h.addParameters(additionalParameters);
            h.addParameters(remoteId);
            h.addParameters(refs);
            h.setUrls(authenticationUrls);
            return h;
        });
    }

    @Override
    @NotNull
    public GitCommandResult getObjectType(@NotNull GitRepository repository, @NotNull String object) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CAT_FILE);
        h.setSilent(true);
        h.addParameters("-t", object);
        return this.runCommand(h);
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<GitLineHandlerListener> listeners) {
        for (GitLineHandlerListener listener : listeners) {
            handler.addLineListener(listener);
        }
    }
}

