/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerAuthenticationManager;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitImplBase
implements Git {
    private static final Logger LOG = Logger.getInstance(GitImplBase.class);
    public static final String REMOTE_PROGRESS_PREFIX = "remote: ";
    public static final String[] PROGRESS_INDICATORS = new String[]{"Counting objects:", "Compressing objects:", "Writing objects:", "Receiving objects:", "Resolving deltas:"};
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "The file will have its original", "runnerw:"};

    GitImplBase() {
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        return this.run(handler, GitImplBase.getCollectingCollector());
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<GitLineHandler> handlerConstructor) {
        return this.run(handlerConstructor, (Computable<OutputCollector>)((Computable)GitImplBase::getCollectingCollector));
    }

    @NotNull
    private static OutputCollector getCollectingCollector() {
        return new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (Registry.is((String)"git.allow.stderr.to.stdout.mixing") && !GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }
        };
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        return this.run(handler, new OutputCollector(){

            @Override
            protected void outputLineReceived(@NotNull String line) {
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                this.addErrorLine(line);
            }
        });
    }

    @NotNull
    private GitCommandResult run(@NotNull Computable<GitLineHandler> handlerConstructor, @NotNull Computable<OutputCollector> outputCollectorConstructor) {
        GitCommandResult result2;
        int authAttempt = 0;
        do {
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            OutputCollector outputCollector = (OutputCollector)outputCollectorConstructor.compute();
            boolean isCredHelperUsed = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            result2 = this.run(handler, outputCollector);
            if (isCredHelperUsed != GitVcsApplicationSettings.getInstance().isUseCredentialHelper()) continue;
            ++authAttempt;
        } while (result2.isAuthenticationFailed() && authAttempt < 2);
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GitCommandResult run(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        Project project;
        GitVersion version = GitVersion.NULL;
        if (handler.isPreValidateExecutable()) {
            String executablePath = handler.getExecutablePath();
            try {
                version = GitExecutableManager.getInstance().identifyVersion(executablePath);
            }
            catch (Exception e) {
                return GitImplBase.handlePreValidationException(handler.project(), e);
            }
        }
        if ((project = handler.project()) != null && project.isDisposed()) {
            LOG.warn("Project has already been disposed");
            throw new ProcessCanceledException();
        }
        if (project == null) return GitImplBase.doRun(handler, version, outputCollector);
        if (!handler.isRemote()) return GitImplBase.doRun(handler, version, outputCollector);
        try (GitHandlerAuthenticationManager authenticationManager = this.prepareAuthentication(project, handler);){
            GitCommandResult result2 = GitImplBase.doRun(handler, version, outputCollector);
            GitCommandResult gitCommandResult = GitCommandResult.withAuthentication(result2, authenticationManager.isHttpAuthFailed());
            return gitCommandResult;
        }
        catch (IOException e) {
            return GitCommandResult.startError("Failed to start Git process " + e.getLocalizedMessage());
        }
    }

    @NotNull
    protected GitHandlerAuthenticationManager prepareAuthentication(@NotNull Project project, @NotNull GitLineHandler handler) throws IOException {
        return GitHandlerAuthenticationManager.prepare(project, handler);
    }

    @NotNull
    private static GitCommandResult doRun(@NotNull GitLineHandler handler, @NotNull GitVersion version, @NotNull OutputCollector outputCollector) {
        boolean canSuppressOptionalLocks;
        GitImplBase.getGitTraceEnvironmentVariables(version).forEach(handler::addCustomEnvironmentVariable);
        boolean bl = canSuppressOptionalLocks = Registry.is((String)"git.use.no.optional.locks") && GitVersionSpecialty.ENV_GIT_OPTIONAL_LOCKS_ALLOWED.existsIn(version);
        if (canSuppressOptionalLocks) {
            handler.addCustomEnvironmentVariable("GIT_OPTIONAL_LOCKS", "0");
        }
        GitCommandResultListener resultListener = new GitCommandResultListener(outputCollector);
        handler.addLineListener(resultListener);
        try (AccessToken ignored = GitImplBase.lock(handler, !canSuppressOptionalLocks);){
            GitImplBase.writeOutputToConsole(handler);
            handler.runInCurrentThread();
        }
        catch (IOException e) {
            return GitCommandResult.error("Error processing input stream: " + e.getLocalizedMessage());
        }
        return new GitCommandResult(resultListener.myStartFailed, resultListener.myExitCode, outputCollector.myErrorOutput, outputCollector.myOutput);
    }

    @NotNull
    public static Map<String, String> getGitTraceEnvironmentVariables(@NotNull GitVersion version) {
        HashMap<String, String> environment = new HashMap<String, String>(5);
        environment.put("GIT_TRACE", "0");
        if (GitVersionSpecialty.ENV_GIT_TRACE_PACK_ACCESS_ALLOWED.existsIn(version)) {
            environment.put("GIT_TRACE_PACK_ACCESS", "");
        }
        environment.put("GIT_TRACE_PACKET", "");
        environment.put("GIT_TRACE_PERFORMANCE", "0");
        environment.put("GIT_TRACE_SETUP", "0");
        return environment;
    }

    @NotNull
    private static GitCommandResult handlePreValidationException(@Nullable Project project, @NotNull Exception e) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            throw new ProcessCanceledException((Throwable)e);
        }
        return GitCommandResult.startError(GitBundle.getString("git.executable.validation.error.start.title") + ": \n" + GitExecutableProblemsNotifier.getPrettyErrorMessage(e));
    }

    private static void writeOutputToConsole(final @NotNull GitLineHandler handler) {
        Project project = handler.project();
        if (project != null && !project.isDefault()) {
            final GitVcsConsoleWriter vcsConsoleWriter = GitVcsConsoleWriter.getInstance(project);
            handler.addLineListener(new GitLineHandlerListener(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (!handler.isSilent() && !StringUtil.isEmptyOrSpaces((String)line)) {
                        if (outputType == ProcessOutputTypes.STDOUT && !handler.isStdoutSuppressed()) {
                            vcsConsoleWriter.showMessage(line);
                        } else if (outputType == ProcessOutputTypes.STDERR && !handler.isStderrSuppressed() && !GitImplBase.looksLikeProgress(line)) {
                            vcsConsoleWriter.showErrorMessage(line);
                        }
                    }
                }
            });
            if (!handler.isSilent()) {
                vcsConsoleWriter.showCommandLine("[" + GitImplBase.stringifyWorkingDir(project.getBasePath(), handler.getWorkingDirectory()) + "] " + handler.printableCommandLine());
            }
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler, boolean canTakeOptionalLocks) {
        Project project = handler.project();
        GitCommand.LockingPolicy lockingPolicy = handler.getCommand().lockingPolicy();
        if (project == null || project.isDefault() || lockingPolicy == GitCommand.LockingPolicy.READ || lockingPolicy == GitCommand.LockingPolicy.READ_OPTIONAL_LOCKING && !canTakeOptionalLocks) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        final ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
        executionLock.writeLock().lock();
        return new AccessToken(){

            public void finish() {
                executionLock.writeLock().unlock();
            }
        };
    }

    private static boolean looksLikeProgress(@NotNull String line) {
        String trimmed = StringUtil.trimStart((String)line, (String)REMOTE_PROGRESS_PREFIX);
        return ContainerUtil.exists((Object[])PROGRESS_INDICATORS, indicator -> StringUtil.startsWith((CharSequence)trimmed, (CharSequence)indicator));
    }

    private static boolean looksLikeError(@NotNull String text) {
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator));
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @NotNull File workingDir) {
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)workingDir.getPath()), (char)'/');
            if (".".equals(relPath)) {
                return workingDir.getName();
            }
            if (relPath != null) {
                return FileUtil.toSystemDependentName((String)relPath);
            }
        }
        return workingDir.getPath();
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            List<String> list = this.myOutput;
            synchronized (list) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            List<String> list = this.myErrorOutput;
            synchronized (list) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR && !GitImplBase.looksLikeProgress(line)) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(@NotNull Throwable t) {
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived("Failed to start Git process " + t.getLocalizedMessage());
        }
    }
}

