/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.LineHandlerHelper;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.BaseDataReader;
import git4idea.commands.BufferingTextSplitter;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLineHandler
extends GitTextHandler {
    private final EventDispatcher<GitLineHandlerListener> myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    @NotNull
    private Collection<String> myUrls = Collections.emptyList();
    @NotNull
    private GitAuthenticationMode myIgnoreAuthenticationRequest = GitAuthenticationMode.FULL;
    @Nullable
    private GitAuthenticationGate myAuthenticationGate;

    public GitLineHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        super(project, directory, command);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        super(project, vcsRoot, command);
    }

    public GitLineHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        super(project, vcsRoot, command, configParameters);
    }

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull String pathToExecutable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        super(project, directory, pathToExecutable, command, configParameters);
    }

    public void setUrl(@NotNull String url) {
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(@NotNull Collection<String> urls) {
        this.myUrls = urls;
    }

    @NotNull
    public Collection<String> getUrls() {
        return this.myUrls;
    }

    protected boolean isRemote() {
        return !this.myUrls.isEmpty();
    }

    @NotNull
    public GitAuthenticationMode getIgnoreAuthenticationMode() {
        return this.myIgnoreAuthenticationRequest;
    }

    public void setIgnoreAuthenticationMode(@NotNull GitAuthenticationMode authenticationMode) {
        this.myIgnoreAuthenticationRequest = authenticationMode;
    }

    @Nullable
    public GitAuthenticationGate getAuthenticationGate() {
        return this.myAuthenticationGate;
    }

    public void setAuthenticationGate(@NotNull GitAuthenticationGate authenticationGate) {
        this.myAuthenticationGate = authenticationGate;
    }

    @Override
    protected void processTerminated(int exitCode) {
    }

    public void addLineListener(GitLineHandlerListener listener) {
        super.addListener((ProcessEventListener)listener);
        this.myLineListeners.addListener((EventListener)((Object)listener));
    }

    @Override
    protected void onTextAvailable(String text, Key outputType) {
        this.notifyLine(text, outputType);
    }

    private void notifyLine(@NotNull String line, @NotNull Key outputType) {
        String lineWithoutSeparator = LineHandlerHelper.trimLineSeparator((String)line);
        if (!line.endsWith("\r")) {
            this.logOutput(lineWithoutSeparator, outputType);
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            return;
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(lineWithoutSeparator, outputType);
    }

    private void logOutput(@NotNull String line, @NotNull Key outputType) {
        String trimmedLine = line.trim();
        if (!StringUtil.isEmptyOrSpaces((String)trimmedLine) && !this.mySilent && (outputType == ProcessOutputTypes.STDOUT && !this.isStdoutSuppressed() || outputType == ProcessOutputTypes.STDERR && !this.isStderrSuppressed())) {
            LOG.info(trimmedLine);
        } else {
            OUTPUT_LOG.debug(trimmedLine);
        }
    }

    @Override
    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new GitTextHandler.MyOSProcessHandler(commandLine, this.myWithMediator && Registry.is((String)"git.execute.with.mediator")){

            @NotNull
            protected BaseDataReader createOutputDataReader() {
                return new LineReader(this.createProcessOutReader(), this.readerOptions().policy(), new BufferingTextSplitter(line -> this.notifyTextAvailable((String)line, ProcessOutputTypes.STDOUT)), this.myPresentableName);
            }

            @NotNull
            protected BaseDataReader createErrorDataReader() {
                return new LineReader(this.createProcessErrReader(), this.readerOptions().policy(), new BufferingTextSplitter(line -> this.notifyTextAvailable((String)line, ProcessOutputTypes.STDERR)), this.myPresentableName);
            }
        };
    }

    public void overwriteConfig(String ... params) {
        for (String param : params) {
            this.myCommandLine.getParametersList().prependAll(new String[]{"-c", param});
        }
    }

    private static class LineReader
    extends BaseDataReader {
        @NotNull
        private final Reader myReader;
        @NotNull
        private final char[] myInputBuffer = new char[8192];
        @NotNull
        private final BufferingTextSplitter myOutputProcessor;

        LineReader(@NotNull Reader reader, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy, @NotNull BufferingTextSplitter outputProcessor, @NotNull String presentableName) {
            super(sleepingPolicy);
            this.myReader = reader;
            this.myOutputProcessor = outputProcessor;
            this.start(presentableName);
        }

        protected boolean readAvailableNonBlocking() throws IOException {
            return this.read(true);
        }

        protected boolean readAvailableBlocking() throws IOException {
            return this.read(false);
        }

        private boolean read(boolean checkReaderReady) throws IOException {
            int n;
            boolean read = false;
            while ((!checkReaderReady || this.myReader.ready()) && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.myOutputProcessor.process(this.myInputBuffer, n);
            }
            return read;
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return ProcessIOExecutorService.INSTANCE.submit(runnable);
        }

        protected void close() throws IOException {
            try {
                this.myReader.close();
            }
            finally {
                this.myOutputProcessor.flush();
            }
        }
    }
}

