/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitMessageWithFilesDetector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GitLocalChangesWouldBeOverwrittenDetector
extends GitMessageWithFilesDetector {
    private static final Pattern OLD_CHECKOUT_PATTERN = Pattern.compile(".*You have local changes to '(.*)'; cannot switch branches.*");
    private static final Pattern OLD_MERGE_PATTERN = Pattern.compile(".*Your local changes to '(.*)' would be overwritten by merge.*");
    private static final Pattern[] RESET_PATTERNS = new Pattern[]{Pattern.compile(".*Entry '(.*)' not uptodate. Cannot merge.*"), Pattern.compile(".*Entry '(.*)' would be overwritten by merge.*")};
    public static final GitMessageWithFilesDetector.Event NEW_PATTERN = new GitMessageWithFilesDetector.Event("LocalChangesDetector", "Your local changes to the following files would be overwritten by", "commit your changes or stash them before");
    @NotNull
    private final Operation myOperation;

    public GitLocalChangesWouldBeOverwrittenDetector(@NotNull VirtualFile root, @NotNull Operation operation) {
        super(NEW_PATTERN, root);
        this.myOperation = operation;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        super.onLineAvailable(line, outputType);
        for (Pattern pattern : this.myOperation.getPatterns()) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            this.myMessageDetected = true;
            this.myAffectedFiles.add(m.group(1));
            break;
        }
    }

    static /* synthetic */ Pattern access$000() {
        return OLD_CHECKOUT_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return OLD_MERGE_PATTERN;
    }

    static /* synthetic */ Pattern[] access$200() {
        return RESET_PATTERNS;
    }

    public static enum Operation {
        CHECKOUT(GitLocalChangesWouldBeOverwrittenDetector.access$000()),
        MERGE(GitLocalChangesWouldBeOverwrittenDetector.access$100()),
        RESET(GitLocalChangesWouldBeOverwrittenDetector.access$200());

        @NotNull
        private final Pattern[] myPatterns;

        private Operation(Pattern ... patterns) {
            this.myPatterns = patterns;
        }

        @NotNull
        Pattern[] getPatterns() {
            return this.myPatterns;
        }
    }
}

