/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.BaseOutputReader;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitTextHandler
extends GitHandler {
    private static final int WAIT_TIMEOUT_MS = 50;
    private static final int TERMINATION_TIMEOUT_MS = 60000;
    private OSProcessHandler myHandler;
    private volatile boolean myIsDestroyed;
    private final Object myProcessStateLock = new Object();
    protected boolean myWithMediator = true;

    protected GitTextHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        super(project, directory, command, Collections.emptyList());
    }

    protected GitTextHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        super(project, vcsRoot, command, Collections.emptyList());
    }

    protected GitTextHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, List<String> configParameters) {
        super(project, vcsRoot, command, configParameters);
    }

    public GitTextHandler(@Nullable Project project, @NotNull File directory, @NotNull String pathToExecutable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        super(project, directory, pathToExecutable, command, configParameters);
    }

    public void setWithMediator(boolean value) {
        this.myWithMediator = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Process startProcess() throws ExecutionException {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return null;
            }
            this.myHandler = this.createProcess(this.myCommandLine);
            return this.myHandler.getProcess();
        }
    }

    @Override
    protected void startHandlingStreams() {
        this.myHandler.addProcessListener(new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode = event.getExitCode();
                try {
                    GitTextHandler.this.setExitCode(exitCode);
                    GitTextHandler.this.processTerminated(exitCode);
                }
                finally {
                    GitTextHandler.this.listeners().processTerminated(exitCode);
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                GitTextHandler.this.onTextAvailable(event.getText(), outputType);
            }
        });
        this.myHandler.startNotify();
    }

    protected abstract void processTerminated(int var1);

    protected abstract void onTextAvailable(String var1, Key var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyProcess() {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            this.myIsDestroyed = true;
            if (this.myHandler != null) {
                this.myHandler.destroyProcess();
            }
        }
    }

    @Override
    protected void waitForProcess() {
        if (this.myHandler != null) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            while (!this.myHandler.waitFor(50L)) {
                try {
                    if (indicator == null) continue;
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    if (!this.tryKill()) {
                        LOG.error("Could not terminate [" + this.printableCommandLine() + "].");
                    }
                    throw pce;
                }
            }
        }
    }

    private boolean tryKill() {
        this.myHandler.destroyProcess();
        if (this.myHandler.waitFor(60000L)) {
            return true;
        }
        LOG.warn("Soft-kill failed for [" + this.printableCommandLine() + "].");
        ExecutionManagerImpl.stopProcess((ProcessHandler)this.myHandler);
        return this.myHandler.waitFor(60000L);
    }

    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new MyOSProcessHandler(commandLine, this.myWithMediator && Registry.is((String)"git.execute.with.mediator"));
    }

    protected static class MyOSProcessHandler
    extends KillableProcessHandler {
        protected MyOSProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
            super(commandLine, withMediator);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return Registry.is((String)"git.blocking.read") ? BaseOutputReader.Options.BLOCKING : BaseOutputReader.Options.NON_BLOCKING;
        }
    }
}

