/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CachingFileTester<T> {
    @NotNull
    private final ConcurrentMap<String, TestResult> myFileTestMap = new ConcurrentHashMap<String, TestResult>();

    CachingFileTester() {
    }

    @NotNull
    final synchronized TestResult getResultForFile(@NotNull String filePath) {
        TestResult result2 = (TestResult)this.myFileTestMap.get(filePath);
        long currentLastModificationDate = 0L;
        try {
            currentLastModificationDate = Files.getLastModifiedTime(Paths.get(CachingFileTester.resolveAgainstEnvPath(filePath), new String[0]), new LinkOption[0]).toMillis();
            if (result2 == null || result2.getFileLastModifiedTimestamp() != currentLastModificationDate) {
                result2 = new TestResult(this.testFile(filePath), currentLastModificationDate);
            }
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            result2 = new TestResult(e, currentLastModificationDate);
        }
        this.myFileTestMap.put(filePath, result2);
        return result2;
    }

    @NotNull
    private static String resolveAgainstEnvPath(@NotNull String filePath) {
        File exeFile;
        if (!filePath.contains(File.separator) && (exeFile = PathEnvironmentVariableUtil.findInPath((String)filePath)) != null) {
            return exeFile.getPath();
        }
        return filePath;
    }

    @Nullable
    public TestResult getCachedResultForFile(@NotNull String filePath) {
        return (TestResult)this.myFileTestMap.get(filePath);
    }

    @NotNull
    protected abstract T testFile(@NotNull String var1) throws Exception;

    class TestResult {
        @Nullable
        private final T myResult;
        @Nullable
        private final Exception myException;
        private final long myFileLastModifiedTimestamp;

        TestResult(T result2, long timestamp) {
            this.myResult = result2;
            this.myFileLastModifiedTimestamp = timestamp;
            this.myException = null;
        }

        TestResult(Exception exception, long timestamp) {
            this.myFileLastModifiedTimestamp = timestamp;
            this.myResult = null;
            this.myException = exception;
        }

        @Nullable
        public T getResult() {
            return this.myResult;
        }

        @Nullable
        public Exception getException() {
            return this.myException;
        }

        private long getFileLastModifiedTimestamp() {
            return this.myFileLastModifiedTimestamp;
        }
    }
}

