/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import git4idea.config.GitVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableDetector {
    private static final Logger LOG = Logger.getInstance(GitExecutableDetector.class);
    private static final String[] UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/git/bin"};
    private static final String GIT = "git";
    private static final String UNIX_EXECUTABLE = "git";
    private static final File WIN_ROOT = new File("C:");
    private static final String GIT_EXE = "git.exe";
    private static final String WIN_EXECUTABLE = "git.exe";

    @NotNull
    public String detect() {
        File gitExecutableFromPath = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? "git.exe" : "git"), (String)this.getPath(), null);
        if (gitExecutableFromPath != null) {
            return gitExecutableFromPath.getAbsolutePath();
        }
        return SystemInfo.isWindows ? this.detectForWindows() : GitExecutableDetector.detectForUnix();
    }

    @NotNull
    private static String detectForUnix() {
        for (String p : UNIX_PATHS) {
            File f = new File(p, "git");
            if (!f.exists()) continue;
            return f.getPath();
        }
        return "git";
    }

    @NotNull
    private String detectForWindows() {
        String exec = this.checkProgramFiles();
        if (exec != null) {
            return exec;
        }
        exec = this.checkCygwin();
        if (exec != null) {
            return exec;
        }
        return "git.exe";
    }

    @Nullable
    private String checkProgramFiles() {
        String[] PROGRAM_FILES = new String[]{"Program Files", "Program Files (x86)"};
        ArrayList<File> distrs = new ArrayList<File>();
        for (String programFiles : PROGRAM_FILES) {
            File pf = new File(this.getWinRoot(), programFiles);
            File[] children = pf.listFiles(pathname -> pathname.isDirectory() && pathname.getName().toLowerCase().startsWith("git"));
            if (!pf.exists() || children == null) continue;
            distrs.addAll(Arrays.asList(children));
        }
        Collections.sort(distrs, Collections.reverseOrder(new VersionDirsComparator()));
        for (File distr : distrs) {
            String exec = GitExecutableDetector.checkDistributive(distr);
            if (exec == null) continue;
            return exec;
        }
        return null;
    }

    @Nullable
    private String checkCygwin() {
        String[] OTHER_WINDOWS_PATHS;
        for (String otherPath : OTHER_WINDOWS_PATHS = new String[]{FileUtil.toSystemDependentName((String)"cygwin/bin/git.exe")}) {
            File file = new File(this.getWinRoot(), otherPath);
            if (!file.exists()) continue;
            return file.getPath();
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    protected File getWinRoot() {
        return WIN_ROOT;
    }

    @Nullable
    private static String checkDistributive(@Nullable File gitDir) {
        String[] binDirs;
        if (gitDir == null || !gitDir.exists()) {
            return null;
        }
        for (String binDir : binDirs = new String[]{"cmd", "bin"}) {
            String exec = GitExecutableDetector.checkBinDir(new File(gitDir, binDir));
            if (exec == null) continue;
            return exec;
        }
        return null;
    }

    @Nullable
    private static String checkBinDir(@NotNull File binDir) {
        if (!binDir.exists()) {
            return null;
        }
        File fe = new File(binDir, "git.exe");
        if (fe.exists()) {
            return fe.getPath();
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    protected String getPath() {
        return PathEnvironmentVariableUtil.getPathVariableValue();
    }

    private static class VersionDirsComparator
    implements Comparator<File> {
        private VersionDirsComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String name1 = f1.getName().toLowerCase();
            String name2 = f2.getName().toLowerCase();
            if (name1.equals("git")) {
                return name2.equals("git") ? VersionDirsComparator.fallback(f1, f2) : 1;
            }
            if (name2.equals("git")) {
                return -1;
            }
            Pattern GIT_WITH_VERSION = Pattern.compile("^git[ _]*([\\d\\.]*).*$");
            Matcher m1 = GIT_WITH_VERSION.matcher(name1);
            Matcher m2 = GIT_WITH_VERSION.matcher(name2);
            if (m1.matches() && m2.matches()) {
                GitVersion v1 = VersionDirsComparator.parseGitVersion(m1.group(1));
                GitVersion v2 = VersionDirsComparator.parseGitVersion(m2.group(1));
                if (v1 == null || v2 == null) {
                    return VersionDirsComparator.fallback(f1, f2);
                }
                int compareVersions = v1.compareTo(v2);
                return compareVersions == 0 ? VersionDirsComparator.fallback(f1, f2) : compareVersions;
            }
            return VersionDirsComparator.fallback(f1, f2);
        }

        private static int fallback(@NotNull File f1, @NotNull File f2) {
            int compareParents = f1.getParentFile().getName().compareTo(f2.getParentFile().getName());
            if (compareParents != 0) {
                return -compareParents;
            }
            String name1 = f1.getName().toLowerCase();
            String name2 = f2.getName().toLowerCase();
            return name1.compareTo(name2);
        }

        @Nullable
        private static GitVersion parseGitVersion(@Nullable String name) {
            if (name == null) {
                return null;
            }
            Pattern VERSION = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?.*");
            Matcher m = VERSION.matcher(name);
            if (!m.matches()) {
                return null;
            }
            try {
                int major = Integer.parseInt(m.group(1));
                return new GitVersion(major, VersionDirsComparator.parseOrNull(m.group(2)), VersionDirsComparator.parseOrNull(m.group(3)), VersionDirsComparator.parseOrNull(m.group(4)));
            }
            catch (NumberFormatException e) {
                LOG.info("Unexpected NFE when parsing [" + name + "]", (Throwable)e);
                return null;
            }
        }

        private static int parseOrNull(String group) {
            return group == null ? 0 : Integer.parseInt(group);
        }
    }
}

