/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.text.ParseException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitVcsApplicationSettings myApplicationSettings;
    @NotNull
    private final AtomicNotNullLazyValue<String> myDetectedExecutable;
    @NotNull
    private final CachingFileTester<GitVersion> myVersionCache;

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ServiceManager.getService(GitExecutableManager.class);
    }

    public GitExecutableManager(@NotNull GitVcsApplicationSettings applicationSettings) {
        this.myApplicationSettings = applicationSettings;
        this.myDetectedExecutable = AtomicNotNullLazyValue.createValue(new GitExecutableDetector()::detect);
        this.myVersionCache = new CachingFileTester<GitVersion>(){

            @Override
            @NotNull
            protected GitVersion testFile(@NotNull String filePath) throws VcsException, ParseException {
                return GitExecutableManager.doGetGitVersion(filePath);
            }
        };
    }

    private static GitVersion doGetGitVersion(@NotNull String pathToGit) throws VcsException, ParseException {
        LOG.debug("Acquiring git version for " + pathToGit);
        GitLineHandler handler = new GitLineHandler(null, new File("."), pathToGit, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult);
        LOG.info("Git version for " + pathToGit + " : " + version.getPresentation());
        return version;
    }

    @NotNull
    public String getPathToGit() {
        String path = this.myApplicationSettings.getSavedPathToGit();
        return path == null ? this.getDetectedExecutable() : path;
    }

    @NotNull
    public String getPathToGit(@NotNull Project project) {
        String path = GitVcsSettings.getInstance(project).getPathToGit();
        return path == null ? this.getPathToGit() : path;
    }

    @NotNull
    public String getDetectedExecutable() {
        return (String)this.myDetectedExecutable.getValue();
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String projectExecutablePath = this.getPathToGit(project);
        CachingFileTester.TestResult result2 = this.myVersionCache.getCachedResultForFile(projectExecutablePath);
        if (result2 == null || result2.getResult() == null) {
            return GitVersion.NULL;
        }
        return (GitVersion)result2.getResult();
    }

    @NotNull
    public GitVersion getVersionOrCancel(@NotNull Project project) throws ProcessCanceledException {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.getVersionOrCancel(project), GitBundle.getString("git.executable.version.progress.title"), true, project);
        }
        String pathToGit = this.getPathToGit(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, pathToGit);
        if (version == null) {
            throw new ProcessCanceledException();
        }
        return version;
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2 = this.myVersionCache.getResultForFile(pathToGit);
        if (result2.getResult() == null) {
            throw new GitVersionIdentificationException("Cannot identify version of git executable " + pathToGit, result2.getException());
        }
        return (GitVersion)result2.getResult();
    }

    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        String pathToGit = this.getPathToGit(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, pathToGit);
        if (version == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        executableProblemsNotifier.notifyUnsupportedVersion(version);
        return false;
    }

    @Nullable
    private GitVersion identifyVersionOrDisplayError(@Nullable Project project, @NotNull String pathToGit) {
        try {
            return this.identifyVersion(pathToGit);
        }
        catch (GitVersionIdentificationException e) {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
                GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            } else {
                GitExecutableProblemsNotifier.showExecutionErrorDialog(e, project);
            }
            return null;
        }
    }
}

