/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.GuiUtils;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotificationsManager myNotificationsManager;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        return (GitExecutableProblemsNotifier)ServiceManager.getService((Project)project, GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project, @NotNull NotificationsManager notificationsManager) {
        this.myProject = project;
        this.myNotificationsManager = notificationsManager;
    }

    public static void showUnsupportedVersionDialog(@NotNull GitVersion version, @Nullable Project project) {
        GuiUtils.invokeLaterIfNeeded(() -> Messages.showWarningDialog((Project)project, (String)GitBundle.message("git.executable.validation.error.version.message", GitVersion.MIN.getPresentation()), (String)GitBundle.message("git.executable.validation.error.version.title", version.getPresentation())), (ModalityState)ModalityState.defaultModalityState());
    }

    public static void showExecutionErrorDialog(@NotNull Throwable e, @Nullable Project project) {
        boolean xcodeLicenseError = GitExecutableProblemsNotifier.isXcodeLicenseError(e);
        GuiUtils.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)(xcodeLicenseError ? GitBundle.getString("git.executable.validation.error.xcode.message") : GitExecutableProblemsNotifier.getPrettyErrorMessage(e)), (String)(xcodeLicenseError ? GitBundle.getString("git.executable.validation.error.xcode.title") : GitBundle.getString("git.executable.validation.error.start.title"))), (ModalityState)ModalityState.defaultModalityState());
    }

    public void notifyUnsupportedVersion(@NotNull GitVersion version) {
        UnsupportedGitVersionNotification notification = new UnsupportedGitVersionNotification(version);
        ((BadGitExecutableNotification)notification).addConfigureGitActions(this.myProject);
        this.notify(notification);
    }

    public void notifyExecutionError(@NotNull Throwable exception) {
        if (GitExecutableProblemsNotifier.isXcodeLicenseError(exception)) {
            this.notify(new XcodeLicenseNotAcceptedNotification());
        } else {
            ErrorRunningGitNotification notification = new ErrorRunningGitNotification(GitExecutableProblemsNotifier.getPrettyErrorMessage(exception));
            ((BadGitExecutableNotification)notification).addConfigureGitActions(this.myProject);
            this.notify(notification);
        }
    }

    private void notify(@NotNull BadGitExecutableNotification notification) {
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.ensureSingularOfType(((Object)((Object)notification)).getClass())) {
                notification.notify(this.myProject);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private boolean ensureSingularOfType(@NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications = (BadGitExecutableNotification[])this.myNotificationsManager.getNotificationsOfType(BadGitExecutableNotification.class, this.myProject);
        int notificationsCount = currentNotifications.length;
        if (notificationsCount <= 0) {
            return true;
        }
        for (int i = 0; i < notificationsCount - 1; ++i) {
            currentNotifications[i].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification : (BadGitExecutableNotification[])this.myNotificationsManager.getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? "File not found: " + cause.getMessage() : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                return exception.getMessage();
            }
            return exception.getClass().getName();
        }
        return errorMessage;
    }

    public static boolean isXcodeLicenseError(@NotNull Throwable exception) {
        Throwable cause;
        String message = exception instanceof GitVersionIdentificationException ? ((cause = exception.getCause()) != null ? cause.getMessage() : null) : exception.getMessage();
        return message != null && SystemInfo.isMac && message.contains("Agreeing to the Xcode/iOS license");
    }

    private static abstract class BadGitExecutableNotification
    extends Notification {
        BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable Icon icon, @Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
            super(groupDisplayId, icon, title, subtitle, content, type, listener);
        }

        private void addConfigureGitActions(@NotNull Project project) {
            this.addAction((AnAction)new BrowseNotificationAction(GitBundle.getString("git.executable.validation.error.action.download"), GitBundle.getString("git.executable.validation.error.action.download.link")));
            this.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.getString("git.executable.validation.error.action.setting"), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, "Git")));
        }
    }

    private static class XcodeLicenseNotAcceptedNotification
    extends BadGitExecutableNotification {
        XcodeLicenseNotAcceptedNotification() {
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.getString("git.executable.validation.error.xcode.title"), null, GitBundle.getString("git.executable.validation.error.xcode.message"), NotificationType.ERROR, null);
        }
    }

    private static class ErrorRunningGitNotification
    extends BadGitExecutableNotification {
        ErrorRunningGitNotification(@NotNull String error) {
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.getString("git.executable.validation.error.start.title"), null, error, NotificationType.ERROR, null);
        }
    }

    private static class UnsupportedGitVersionNotification
    extends BadGitExecutableNotification {
        UnsupportedGitVersionNotification(@NotNull GitVersion unsupportedVersion) {
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.message("git.executable.validation.error.version.title", unsupportedVersion.getPresentation()), null, GitBundle.message("git.executable.validation.error.version.message", GitVersion.MIN.getPresentation()), NotificationType.WARNING, null);
        }
    }
}

