/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.project.Project;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsPanel;
import git4idea.config.GitVcsSettings;
import org.jetbrains.annotations.NotNull;

public class GitVcsConfigurable
extends ConfigurableBase<GitVcsPanel, GitVcsSettingsHolder> {
    private final Project myProject;
    private final GitVcsSettingsHolder mySettingsHolder;
    @NotNull
    private final GitExecutableManager myExecutableManager;

    public GitVcsConfigurable(@NotNull GitVcsApplicationSettings applicationSettings, @NotNull Project project, @NotNull GitVcsSettings projectSettings, @NotNull GitSharedSettings sharedSettings, @NotNull GitExecutableManager executableManager) {
        super("vcs.Git", "Git", "project.propVCSSupport.VCSs.Git");
        this.myProject = project;
        this.myExecutableManager = executableManager;
        this.mySettingsHolder = new GitVcsSettingsHolder(applicationSettings, projectSettings, sharedSettings);
    }

    protected GitVcsPanel createUi() {
        return new GitVcsPanel(this.myProject, this.myExecutableManager);
    }

    @NotNull
    protected GitVcsSettingsHolder getSettings() {
        return this.mySettingsHolder;
    }

    static class GitVcsSettingsHolder {
        @NotNull
        private final GitVcsApplicationSettings myApplicationSettings;
        @NotNull
        private final GitVcsSettings myProjectSettings;
        @NotNull
        private final GitSharedSettings mySharedSettings;

        GitVcsSettingsHolder(@NotNull GitVcsApplicationSettings applicationSettings, @NotNull GitVcsSettings projectSettings, @NotNull GitSharedSettings sharedSettings) {
            this.myApplicationSettings = applicationSettings;
            this.myProjectSettings = projectSettings;
            this.mySharedSettings = sharedSettings;
        }

        @NotNull
        public GitVcsApplicationSettings getApplicationSettings() {
            return this.myApplicationSettings;
        }

        @NotNull
        public GitVcsSettings getProjectSettings() {
            return this.myProjectSettings;
        }

        @NotNull
        public GitSharedSettings getSharedSettings() {
            return this.mySharedSettings;
        }
    }
}

