/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.reset.GitResetMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings,
DvcsCompareSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private State myState = new State();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)ServiceManager.getService((Project)project, GitVcsSettings.class);
    }

    @NotNull
    public UpdateMethod getUpdateType() {
        return (UpdateMethod)((Object)ObjectUtils.notNull((Object)((Object)this.myState.UPDATE_TYPE), (Object)((Object)UpdateMethod.BRANCH_DEFAULT)));
    }

    public void setUpdateType(UpdateMethod updateType) {
        this.myState.UPDATE_TYPE = updateType;
    }

    @NotNull
    public UpdateChangesPolicy updateChangesPolicy() {
        return this.myState.UPDATE_CHANGES_POLICY;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.UPDATE_CHANGES_POLICY = value;
    }

    public void saveCommitAuthor(String author) {
        this.myState.PREVIOUS_COMMIT_AUTHORS.remove(author);
        while (this.myState.PREVIOUS_COMMIT_AUTHORS.size() >= 16) {
            this.myState.PREVIOUS_COMMIT_AUTHORS.remove(this.myState.PREVIOUS_COMMIT_AUTHORS.size() - 1);
        }
        this.myState.PREVIOUS_COMMIT_AUTHORS.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtil.toStringArray(this.myState.PREVIOUS_COMMIT_AUTHORS);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    @Nullable
    public String getPathToGit() {
        return this.myState.PATH_TO_GIT;
    }

    public void setPathToGit(@Nullable String pathToGit) {
        this.myState.PATH_TO_GIT = pathToGit;
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.PUSH_AUTO_UPDATE;
    }

    public void setAutoUpdateIfPushRejected(boolean autoUpdate) {
        this.myState.PUSH_AUTO_UPDATE = autoUpdate;
    }

    public boolean shouldUpdateAllRootsIfPushRejected() {
        return this.myState.PUSH_UPDATE_ALL_ROOTS;
    }

    public void setUpdateAllRootsIfPushRejected(boolean updateAllRoots) {
        this.myState.PUSH_UPDATE_ALL_ROOTS = updateAllRoots;
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        return this.myState.ROOT_SYNC;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        this.myState.ROOT_SYNC = syncSetting;
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_GIT_ROOT_PATH;
    }

    public void setRecentRoot(@NotNull String recentGitRootPath) {
        this.myState.RECENT_GIT_ROOT_PATH = recentGitRootPath;
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        return this.myState.RECENT_BRANCH_BY_REPOSITORY;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        this.myState.RECENT_BRANCH_BY_REPOSITORY.put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return this.myState.RECENT_COMMON_BRANCH;
    }

    public void setRecentCommonBranch(@NotNull String branch) {
        this.myState.RECENT_COMMON_BRANCH = branch;
    }

    public void setAutoCommitOnCherryPick(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_CHERRY_PICK = autoCommit;
    }

    public boolean isAutoCommitOnCherryPick() {
        return this.myState.AUTO_COMMIT_ON_CHERRY_PICK;
    }

    public void setAutoCommitOnRevert(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_REVERT = autoCommit;
    }

    public boolean isAutoCommitOnRevert() {
        return this.myState.AUTO_COMMIT_ON_REVERT;
    }

    public boolean warnAboutCrlf() {
        return this.myState.WARN_ABOUT_CRLF;
    }

    public void setWarnAboutCrlf(boolean warn) {
        this.myState.WARN_ABOUT_CRLF = warn;
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.WARN_ABOUT_DETACHED_HEAD;
    }

    public void setWarnAboutDetachedHead(boolean warn) {
        this.myState.WARN_ABOUT_DETACHED_HEAD = warn;
    }

    @Nullable
    public GitResetMode getResetMode() {
        return this.myState.RESET_MODE;
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        this.myState.RESET_MODE = mode;
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return this.myState.PUSH_TAGS;
    }

    public void setPushTagMode(@Nullable GitPushTagMode mode) {
        this.myState.PUSH_TAGS = mode;
    }

    public boolean shouldSignOffCommit() {
        return this.myState.SIGN_OFF_COMMIT;
    }

    public void setSignOffCommit(boolean state) {
        this.myState.SIGN_OFF_COMMIT = state;
    }

    public boolean shouldUpdateBranchInfo() {
        return Registry.is((String)"git.update.incoming.outgoing.info") && this.myState.UPDATE_BRANCHES_INFO;
    }

    public void setUpdateBranchInfo(boolean state) {
        this.myState.UPDATE_BRANCHES_INFO = state;
    }

    public int getBranchInfoUpdateTime() {
        return this.myState.BRANCH_INFO_UPDATE_TIME;
    }

    public void setBranchInfoUpdateTime(int time) {
        this.myState.BRANCH_INFO_UPDATE_TIME = time;
    }

    public boolean shouldPreviewPushOnCommitAndPush() {
        return this.myState.PREVIEW_PUSH_ON_COMMIT_AND_PUSH;
    }

    public void setPreviewPushOnCommitAndPush(boolean state) {
        this.myState.PREVIEW_PUSH_ON_COMMIT_AND_PUSH = state;
    }

    public boolean isPreviewPushProtectedOnly() {
        return this.myState.PREVIEW_PUSH_PROTECTED_ONLY;
    }

    public void setPreviewPushProtectedOnly(boolean state) {
        this.myState.PREVIEW_PUSH_PROTECTED_ONLY = state;
    }

    public boolean isCommitRenamesSeparately() {
        return this.myState.COMMIT_RENAMES_SEPARATELY;
    }

    public void setCommitRenamesSeparately(boolean state) {
        this.myState.COMMIT_RENAMES_SEPARATELY = state;
    }

    @NotNull
    public DvcsBranchSettings getFavoriteBranchSettings() {
        return this.myState.FAVORITE_BRANCH_SETTINGS;
    }

    public boolean shouldSetUserNameGlobally() {
        return this.myState.SET_USER_NAME_GLOBALLY;
    }

    public void setUserNameGlobally(boolean value) {
        this.myState.SET_USER_NAME_GLOBALLY = value;
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES;
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        this.myState.SWAP_SIDES_IN_COMPARE_BRANCHES = value;
    }

    public boolean shouldAddSuffixToCherryPicksOfPublishedCommits() {
        return this.myState.ADD_SUFFIX_TO_CHERRY_PICKS_OF_PUBLISHED_COMMITS;
    }

    public void setAddSuffixToCherryPicks(boolean value) {
        this.myState.ADD_SUFFIX_TO_CHERRY_PICKS_OF_PUBLISHED_COMMITS = value;
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }
    }

    public static class State {
        public String PATH_TO_GIT = null;
        public List<String> PREVIOUS_COMMIT_AUTHORS = new ArrayList<String>();
        public UpdateChangesPolicy UPDATE_CHANGES_POLICY = UpdateChangesPolicy.STASH;
        public UpdateMethod UPDATE_TYPE = UpdateMethod.BRANCH_DEFAULT;
        public boolean PUSH_AUTO_UPDATE = false;
        public boolean PUSH_UPDATE_ALL_ROOTS = true;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public String RECENT_GIT_ROOT_PATH = null;
        public Map<String, String> RECENT_BRANCH_BY_REPOSITORY = new HashMap<String, String>();
        public String RECENT_COMMON_BRANCH = null;
        public boolean AUTO_COMMIT_ON_CHERRY_PICK = false;
        public boolean AUTO_COMMIT_ON_REVERT = false;
        public boolean WARN_ABOUT_CRLF = true;
        public boolean WARN_ABOUT_DETACHED_HEAD = true;
        public GitResetMode RESET_MODE = null;
        public GitPushTagMode PUSH_TAGS = null;
        public boolean SIGN_OFF_COMMIT = false;
        public boolean SET_USER_NAME_GLOBALLY = true;
        public boolean SWAP_SIDES_IN_COMPARE_BRANCHES = false;
        public boolean UPDATE_BRANCHES_INFO = true;
        public int BRANCH_INFO_UPDATE_TIME = 10;
        public boolean PREVIEW_PUSH_ON_COMMIT_AND_PUSH = true;
        public boolean PREVIEW_PUSH_PROTECTED_ONLY = false;
        public boolean COMMIT_RENAMES_SEPARATELY = false;
        public boolean ADD_SUFFIX_TO_CHERRY_PICKS_OF_PUBLISHED_COMMITS = true;
        @Property(surroundWithTag=false, flat=true)
        public DvcsBranchSettings FAVORITE_BRANCH_SETTINGS = new DvcsBranchSettings();
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

