/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmodule;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \r2\u00020\u0001:\u0003\f\r\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision;", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "submodule", "Lgit4idea/repo/GitRepository;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getSubmodule", "()Lgit4idea/repo/GitRepository;", "getFile", "Lcom/intellij/openapi/vcs/FilePath;", "getRevisionNumber", "Committed", "Companion", "Current", "intellij.vcs.git"})
public abstract class GitSubmoduleContentRevision
implements ContentRevision {
    @NotNull
    private final GitRepository submodule;
    private final VcsRevisionNumber revisionNumber;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public FilePath getFile() {
        return VcsUtil.getFilePath((String)this.submodule.getRoot().getPath(), (boolean)false);
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    @NotNull
    public final GitRepository getSubmodule() {
        return this.submodule;
    }

    public GitSubmoduleContentRevision(@NotNull GitRepository submodule, @NotNull VcsRevisionNumber revisionNumber) {
        this.submodule = submodule;
        this.revisionNumber = revisionNumber;
    }

    @JvmStatic
    @NotNull
    public static final ContentRevision createRevision(@NotNull GitSubmodule submodule, @NotNull VcsRevisionNumber revisionNumber) {
        return Companion.createRevision(submodule, revisionNumber);
    }

    @JvmStatic
    @NotNull
    public static final ContentRevision createCurrentRevision(@NotNull GitRepository submodule) {
        return Companion.createCurrentRevision(submodule);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision$Committed;", "Lgit4idea/diff/GitSubmoduleContentRevision;", "parentRepo", "Lgit4idea/repo/GitRepository;", "submodule", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getContent", "", "intellij.vcs.git"})
    private static final class Committed
    extends GitSubmoduleContentRevision {
        private final GitRepository parentRepo;

        @Nullable
        public String getContent() {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.getSubmodule().getRoot());
            List<GitIndexUtil.StagedFileOrDirectory> lsTree = GitIndexUtil.listTree(this.parentRepo, CollectionsKt.listOf((Object)filePath), this.getRevisionNumber());
            if (lsTree.size() != 1) {
                throw (Throwable)new VcsException("Unexpected output of ls-tree command for submodule [" + filePath + "] at [" + this.getRevisionNumber() + "]: " + lsTree);
            }
            GitIndexUtil.StagedFileOrDirectory tree = lsTree.get(0);
            if (!(tree instanceof GitIndexUtil.StagedSubrepo)) {
                throw (Throwable)new VcsException("Unexpected type of ls-tree for submodule [" + filePath + "] at [" + this.getRevisionNumber() + "]: " + tree);
            }
            if (Intrinsics.areEqual((Object)((GitIndexUtil.StagedSubrepo)tree).getPath(), (Object)filePath) ^ true) {
                throw (Throwable)new VcsException("Submodule path [" + this.getSubmodule().getRoot().getPath() + "] doesn't match the ls-tree output path [" + ((GitIndexUtil.StagedSubrepo)tree).getPath().getPath() + ']');
            }
            return ((GitIndexUtil.StagedSubrepo)tree).getBlobHash();
        }

        public Committed(@NotNull GitRepository parentRepo, @NotNull GitRepository submodule, @NotNull VcsRevisionNumber revisionNumber) {
            super(submodule, revisionNumber);
            this.parentRepo = parentRepo;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision$Current;", "Lgit4idea/diff/GitSubmoduleContentRevision;", "submodule", "Lgit4idea/repo/GitRepository;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getContent", "", "intellij.vcs.git"})
    private static final class Current
    extends GitSubmoduleContentRevision {
        @Nullable
        public String getContent() {
            return this.getSubmodule().getCurrentRevision();
        }

        public Current(@NotNull GitRepository submodule, @NotNull VcsRevisionNumber revisionNumber) {
            super(submodule, revisionNumber);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision$Companion;", "", "()V", "createCurrentRevision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "submodule", "Lgit4idea/repo/GitRepository;", "createRevision", "Lgit4idea/repo/GitSubmodule;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ContentRevision createRevision(@NotNull GitSubmodule submodule, @NotNull VcsRevisionNumber revisionNumber) {
            return new Committed(submodule.getParent(), submodule.getRepository(), revisionNumber);
        }

        @JvmStatic
        @NotNull
        public final ContentRevision createCurrentRevision(@NotNull GitRepository submodule) {
            return new Current(submodule, VcsRevisionNumber.NULL);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

