/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitChangeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangesParser {
    private static final Logger LOG = Logger.getInstance(GitChangesParser.class);

    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<VcsFileStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @Nullable String parentsHash) throws VcsException {
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        GitRevisionNumber parentRevision = parentsHash == null ? null : new GitRevisionNumber(parentsHash);
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (VcsFileStatusInfo statusInfo : statusInfos) {
            result2.add(GitChangesParser.parseChange(project, root, (VcsRevisionNumber)thisRevision, (VcsRevisionNumber)parentRevision, statusInfo));
        }
        return result2;
    }

    @NotNull
    private static Change parseChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VcsRevisionNumber thisRevision, @Nullable VcsRevisionNumber parentRevision, @NotNull VcsFileStatusInfo statusInfo) throws VcsException {
        ContentRevision after;
        FileStatus status;
        ContentRevision before;
        String path = statusInfo.getFirstPath();
        switch (statusInfo.getType()) {
            case NEW: {
                before = null;
                status = FileStatus.ADDED;
                after = GitContentRevision.createRevision(vcsRoot, path, thisRevision, project, false);
                break;
            }
            case MODIFICATION: {
                status = FileStatus.MODIFIED;
                FilePath filePath = GitContentRevision.createPath(vcsRoot, path, false);
                before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, false);
                after = GitContentRevision.createRevision(filePath, thisRevision, project, null);
                break;
            }
            case DELETED: {
                status = FileStatus.DELETED;
                FilePath filePathDeleted = GitContentRevision.createPath(vcsRoot, path, false);
                before = GitContentRevision.createRevision(filePathDeleted, parentRevision, project, null);
                after = null;
                break;
            }
            case MOVED: {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = GitContentRevision.createPath(vcsRoot, secondPath == null ? path : secondPath, false);
                before = GitContentRevision.createRevision(vcsRoot, path, parentRevision, project, false);
                after = GitContentRevision.createRevision(filePathAfterRename, thisRevision, project, null);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown file status: " + statusInfo));
            }
        }
        return new Change(before, after, status);
    }

    @NotNull
    public static Change.Type getChangeType(@NotNull GitChangeType type) {
        switch (type) {
            case ADDED: {
                return Change.Type.NEW;
            }
            case TYPE_CHANGED: 
            case MODIFIED: {
                return Change.Type.MODIFICATION;
            }
            case DELETED: {
                return Change.Type.DELETED;
            }
            case COPIED: 
            case RENAMED: {
                return Change.Type.MOVED;
            }
        }
        LOG.error("Unknown git change type: " + (Object)((Object)type));
        return Change.Type.MODIFICATION;
    }
}

