/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileHistory {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitFileHistory");
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VcsRevisionNumber myStartingRevision;

    private GitFileHistory(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @NotNull VcsRevisionNumber revision) {
        this.myProject = project;
        this.myRoot = root;
        this.myPath = VcsUtil.getLastCommitPath((Project)this.myProject, (FilePath)path);
        this.myStartingRevision = revision;
    }

    private void load(@NotNull Consumer<GitFileRevision> consumer, @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        GitLogParser logParser = new GitLogParser(this.myProject, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        GitLogRecordConsumer recordConsumer = new GitLogRecordConsumer(consumer);
        String firstCommitParent = this.myStartingRevision.asString();
        FilePath currentPath = this.myPath;
        while (currentPath != null && firstCommitParent != null) {
            recordConsumer.reset(currentPath);
            GitLineHandler handler = this.createLogHandler(logParser, currentPath, firstCommitParent, parameters);
            GitLogOutputSplitter splitter = new GitLogOutputSplitter(handler, logParser, recordConsumer);
            Git.getInstance().runCommandWithoutCollectingOutput(handler);
            if (splitter.hasErrors()) {
                return;
            }
            try {
                String firstCommit = recordConsumer.getFirstCommit();
                if (firstCommit == null) {
                    return;
                }
                Pair<String, FilePath> firstCommitParentAndPath = this.getFirstCommitParentAndPathIfRename(firstCommit, currentPath);
                if (firstCommitParentAndPath == null) {
                    return;
                }
                currentPath = (FilePath)firstCommitParentAndPath.second;
                firstCommitParent = (String)firstCommitParentAndPath.first;
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    @Nullable
    private Pair<String, FilePath> getFirstCommitParentAndPathIfRename(@NotNull String commit2, @NotNull FilePath filePath) throws VcsException {
        GitLineHandler h = new GitLineHandler(this.myProject, this.myRoot, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(this.myProject, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "-m", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit2);
        if (!GitVersionSpecialty.FOLLOW_IS_BUGGY_IN_THE_LOG.existsIn(this.myProject)) {
            h.addParameters("--follow");
            h.endOptions();
            h.addRelativePaths(filePath);
        } else {
            h.endOptions();
        }
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        List<GitLogRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        for (int i = 0; i < records.size(); ++i) {
            GitLogRecord record = records.get(i);
            List<Change> changes = record.parseChanges(this.myProject, this.myRoot);
            for (Change change : changes) {
                if (!change.isMoved() && !change.isRenamed() || !filePath.equals(((ContentRevision)ObjectUtils.notNull((Object)change.getAfterRevision())).getFile())) continue;
                String[] parents = record.getParentsHashes();
                String parent = parents.length > 0 ? parents[i] : null;
                return Pair.create((Object)parent, (Object)((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getFile());
            }
        }
        return null;
    }

    @NotNull
    private GitLineHandler createLogHandler(@NotNull GitLogParser parser, @NotNull FilePath path, @NotNull String lastCommit, String ... parameters) {
        GitLineHandler h = new GitLineHandler(this.myProject, this.myRoot, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.myProject) && Registry.is((String)"git.file.history.full")) {
            h.addParameters("--full-history", "--simplify-merges");
        }
        if (parameters != null && parameters.length > 0) {
            h.addParameters(parameters);
        }
        h.endOptions();
        h.addRelativePaths(path);
        return h;
    }

    public static void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<GitFileRevision> consumer, @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        VirtualFile repositoryRoot;
        VirtualFile virtualFile = repositoryRoot = root == null ? ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(path) : root;
        if (repositoryRoot == null) {
            exceptionConsumer.consume((Object)new VcsException("The file " + path + " is not under vcs."));
            return;
        }
        GitRevisionNumber revision = startingFrom == null ? GitRevisionNumber.HEAD : startingFrom;
        new GitFileHistory(project, repositoryRoot, path, (VcsRevisionNumber)revision).load(consumer, exceptionConsumer, parameters);
    }

    @NotNull
    public static List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>();
        ArrayList exceptions = new ArrayList();
        GitFileHistory.loadHistory(project, path, null, startingFrom, (Consumer<GitFileRevision>)((Consumer)revisions::add), (Consumer<VcsException>)((Consumer)exceptions::add), parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        return revisions;
    }

    @NotNull
    public static List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        return GitFileHistory.collectHistoryForRevision(project, path, (VcsRevisionNumber)GitRevisionNumber.HEAD, parameters);
    }

    private class GitLogRecordConsumer
    implements Consumer<GitLogRecord> {
        @NotNull
        private final AtomicBoolean mySkipFurtherOutput = new AtomicBoolean();
        @NotNull
        private final AtomicReference<String> myFirstCommit = new AtomicReference();
        @NotNull
        private final AtomicReference<FilePath> myCurrentPath = new AtomicReference();
        @NotNull
        private final Consumer<GitFileRevision> myRevisionConsumer;

        GitLogRecordConsumer(Consumer<GitFileRevision> revisionConsumer) {
            this.myRevisionConsumer = revisionConsumer;
        }

        public void reset(@NotNull FilePath path) {
            this.myCurrentPath.set(path);
            this.mySkipFurtherOutput.set(false);
        }

        public void consume(@NotNull GitLogRecord record) {
            if (this.mySkipFurtherOutput.get()) {
                return;
            }
            this.myFirstCommit.set(record.getHash());
            this.myRevisionConsumer.consume((Object)this.createGitFileRevision(record));
            List<VcsFileStatusInfo> statusInfos = record.getStatusInfos();
            if (statusInfos.isEmpty()) {
                return;
            }
            if (statusInfos.get(0).getType() == Change.Type.NEW && !GitFileHistory.this.myPath.isDirectory()) {
                this.mySkipFurtherOutput.set(true);
            }
        }

        @NotNull
        private GitFileRevision createGitFileRevision(@NotNull GitLogRecord record) {
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            FilePath revisionPath = this.getRevisionPath(record);
            Couple authorPair = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
            Couple committerPair = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
            List<String> parents = Arrays.asList(record.getParentsHashes());
            List<VcsFileStatusInfo> statusInfos = record.getStatusInfos();
            boolean deleted = !statusInfos.isEmpty() && statusInfos.get(0).getType() == Change.Type.DELETED;
            return new GitFileRevision(GitFileHistory.this.myProject, GitFileHistory.this.myRoot, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents, deleted);
        }

        @NotNull
        private FilePath getRevisionPath(@NotNull GitLogRecord record) {
            List<FilePath> paths = record.getFilePaths(GitFileHistory.this.myRoot);
            if (paths.size() > 0) {
                return paths.get(0);
            }
            return this.myCurrentPath.get();
        }

        @Nullable
        public String getFirstCommit() {
            return this.myFirstCommit.get();
        }
    }
}

