/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import git4idea.history.browser.SHAHash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    private GitHistoryUtils() {
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        GitLogUtil.readFullDetails(project, root, commitConsumer, true, true, false, parameters);
    }

    public static void loadTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer, String ... parameters) throws VcsException {
        GitLogUtil.readTimedCommits(project, root, Arrays.asList(parameters), null, null, commitConsumer);
    }

    public static List<? extends TimedVcsCommit> collectTimedCommits(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        ArrayList commits2 = ContainerUtil.newArrayList();
        GitHistoryUtils.loadTimedCommits(project, root, (Consumer<? super TimedVcsCommit>)((Consumer)commits2::add), parameters);
        return commits2;
    }

    @Nullable
    public static List<? extends VcsCommitMetadata> collectCommitsMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... hashes2) throws VcsException {
        List<? extends VcsCommitMetadata> result2 = GitLogUtil.collectShortDetails(project, GitVcs.getInstance(project), root, Arrays.asList(hashes2));
        if (result2.size() != hashes2.length) {
            return null;
        }
        return result2;
    }

    @NotNull
    public static List<GitCommit> history(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        return GitLogUtil.collectFullDetails(project, root, parameters);
    }

    @NotNull
    public static String[] formHashParameters(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2) {
        ArrayList parameters = ContainerUtil.newArrayList();
        parameters.add(GitLogUtil.getNoWalkParameter(vcs));
        parameters.addAll(hashes2);
        return ArrayUtil.toStringArray((Collection)parameters);
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters("--encoding=UTF-8");
        h.addParameters("--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Comparing.equal((String)record.getAuthorName(), (String)record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        VirtualFile root = GitUtil.getGitRoot(filePath);
        GitLocalBranch c = GitBranchUtil.getCurrentBranch(project, root);
        GitRemoteBranch gitRemoteBranch = t = c == null ? null : GitBranchUtil.tracked(project, root, c.getName());
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]).trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    public static long getAuthorTime(@NotNull Project project, @NotNull VirtualFile root, @NotNull String commitsId) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(commitsId);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        GitLogRecord logRecord = parser.parseOneRecord(output);
        if (logRecord == null) {
            throw new VcsException("Can not parse log output \"" + output + "\"");
        }
        return logRecord.getAuthorTimeStamp();
    }

    @Deprecated
    @NotNull
    public static FilePath getLastCommitName(@NotNull Project project, @NotNull FilePath path) {
        return VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(path);
        return GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        path = VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h);
            rc.add((Pair<SHAHash, Date>)Pair.create((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        return rc;
    }

    @Deprecated
    public static List<? extends VcsCommitMetadata> readLastCommits(@NotNull Project project, @NotNull VirtualFile root, String ... hashes2) throws VcsException {
        return GitHistoryUtils.collectCommitsMetadata(project, root, hashes2);
    }
}

