/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitFormatException;
import git4idea.GitUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitStringInterner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogParser {
    private static final Logger LOG = Logger.getInstance(GitLogParser.class);
    static final String RECORD_START = "\u0001\u0001";
    static final String ITEMS_SEPARATOR = "\u0002\u0002";
    static final String RECORD_END = "\u0003\u0003";
    private static final int MAX_SEPARATOR_LENGTH = 10;
    private static final char[] CONTROL_CHARS = new char[]{'\u0001', '\u0002', '\u0003'};
    private static final int INPUT_ERROR_MESSAGE_HEAD_LIMIT = 1000000;
    private static final int INPUT_ERROR_MESSAGE_TAIL_LIMIT = 100;
    private static final AtomicInteger ERROR_COUNT = new AtomicInteger();
    private final boolean mySupportsRawBody;
    @NotNull
    private final String myPretty;
    @NotNull
    private final OptionsParser myOptionsParser;
    @NotNull
    private final PathsParser myPathsParser;
    private final String myRecordStart;
    private final String myRecordEnd;
    private final String myItemsSeparator;
    private boolean myIsInBody = true;

    private GitLogParser(boolean supportsRawBody, @NotNull NameStatus nameStatusOption, GitLogOption ... options) {
        this.mySupportsRawBody = supportsRawBody;
        this.myRecordStart = RECORD_START + GitLogParser.generateRandomSequence();
        this.myRecordEnd = RECORD_END + GitLogParser.generateRandomSequence();
        this.myItemsSeparator = ITEMS_SEPARATOR + GitLogParser.generateRandomSequence();
        this.myPretty = "--pretty=format:" + this.makeFormatFromOptions(options);
        this.myOptionsParser = new OptionsParser(options);
        this.myPathsParser = new PathsParser(nameStatusOption);
    }

    public GitLogParser(@NotNull Project project, @NotNull NameStatus nameStatus, GitLogOption ... options) {
        this(GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(project), nameStatus, options);
    }

    public GitLogParser(@NotNull Project project, GitLogOption ... options) {
        this(project, NameStatus.NONE, options);
    }

    @NotNull
    public List<GitLogRecord> parse(@NotNull CharSequence output) {
        ArrayList result2 = ContainerUtil.newArrayList();
        List lines = StringUtil.split((CharSequence)output, (CharSequence)"\n", (boolean)true, (boolean)false);
        for (CharSequence line : lines) {
            try {
                GitLogRecord record = this.parseLine(line);
                if (record == null) continue;
                result2.add(record);
            }
            catch (GitFormatException e) {
                this.clear();
                LOG.error((Throwable)e);
            }
        }
        GitLogRecord record = this.finish();
        if (record != null) {
            result2.add(record);
        }
        return result2;
    }

    @Nullable
    public GitLogRecord parseOneRecord(@NotNull CharSequence output) {
        List<GitLogRecord> records = this.parse(output);
        this.clear();
        if (records.isEmpty()) {
            return null;
        }
        return (GitLogRecord)ContainerUtil.getFirstItem(records);
    }

    @Nullable
    public GitLogRecord parseLine(@NotNull CharSequence line) {
        if (this.myPathsParser.expectsPaths()) {
            return this.parseLineWithPaths(line);
        }
        return this.parseLineWithoutPaths(line);
    }

    @Nullable
    private GitLogRecord parseLineWithPaths(@NotNull CharSequence line) {
        if (this.myIsInBody) {
            this.myIsInBody = !this.myOptionsParser.parseLine(line);
        } else {
            if (CharArrayUtil.regionMatches((CharSequence)line, (int)0, (CharSequence)this.myRecordStart)) {
                GitLogRecord record = this.createRecord();
                this.myIsInBody = !this.myOptionsParser.parseLine(line);
                return record;
            }
            this.myPathsParser.parseLine(line);
        }
        return null;
    }

    @Nullable
    private GitLogRecord parseLineWithoutPaths(@NotNull CharSequence line) {
        if (this.myOptionsParser.parseLine(line)) {
            return this.createRecord();
        }
        return null;
    }

    @Nullable
    public GitLogRecord finish() {
        if (this.myOptionsParser.isEmpty()) {
            return null;
        }
        return this.createRecord();
    }

    @NotNull
    private GitLogRecord createRecord() {
        Map<GitLogOption, String> options = this.myOptionsParser.getResult();
        this.myOptionsParser.clear();
        List<VcsFileStatusInfo> result2 = this.myPathsParser.getResult();
        this.myPathsParser.clear();
        this.myIsInBody = true;
        return new GitLogRecord(options, result2, this.mySupportsRawBody);
    }

    public void clear() {
        this.myOptionsParser.clear();
        this.myPathsParser.clear();
        this.myIsInBody = true;
    }

    @NotNull
    public String getPretty() {
        return this.myPretty;
    }

    @NotNull
    private String makeFormatFromOptions(@NotNull GitLogOption[] options) {
        Function function = option -> "%" + ((GitLogOption)option).getPlaceholder();
        return GitLogParser.encodeForGit(this.myRecordStart) + StringUtil.join((Object[])options, (Function)function, (String)GitLogParser.encodeForGit(this.myItemsSeparator)) + GitLogParser.encodeForGit(this.myRecordEnd);
    }

    @NotNull
    private static String encodeForGit(@NotNull String line) {
        StringBuilder encoded = new StringBuilder();
        line.chars().forEachOrdered(c -> encoded.append("%x").append(String.format("%02x", c)));
        return encoded.toString();
    }

    @NotNull
    private static String generateRandomSequence() {
        int length = ERROR_COUNT.get() % (10 - RECORD_START.length());
        StringBuilder tail = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int randomIndex = ThreadLocalRandom.current().nextInt(0, CONTROL_CHARS.length);
            tail.append(CONTROL_CHARS[randomIndex]);
        }
        return tail.toString();
    }

    private static void throwGFE(@NotNull String message, @NotNull CharSequence line) {
        ERROR_COUNT.incrementAndGet();
        throw new GitFormatException(message + " [" + GitLogParser.getTruncatedEscapedOutput(line) + "]");
    }

    @NotNull
    private static String getTruncatedEscapedOutput(@NotNull CharSequence line) {
        String formatString = "%s...(%d more characters)...%s";
        String lineString = line.length() > 1000100 + formatString.length() ? String.format(formatString, line.subSequence(0, 1000000), line.length() - 1000000 - 100, line.subSequence(line.length() - 100, line.length())) : line.toString();
        return StringUtil.escapeStringCharacters((String)lineString);
    }

    private static class PartialResult {
        @NotNull
        private List<String> myResult = ContainerUtil.newArrayList();
        @NotNull
        private final StringBuilder myCurrentItem = new StringBuilder();

        private PartialResult() {
        }

        public void append(char c) {
            this.myCurrentItem.append(c);
        }

        public void finishItem() {
            this.myResult.add(this.myCurrentItem.toString());
            this.myCurrentItem.setLength(0);
        }

        @NotNull
        public List<String> getResult() {
            return this.myResult;
        }

        public void clear() {
            this.myCurrentItem.setLength(0);
            this.myResult = ContainerUtil.newArrayList();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty() && this.myCurrentItem.length() == 0;
        }
    }

    private class PathsParser {
        @NotNull
        private final NameStatus myNameStatusOption;
        @NotNull
        private List<VcsFileStatusInfo> myStatuses = ContainerUtil.newArrayList();

        PathsParser(NameStatus nameStatusOption) {
            this.myNameStatusOption = nameStatusOption;
        }

        public void parseLine(@NotNull CharSequence line) {
            if (line.length() == 0) {
                return;
            }
            List<String> match2 = this.parsePathsLine(line);
            if (!match2.isEmpty()) {
                if (this.myNameStatusOption != NameStatus.STATUS) {
                    GitLogParser.throwGFE("Status list not expected", line);
                }
                if (match2.size() < 2) {
                    LOG.error("Could not parse status line [" + line + "] for record " + GitLogParser.this.myOptionsParser.myResult.getResult());
                } else if (match2.size() == 2) {
                    this.myStatuses.add(this.createStatusInfo(match2.get(0), match2.get(1), null));
                } else {
                    this.myStatuses.add(this.createStatusInfo(match2.get(0), match2.get(1), match2.get(2)));
                }
            }
        }

        @NotNull
        private VcsFileStatusInfo createStatusInfo(@NotNull String type, @NotNull String firstPath, @Nullable String secondPath) {
            return new VcsFileStatusInfo(GitChangesParser.getChangeType(GitChangeType.fromString(type)), this.tryUnescapePath(firstPath), this.tryUnescapePath(secondPath));
        }

        @Nullable
        @Contract(value="!null -> !null")
        private String tryUnescapePath(@Nullable String path) {
            if (path == null) {
                return null;
            }
            try {
                return GitStringInterner.intern(GitUtil.unescapePath(path));
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                return GitStringInterner.intern(path);
            }
        }

        @NotNull
        private List<String> parsePathsLine(@NotNull CharSequence line) {
            PartialResult result2 = new PartialResult();
            for (int offset = 0; offset < line.length() && !this.atLineEnd(line, offset); ++offset) {
                char charAt = line.charAt(offset);
                if (charAt == '\t') {
                    result2.finishItem();
                    continue;
                }
                result2.append(charAt);
            }
            result2.finishItem();
            return result2.getResult();
        }

        private boolean atLineEnd(@NotNull CharSequence line, int offset) {
            while (offset < line.length() && line.charAt(offset) == '\t') {
                ++offset;
            }
            return offset == line.length() || line.charAt(offset) == '\n' || line.charAt(offset) == '\r';
        }

        @NotNull
        public List<VcsFileStatusInfo> getResult() {
            return this.myStatuses;
        }

        public void clear() {
            this.myStatuses = ContainerUtil.newArrayList();
        }

        public boolean expectsPaths() {
            return this.myNameStatusOption == NameStatus.STATUS;
        }
    }

    private class OptionsParser {
        @NotNull
        private final GitLogOption[] myOptions;
        @NotNull
        private final PartialResult myResult = new PartialResult();

        OptionsParser(GitLogOption[] options) {
            this.myOptions = options;
        }

        public boolean parseLine(@NotNull CharSequence line) {
            int offset = 0;
            if (this.myResult.isEmpty()) {
                if (!CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordStart)) {
                    return false;
                }
                offset += GitLogParser.this.myRecordStart.length();
            }
            while (offset < line.length()) {
                if (this.atRecordEnd(line, offset)) {
                    this.myResult.finishItem();
                    if (this.myResult.getResult().size() != this.myOptions.length) {
                        GitLogParser.throwGFE("Parsed incorrect options " + this.myResult.getResult() + " for " + Arrays.toString((Object[])this.myOptions), line);
                    }
                    return true;
                }
                if (CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myItemsSeparator)) {
                    this.myResult.finishItem();
                    offset += GitLogParser.this.myItemsSeparator.length();
                    continue;
                }
                char c = line.charAt(offset);
                this.myResult.append(c);
                ++offset;
            }
            this.myResult.append('\n');
            return false;
        }

        private boolean atRecordEnd(@NotNull CharSequence line, int offset) {
            return offset == line.length() - GitLogParser.this.myRecordEnd.length() && CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordEnd);
        }

        @NotNull
        public Map<GitLogOption, String> getResult() {
            return this.createOptions(this.myResult.getResult());
        }

        @NotNull
        private Map<GitLogOption, String> createOptions(@NotNull List<String> options) {
            HashMap<GitLogOption, String> optionsMap = new HashMap<GitLogOption, String>(options.size());
            for (int index = 0; index < options.size(); ++index) {
                optionsMap.put(this.myOptions[index], GitStringInterner.intern(options.get(index)));
            }
            return optionsMap;
        }

        public void clear() {
            this.myResult.clear();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty();
        }
    }

    static enum GitLogOption {
        HASH("H"),
        TREE("T"),
        COMMIT_TIME("ct"),
        AUTHOR_NAME("an"),
        AUTHOR_TIME("at"),
        AUTHOR_EMAIL("ae"),
        COMMITTER_NAME("cn"),
        COMMITTER_EMAIL("ce"),
        SUBJECT("s"),
        BODY("b"),
        PARENTS("P"),
        REF_NAMES("d"),
        SHORT_REF_LOG_SELECTOR("gd"),
        RAW_BODY("B");

        private final String myPlaceholder;

        private GitLogOption(String placeholder) {
            this.myPlaceholder = placeholder;
        }

        private String getPlaceholder() {
            return this.myPlaceholder;
        }
    }

    static enum NameStatus {
        NONE,
        STATUS;

    }
}

