/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogRecordCollector
implements Consumer<GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogRecordCollector.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final Consumer<List<GitLogRecord>> myConsumer;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToRecord = MultiMap.createLinked();
    @Nullable
    private String myLastHash = null;

    protected GitLogRecordCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<List<GitLogRecord>> consumer) {
        this.myProject = project;
        this.myRoot = root;
        this.myConsumer = consumer;
    }

    public void consume(@NotNull GitLogRecord record) {
        if (!record.getHash().equals(this.myLastHash)) {
            this.processCollectedRecords();
        }
        this.myLastHash = record.getHash();
        this.myHashToRecord.putValue((Object)record.getHash(), (Object)record);
        String[] parents = record.getParentsHashes();
        if (parents.length == 0 || parents.length == this.myHashToRecord.get((Object)record.getHash()).size()) {
            this.processCollectedRecords();
        }
    }

    public void finish() {
        this.processCollectedRecords();
    }

    protected void processCollectedRecords() {
        for (String hash : this.myHashToRecord.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToRecord.get((Object)hash))));
            GitLogRecord firstRecord = (GitLogRecord)records.get(0);
            if (firstRecord.getParentsHashes().length != 0 && records.size() != firstRecord.getParentsHashes().length) {
                this.processIncompleteRecord(hash, records);
                continue;
            }
            this.myConsumer.consume((Object)records);
        }
        this.myHashToRecord.clear();
    }

    protected void processIncompleteRecord(@NotNull String hash, @NotNull List<GitLogRecord> records) {
        MultiMap incompleteRecords = MultiMap.create();
        incompleteRecords.put((Object)hash, records);
        try {
            GitLogRecordCollector.processIncompleteRecords((MultiMap<String, GitLogRecord>)incompleteRecords, this.myProject, this.myRoot, this.myConsumer);
        }
        catch (VcsException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void processIncompleteRecords(@NotNull MultiMap<String, GitLogRecord> incompleteRecords, @NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super List<GitLogRecord>> consumer) throws VcsException {
        List firstRecords = ContainerUtil.map((Collection)incompleteRecords.entrySet(), e -> (GitLogRecord)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue())));
        Map<String, String> hashToTreeMap = GitLogRecordCollector.getHashToTreeMap(project, root, firstRecords);
        for (String hash : incompleteRecords.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)incompleteRecords.get((Object)hash))));
            GitLogRecordCollector.fillWithEmptyRecords(records, hashToTreeMap);
            consumer.consume((Object)records);
        }
    }

    @NotNull
    private static Map<String, String> getHashToTreeMap(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<GitLogRecord> records) throws VcsException {
        HashSet hashes2 = ContainerUtil.newHashSet();
        for (GitLogRecord r : records) {
            hashes2.add(r.getHash());
            ContainerUtil.addAll((Collection)hashes2, (Object[])r.getParentsHashes());
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.TREE);
        GitVcs vcs = GitVcs.getInstance(project);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty());
        handler.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        handler.addParameters("--stdin");
        handler.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        String output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        List<GitLogRecord> hashAndTreeRecords = parser.parse(output);
        return ContainerUtil.map2Map(hashAndTreeRecords, record -> Pair.create((Object)record.getHash(), (Object)record.getTreeHash()));
    }

    private static void fillWithEmptyRecords(@NotNull List<GitLogRecord> records, @NotNull Map<String, String> hashToTreeMap) {
        GitLogRecord firstRecord = records.get(0);
        String commit2 = firstRecord.getHash();
        String[] parents = firstRecord.getParentsHashes();
        String commitTreeHash = hashToTreeMap.get(commit2);
        LOG.assertTrue(commitTreeHash != null, (Object)("Could not get tree hash for commit " + commit2));
        for (int parentIndex = 0; parentIndex < parents.length; ++parentIndex) {
            String parent = parents[parentIndex];
            String parentTreeHash = hashToTreeMap.get(parent);
            LOG.assertTrue(parentTreeHash != null, (Object)("Could not get tree hash for commit " + parent));
            if (!parentTreeHash.equals(commitTreeHash) || records.size() >= parents.length) continue;
            records.add(parentIndex, new GitLogRecord(firstRecord.getOptions(), ContainerUtil.emptyList(), firstRecord.isSupportsRawBody()));
        }
    }
}

