/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordCollector;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GitLogUnorderedRecordCollector
extends GitLogRecordCollector {
    private static final Logger LOG = Logger.getInstance(GitLogUnorderedRecordCollector.class);
    private static final int STATUS_LINES_THRESHOLD = 20000;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToIncompleteRecords = MultiMap.createLinked();
    private int myIncompleteStatusLinesCount = 0;

    protected GitLogUnorderedRecordCollector(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<List<GitLogRecord>> consumer) {
        super(project, root, consumer);
    }

    @Override
    protected void processCollectedRecords() {
        this.processCollectedRecords(false);
    }

    private void processCollectedRecords(boolean processIncompleteRecords) {
        super.processCollectedRecords();
        if (!this.myHashToIncompleteRecords.isEmpty() && (processIncompleteRecords || this.myIncompleteStatusLinesCount >= 20000)) {
            try {
                GitLogUnorderedRecordCollector.processIncompleteRecords(this.myHashToIncompleteRecords, this.myProject, this.myRoot, (Consumer<? super List<GitLogRecord>>)this.myConsumer);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myHashToIncompleteRecords.clear();
                this.myIncompleteStatusLinesCount = 0;
            }
        }
    }

    @Override
    protected void processIncompleteRecord(@NotNull String hash, @NotNull List<GitLogRecord> records) {
        this.myHashToIncompleteRecords.put((Object)hash, records);
        records.forEach(r -> this.myIncompleteStatusLinesCount += r.getStatusInfos().size());
    }

    @Override
    public void finish() {
        this.processCollectedRecords(true);
    }
}

