/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordCollector;
import git4idea.history.GitLogUnorderedRecordCollector;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";

    @NotNull
    public static List<? extends VcsCommitMetadata> collectShortDetails(@NotNull Project project, @NotNull GitVcs vcs, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        GitLineHandler h = GitLogUtil.createGitHandler(project, root);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(STDIN);
        h.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, h);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        List<GitLogRecord> records = parser.parse(output);
        return ContainerUtil.map(records, record -> {
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            record.setUsedHandler(h);
            return factory.createCommitMetadata(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable Consumer<? super VcsUser> userConsumer, @Nullable Consumer<? super VcsRef> refConsumer, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
        ArrayList options = ContainerUtil.newArrayList((Object[])new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME});
        if (userConsumer != null) {
            options.add(GitLogParser.GitLogOption.AUTHOR_NAME);
            options.add(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        }
        if (refConsumer != null) {
            options.add(GitLogParser.GitLogOption.REF_NAMES);
        }
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, options.toArray(new GitLogParser.GitLogOption[0]));
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        handler.addParameters(parameters);
        handler.endOptions();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, parser, (Consumer<? super GitLogRecord>)((Consumer)record -> {
            Hash hash = HashImpl.build((String)record.getHash());
            List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
            commitConsumer.consume((Object)factory.createTimedCommit(hash, parents, record.getCommitTime()));
            if (refConsumer != null) {
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.consume((Object)ref);
                }
            }
            if (userConsumer != null) {
                userConsumer.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        }));
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        handlerListener.reportErrors();
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        return ContainerUtil.mapNotNull(refs, refName -> {
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, boolean lowPriorityProcess, String ... params) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return LogDataImpl.empty();
        }
        OpenTHashSet refs = new OpenTHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        List<VcsCommitMetadata> commits2 = GitLogUtil.collectMetadata(project, root, lowPriorityProcess, (NullableFunction<GitLogRecord, VcsCommitMetadata>)((NullableFunction)arg_0 -> GitLogUtil.lambda$collectMetadata$4(project, root, factory, (Set)refs, arg_0)), params);
        return new LogDataImpl((Set)refs, commits2);
    }

    @NotNull
    private static List<VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, boolean lowPriorityProcess, @NotNull NullableFunction<GitLogRecord, VcsCommitMetadata> converter, String ... parameters) throws VcsException {
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(false, false, DiffRenameLimit.GIT_CONFIG), lowPriorityProcess);
            GitLogUtil.readRecordsFromHandler(project, root, true, false, false, false, (Consumer<GitLogRecord>)((Consumer)record -> commits2.add(converter.fun(record))), handler, parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return commits2;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory) {
        return GitLogUtil.createCommit(project, root, records, factory, DiffRenameLimit.GIT_CONFIG);
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory, @NotNull DiffRenameLimit renameLimit) {
        GitLogRecord record = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(records));
        List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
        return new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), ContainerUtil.map(records, GitLogRecord::getStatusInfos), renameLimit);
    }

    @NotNull
    public static List<Hash> getParentHashes(@NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        return ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
    }

    @NotNull
    public static List<GitCommit> collectFullDetails(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLogUtil.readFullDetails(project, root, (Consumer<? super GitCommit>)((Consumer)commits2::add), true, true, false, parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return commits2;
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, boolean includeRootChanges, boolean preserverOrder, boolean lowPriorityProcess, String ... parameters) throws VcsException {
        GitLogUtil.readFullDetails(project, root, commitConsumer, includeRootChanges, preserverOrder, lowPriorityProcess, true, true, parameters);
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, boolean includeRootChanges, boolean preserverOrder, boolean lowPriorityProcess, boolean withRenames, boolean withFullMergeDiff, String ... parameters) throws VcsException {
        DiffRenameLimit renameLimit = withRenames ? DiffRenameLimit.REGISTRY : DiffRenameLimit.NO_RENAMES;
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(true, includeRootChanges, renameLimit), lowPriorityProcess);
        GitLogUtil.readFullDetailsFromHandler(project, root, commitConsumer, renameLimit, handler, preserverOrder, withFullMergeDiff, parameters);
    }

    private static void readFullDetailsFromHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull DiffRenameLimit renameLimit, @NotNull GitLineHandler handler, boolean preserverOrder, boolean withFullMergeDiff, String ... parameters) throws VcsException {
        boolean withRenames;
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        boolean bl = withRenames = renameLimit != DiffRenameLimit.NO_RENAMES;
        if (withFullMergeDiff) {
            Consumer consumer = records -> {
                GitLogRecord firstRecord = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)records));
                String[] parents = firstRecord.getParentsHashes();
                LOG.assertTrue(parents.length == 0 || parents.length == records.size(), (Object)("Not enough records for commit " + firstRecord.getHash() + " expected " + parents.length + " records, but got " + records.size()));
                commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, records, factory, renameLimit));
            };
            GitLogRecordCollector recordCollector = preserverOrder ? new GitLogRecordCollector(project, root, (Consumer<List<GitLogRecord>>)consumer) : new GitLogUnorderedRecordCollector(project, root, (Consumer<List<GitLogRecord>>)consumer);
            GitLogUtil.readRecordsFromHandler(project, root, false, true, withRenames, true, recordCollector, handler, parameters);
            recordCollector.finish();
        } else {
            Consumer consumer = record -> commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, ContainerUtil.newArrayList((Object[])new GitLogRecord[]{record}), factory, renameLimit));
            GitLogUtil.readRecordsFromHandler(project, root, false, true, withRenames, false, (Consumer<GitLogRecord>)consumer, handler, parameters);
        }
    }

    private static void readRecordsFromHandler(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, boolean withRenames, boolean withFullMergeDiff, @NotNull Consumer<GitLogRecord> converter, @NotNull GitLineHandler handler, String ... parameters) throws VcsException {
        GitLogParser parser = GitLogUtil.createParserForDetails(handler, project, withRefs, withChanges, withRenames, withFullMergeDiff, parameters);
        StopWatch sw = StopWatch.start((String)("loading details in [" + root.getName() + "]"));
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, parser, converter);
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        handlerListener.reportErrors();
        sw.report();
    }

    @NotNull
    private static GitLogParser createParserForDetails(@NotNull GitTextHandler h, @NotNull Project project, boolean withRefs, boolean withChanges, boolean withRenames, boolean withFullMergeDiff, String ... parameters) {
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};
        if (withRefs) {
            options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])options, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
        }
        GitLogParser parser = new GitLogParser(project, status, options);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        if (withRefs) {
            h.addParameters("--decorate=full");
        }
        if (withChanges) {
            h.addParameters("--name-status");
        }
        if (withRenames) {
            h.addParameters("-M");
        }
        if (withFullMergeDiff) {
            h.addParameters("-m");
        }
        h.endOptions();
        return parser;
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitVcs vcs, @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull List<String> hashes2, boolean includeRootChanges, boolean lowPriorityProcess, @NotNull DiffRenameLimit renameLimit) throws VcsException {
        GitLogUtil.readFullDetailsForHashes(project, root, vcs, commitConsumer, hashes2, includeRootChanges, lowPriorityProcess, true, false, renameLimit);
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitVcs vcs, @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull List<String> hashes2, boolean includeRootChanges, boolean lowPriorityProcess, boolean withFullMergeDiff, boolean preserverOrder, @NotNull DiffRenameLimit renameLimit) throws VcsException {
        if (hashes2.isEmpty()) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(true, includeRootChanges, renameLimit), lowPriorityProcess);
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        GitLogUtil.readFullDetailsFromHandler(project, root, commitConsumer, renameLimit, handler, preserverOrder, withFullMergeDiff, GitLogUtil.getNoWalkParameter(vcs), STDIN);
    }

    public static void sendHashesToStdin(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        String separator = GitVersionSpecialty.LF_SEPARATORS_IN_STDIN.existsIn(vcs.getVersion()) ? "\n" : System.lineSeparator();
        handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(hashes2, separator, handler.getCharset(), true));
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull GitVcs vcs) {
        return GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(vcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
    }

    @NotNull
    public static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        return GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
    }

    @NotNull
    private static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, boolean lowPriorityProcess) {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, configParameters);
        if (lowPriorityProcess) {
            handler.withLowPriority();
        }
        handler.setWithMediator(false);
        return handler;
    }

    @NotNull
    private static List<String> createConfigParameters(boolean withChanges, boolean includeRootChanges, @NotNull DiffRenameLimit renameLimit) {
        if (!withChanges) {
            return Collections.emptyList();
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        switch (renameLimit) {
            case INFINITY: {
                result2.add(GitLogUtil.renameLimit(0));
                break;
            }
            case REGISTRY: {
                result2.add(GitLogUtil.renameLimit(Registry.intValue((String)"git.diff.renameLimit")));
                break;
            }
            case NO_RENAMES: {
                result2.add("diff.renames=false");
                break;
            }
        }
        if (!includeRootChanges) {
            result2.add("log.showRoot=false");
        }
        return result2;
    }

    @NotNull
    private static String renameLimit(int limit) {
        return "diff.renameLimit=" + limit;
    }

    private static /* synthetic */ VcsCommitMetadata lambda$collectMetadata$4(Project project, VirtualFile root, VcsLogObjectsFactory factory, Set refs, GitLogRecord record) {
        GitCommit commit2 = GitLogUtil.createCommit(project, root, Collections.singletonList(record), factory);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), commit2.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
        return commit2;
    }

    public static enum DiffRenameLimit {
        INFINITY,
        REGISTRY,
        GIT_CONFIG,
        NO_RENAMES;

    }
}

