/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStringInterner {
    @Nullable
    private static ConcurrentMap<String, String> ourStringCache;
    @NotNull
    private static final AtomicLong ourTotalSize;
    @NotNull
    private static final AtomicLong ourUniqueSize;

    public static void clearAndEnable() {
        ourTotalSize.set(0L);
        ourUniqueSize.set(0L);
        ourStringCache = new ConcurrentHashMap<String, String>();
    }

    public static double clearAndDisable() {
        long totalSize = ourTotalSize.getAndSet(0L);
        long uniqueSize = ourUniqueSize.getAndSet(0L);
        ourStringCache = null;
        return totalSize == 0L ? 0.0 : (double)(totalSize - uniqueSize) / (double)totalSize;
    }

    @NotNull
    public static String intern(@NotNull String str) {
        ConcurrentMap<String, String> cache = ourStringCache;
        if (cache == null) {
            return str;
        }
        String s = cache.computeIfAbsent(str, Function.identity());
        int length = s.length();
        ourTotalSize.addAndGet(length);
        if (s == str) {
            ourUniqueSize.addAndGet(length);
        }
        return s;
    }

    static {
        ourTotalSize = new AtomicLong();
        ourUniqueSize = new AtomicLong();
    }
}

