/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.ignore.GitIgnoreChecker;
import git4idea.ignore.GitIgnoredFileContentProvider$WhenMappings;
import git4idea.ignore.GitIgnoredFileContentProviderKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J8\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"*\b\u0012\u0004\u0012\u00020\u00190#2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/ignore/GitIgnoredFileContentProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "gitIgnoreChecker", "Lgit4idea/ignore/GitIgnoreChecker;", "buildIgnoreFileContent", "", "ignoreFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignoredFileProviders", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;)Ljava/lang/String;", "getFileName", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getUntrackedFiles", "", "prependCommentHashCharacterIfNeeded", "description", "shouldIgnoreByMask", "", "ignoredBean", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "untrackedFiles", "shouldIgnoreFile", "vcsRoot", "vcsContextFactory", "Lcom/intellij/openapi/vcs/actions/VcsContextFactory;", "shouldIgnoreUnderDir", "shouldNotConsiderInternalIgnoreFile", "ignoreBeansToRelativePaths", "", "", "intellij.vcs.git"})
public class GitIgnoredFileContentProvider
implements IgnoredFileContentProvider {
    private final GitIgnoreChecker gitIgnoreChecker;
    private final Project project;

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    @NotNull
    public String getFileName() {
        return ".gitignore";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String buildIgnoreFileContent(@NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileProvider[] ignoredFileProviders) {
        if (!GitUtil.isUnderGit(ignoreFileRoot)) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        Set<VirtualFile> untrackedFiles = this.getUntrackedFiles(ignoreFileRoot);
        int n = 0;
        int n2 = ignoredFileProviders.length;
        while (n < n2) {
            void i;
            IgnoredFileProvider provider = ignoredFileProviders[i];
            List<String> ignoredFiles = this.ignoreBeansToRelativePaths(provider.getIgnoredFiles(this.project), ignoreFileRoot, untrackedFiles);
            if (!ignoredFiles.isEmpty()) {
                String description;
                CharSequence charSequence;
                CharSequence charSequence2 = content;
                if (!(charSequence2.length() == 0)) {
                    content.append(lineSeparator).append(lineSeparator);
                }
                if (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)(description = provider.getIgnoredGroupDescription())))) {
                    content.append(this.prependCommentHashCharacterIfNeeded(description));
                    content.append(lineSeparator);
                }
                content.append(CollectionsKt.joinToString$default((Iterable)ignoredFiles, (CharSequence)lineSeparator, null, null, (int)0, null, null, (int)62, null));
            }
            ++i;
        }
        return content.toString();
    }

    private final Set<VirtualFile> getUntrackedFiles(VirtualFile ignoreFileRoot) {
        Set set;
        try {
            set = Git.getInstance().untrackedFiles(this.project, ignoreFileRoot, null);
        }
        catch (VcsException e) {
            GitIgnoredFileContentProviderKt.access$getLOG$p().warn("Cannot get untracked files: ", (Throwable)e);
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final List<String> ignoreBeansToRelativePaths(@NotNull Iterable<? extends IgnoredFileDescriptor> $receiver, VirtualFile ignoreFileRoot, Set<? extends VirtualFile> untrackedFiles) {
        IgnoredFileDescriptor ignoredBean;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)ignoreFileRoot);
        VcsContextFactory vcsContextFactory = VcsContextFactory.SERVICE.getInstance();
        Iterable iterable = $receiver$iv = $receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            ignoredBean = (IgnoredFileDescriptor)element$iv$iv;
            boolean bl2 = false;
            switch (GitIgnoredFileContentProvider$WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
                case 1: {
                    bl = this.shouldIgnoreUnderDir(ignoredBean, ignoreFileRoot, vcsRoot, vcsContextFactory);
                    break;
                }
                case 2: {
                    bl = this.shouldIgnoreFile(ignoredBean, untrackedFiles, ignoreFileRoot, vcsRoot, vcsContextFactory);
                    break;
                }
                case 3: {
                    bl = this.shouldIgnoreByMask(ignoredBean, untrackedFiles);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            ignoredBean = (IgnoredFileDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (GitIgnoredFileContentProvider$WhenMappings.$EnumSwitchMapping$1[ignoredBean.getType().ordinal()]) {
                case 1: {
                    string = ignoredBean.getMask();
                    if (string != null) break;
                    Intrinsics.throwNpe();
                    break;
                }
                case 2: {
                    StringBuilder stringBuilder = new StringBuilder().append('/');
                    String string2 = ignoreFileRoot.getPath();
                    String string3 = ignoredBean.getPath();
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string4 = FileUtil.getRelativePath((String)string2, (String)string3, (char)'/');
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = stringBuilder.append(string4).toString();
                    break;
                }
                case 3: {
                    StringBuilder stringBuilder = new StringBuilder().append('/');
                    String string5 = ignoreFileRoot.getPath();
                    String string6 = ignoredBean.getPath();
                    if (string6 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string7 = FileUtil.getRelativePath((String)string5, (String)string6, (char)'/');
                    if (string7 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = stringBuilder.append(string7).toString();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String string8 = string;
            collection.add(string8);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreUnderDir(IgnoredFileDescriptor ignoredBean, VirtualFile ignoreFileRoot, VirtualFile vcsRoot, VcsContextFactory vcsContextFactory) {
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        String string = ignoreFileRoot.getPath();
        String string2 = ignoredBean.getPath();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (!FileUtil.isAncestor((String)string, (String)string2, (boolean)false)) return false;
        String string3 = ignoredBean.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if (!Comparing.equal((Object)vcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string3, true)))) return false;
        VirtualFile virtualFile = vcsRoot;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        String string4 = ignoredBean.getPath();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        if (!(this.gitIgnoreChecker.isIgnored(virtualFile, new File(string4)) instanceof NotIgnored)) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreFile(IgnoredFileDescriptor ignoredBean, Set<? extends VirtualFile> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile vcsRoot, VcsContextFactory vcsContextFactory) {
        VirtualFile it;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $receiver$iv = untrackedFiles;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VirtualFile)element$iv;
            boolean bl = false;
        } while (!ignoredBean.matchesFile(it));
        boolean bl = true;
        if (!bl) return false;
        String string = ignoreFileRoot.getPath();
        String string2 = ignoredBean.getPath();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (!FileUtil.isAncestor((String)string, (String)string2, (boolean)false)) return false;
        String string3 = ignoredBean.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if (!Comparing.equal((Object)vcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string3, false)))) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    private final boolean shouldIgnoreByMask(IgnoredFileDescriptor ignoredBean, Set<? extends VirtualFile> untrackedFiles) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = untrackedFiles;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!ignoredBean.matchesFile(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldNotConsiderInternalIgnoreFile(IgnoredFileDescriptor ignoredBean, VirtualFile ignoreFileRoot) {
        boolean insideDirectoryStore;
        String string = ignoredBean.getPath();
        boolean bl = insideDirectoryStore = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)".idea", (boolean)false, (int)2, null) : false;
        if (insideDirectoryStore) {
            Object object = ProjectKt.getStateStore((Project)this.project).getDirectoryStoreFile();
            if (object == null) {
                VirtualFile virtualFile = this.project.getProjectFile();
                object = virtualFile != null ? virtualFile.getParent() : null;
            }
            if (object == null) {
                return false;
            }
            VirtualFile directoryStoreOrProjectFileLocation = object;
            return FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)directoryStoreOrProjectFileLocation), (File)VfsUtilCore.virtualToIoFile((VirtualFile)ignoreFileRoot), (boolean)false);
        }
        return true;
    }

    private final String prependCommentHashCharacterIfNeeded(String description) {
        return StringsKt.startsWith$default((String)description, (String)"#", (boolean)false, (int)2, null) ? description : "# " + description;
    }

    public GitIgnoredFileContentProvider(@NotNull Project project) {
        this.project = project;
        this.gitIgnoreChecker = new GitIgnoreChecker(this.project);
    }
}

