/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Log.External.Tabs.Properties", storages={@Storage(value="git.external.log.tabs.xml", roamingType=RoamingType.DISABLED)})
public class GitExternalLogTabsProperties
implements PersistentStateComponent<State>,
VcsLogTabsProperties {
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;
    @NotNull
    private final ProjectManager myProjectManager;
    private State myState = new State();

    public GitExternalLogTabsProperties(@NotNull VcsLogApplicationSettings settings, @NotNull ProjectManager projectManager) {
        this.myAppSettings = settings;
        this.myProjectManager = projectManager;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    @NotNull
    public MainVcsLogUiProperties createProperties(@NotNull String id) {
        if (!this.myState.TAB_STATES.containsKey(id)) {
            this.myState.TAB_STATES.put(id, this.createOrMigrateTabState(id));
        }
        return new MyVcsLogUiProperties(id);
    }

    @NotNull
    private TabState createOrMigrateTabState(@NotNull String id) {
        Project[] projects;
        for (Project project : projects = this.myProjectManager.getOpenProjects()) {
            VcsLogUiPropertiesImpl.State oldState;
            VcsLogProjectTabsProperties projectTabsProperties = (VcsLogProjectTabsProperties)ServiceManager.getServiceIfCreated((Project)project, VcsLogProjectTabsProperties.class);
            if (projectTabsProperties == null || (oldState = projectTabsProperties.removeTabState(id)) == null) continue;
            TabState newState = new TabState();
            newState.SHOW_DETAILS_IN_CHANGES = oldState.SHOW_DETAILS_IN_CHANGES;
            newState.LONG_EDGES_VISIBLE = oldState.LONG_EDGES_VISIBLE;
            newState.BEK_SORT_TYPE = oldState.BEK_SORT_TYPE;
            newState.SHOW_ROOT_NAMES = oldState.SHOW_ROOT_NAMES;
            newState.RECENT_FILTERS.put("Branch", GitExternalLogTabsProperties.convertToRecentGroups(oldState.RECENTLY_FILTERED_BRANCH_GROUPS));
            newState.RECENT_FILTERS.put("User", GitExternalLogTabsProperties.convertToRecentGroups(oldState.RECENTLY_FILTERED_USER_GROUPS));
            newState.HIGHLIGHTERS.putAll(oldState.HIGHLIGHTERS);
            newState.FILTERS.putAll(oldState.FILTERS);
            newState.COLUMN_WIDTH.putAll(oldState.COLUMN_WIDTH);
            newState.COLUMN_ORDER.addAll(oldState.COLUMN_ORDER);
            newState.TEXT_FILTER_SETTINGS.MATCH_CASE = oldState.TEXT_FILTER_SETTINGS.MATCH_CASE;
            newState.TEXT_FILTER_SETTINGS.REGEX = oldState.TEXT_FILTER_SETTINGS.REGEX;
            return newState;
        }
        return new TabState();
    }

    @NotNull
    private static List<VcsLogProjectTabsProperties.RecentGroup> convertToRecentGroups(Deque<VcsLogUiPropertiesImpl.UserGroup> groups) {
        return new ArrayList<VcsLogProjectTabsProperties.RecentGroup>(ContainerUtil.map2List(groups, VcsLogProjectTabsProperties.RecentGroup::new));
    }

    private class MyVcsLogUiProperties
    extends VcsLogUiPropertiesImpl<TabState> {
        @NotNull
        private final String myId;

        MyVcsLogUiProperties(String id) {
            super(GitExternalLogTabsProperties.this.myAppSettings);
            this.myId = id;
        }

        @NotNull
        public TabState getState() {
            return ((GitExternalLogTabsProperties)GitExternalLogTabsProperties.this).myState.TAB_STATES.get(this.myId);
        }

        public void loadState(@NotNull TabState state) {
            ((GitExternalLogTabsProperties)GitExternalLogTabsProperties.this).myState.TAB_STATES.put(this.myId, state);
        }

        public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
            VcsLogProjectTabsProperties.addRecentGroup(this.getState().RECENT_FILTERS, (String)filterName, values);
        }

        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
            return VcsLogProjectTabsProperties.getRecentGroup(this.getState().RECENT_FILTERS, (String)filterName);
        }
    }

    public static class TabState
    extends VcsLogUiPropertiesImpl.State {
        @XCollection
        public Map<String, List<VcsLogProjectTabsProperties.RecentGroup>> RECENT_FILTERS = ContainerUtil.newHashMap();
    }

    public static class State {
        @XMap
        public Map<String, TabState> TAB_STATES = ContainerUtil.newTreeMap();
    }
}

