/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.UserNameRegex;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogUtil;
import git4idea.log.GitBekParentFixer;
import git4idea.log.GitLogDiffHandler;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    public static final Function<VcsRef, String> GET_TAG_NAME = ref -> ref.getType() == GitRefManager.TAG ? ref.getName() : null;
    public static final TObjectHashingStrategy<VcsRef> DONT_CONSIDER_SHA = new TObjectHashingStrategy<VcsRef>(){

        public int computeHashCode(@NotNull VcsRef ref) {
            return 31 * ref.getName().hashCode() + ref.getType().hashCode();
        }

        public boolean equals(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            return ref1.getName().equals(ref2.getName()) && ref1.getType().equals(ref2.getType());
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitUserRegistry myUserRegistry;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public GitLogProvider(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory, @NotNull GitUserRegistry userRegistry) {
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myUserRegistry = userRegistry;
        this.myRefSorter = new GitRefManager(this.myProject, (RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = factory;
        this.myVcs = GitVcs.getInstance(project);
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        Collection<Object> allDetails;
        if (!this.isRepositoryReady(root)) {
            return LogDataImpl.empty();
        }
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root));
        int commitCount = requirements.getCommitCount() * 2;
        String[] params = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        boolean refresh = requirements instanceof VcsLogProviderRequirementsEx && ((VcsLogProviderRequirementsEx)requirements).isRefresh();
        VcsLogProvider.DetailedLogData data = GitLogUtil.collectMetadata(this.myProject, root, false, params);
        Set safeRefs = data.getRefs();
        OpenTHashSet allRefs = new OpenTHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<VcsRef> branches2 = this.readBranches(repository);
        GitLogProvider.addNewElements(allRefs, branches2);
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh) {
            allDetails = data.getCommits();
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            GitLogProvider.addOldStillExistingTags((Set<? super VcsRef>)allRefs, currentTagNames, rex.getPreviousRefs());
            allDetails = GitLogProvider.newHashSet(data.getCommits());
            Set previousTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)rex.getPreviousRefs(), GET_TAG_NAME));
            Set safeTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)safeRefs, GET_TAG_NAME));
            Set<String> newUnmatchedTags = GitLogProvider.remove(currentTagNames, previousTags, safeTags);
            if (!newUnmatchedTags.isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        StopWatch sw = StopWatch.start((String)("sorting commits in " + root.getName()));
        List sortedCommits = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
        sortedCommits = ContainerUtil.getFirstItems((List)sortedCommits, (int)requirements.getCommitCount());
        sw.report();
        if (LOG.isDebugEnabled()) {
            GitLogProvider.validateDataAndReportError(root, (Set<? extends VcsRef>)allRefs, sortedCommits, data, branches2, currentTagNames, commitsFromTags);
        }
        return new LogDataImpl((Set)allRefs, GitBekParentFixer.fixCommits(sortedCommits));
    }

    private static void validateDataAndReportError(final @NotNull VirtualFile root, final @NotNull Set<? extends VcsRef> allRefs, final @NotNull List<? extends VcsCommitMetadata> sortedCommits, final @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, final @NotNull Set<? extends VcsRef> manuallyReadBranches, final @Nullable Set<String> currentTagNames, final @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        StopWatch sw = StopWatch.start((String)("validating data in " + root.getName()));
        final Set refs = ContainerUtil.map2Set(allRefs, VcsRef::getCommitHash);
        PermanentGraphImpl.newInstance(sortedCommits, (GraphColorManager)new GraphColorManager<Hash>(){

            public int getColorOfBranch(@NotNull Hash headCommit) {
                return 0;
            }

            public int getColorOfFragment(@NotNull Hash headCommit, int magicIndex) {
                return 0;
            }

            public int compareHeads(@NotNull Hash head1, @NotNull Hash head2) {
                if (!refs.contains(head1) || !refs.contains(head2)) {
                    LOG.error("GitLogProvider returned inconsistent data", new Attachment[]{new Attachment("error-details.txt", GitLogProvider.printErrorDetails(root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags))});
                }
                return 0;
            }
        }, (Set)refs);
        sw.report();
    }

    private static String printErrorDetails(@NotNull VirtualFile root, @NotNull Set<? extends VcsRef> allRefs, @NotNull List<? extends VcsCommitMetadata> sortedCommits, @NotNull VcsLogProvider.DetailedLogData firstBlockSyncData, @NotNull Set<? extends VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + root.getName() + "]\n");
        sb.append("First block data from Git:\n");
        sb.append(GitLogProvider.printLogData(firstBlockSyncData));
        sb.append("\n\nManually read refs:\n");
        sb.append(GitLogProvider.printRefs(manuallyReadBranches));
        sb.append("\n\nCurrent tag names:\n");
        if (currentTagNames != null) {
            sb.append(StringUtil.join(currentTagNames, (String)", "));
            if (commitsFromTags != null) {
                sb.append(GitLogProvider.printLogData(commitsFromTags));
            } else {
                sb.append("\n\nCommits from new tags were not read.\n");
            }
        } else {
            sb.append("\n\nCurrent tags were not read\n");
        }
        sb.append("\n\nResult:\n");
        sb.append("\nCommits (last 100): \n");
        sb.append(GitLogProvider.printCommits(sortedCommits));
        sb.append("\nAll refs:\n");
        sb.append(GitLogProvider.printRefs(allRefs));
        return sb.toString();
    }

    @NotNull
    private static String printLogData(@NotNull VcsLogProvider.DetailedLogData firstBlockSyncData) {
        return String.format("Last 100 commits:\n%s\nRefs:\n%s", GitLogProvider.printCommits(firstBlockSyncData.getCommits()), GitLogProvider.printRefs(firstBlockSyncData.getRefs()));
    }

    @NotNull
    private static String printCommits(@NotNull List<? extends VcsCommitMetadata> commits2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(commits2.size(), 100); ++i) {
            GraphCommit commit2 = (GraphCommit)commits2.get(i);
            sb.append(String.format("%s -> %s\n", ((Hash)commit2.getId()).toShortString(), StringUtil.join((Collection)commit2.getParents(), Hash::toShortString, (String)", ")));
        }
        return sb.toString();
    }

    @NotNull
    private static String printRefs(@NotNull Set<? extends VcsRef> refs) {
        return StringUtil.join(refs, ref -> ref.getCommitHash().toShortString() + " : " + ref.getName(), (String)"\n");
    }

    private static void addOldStillExistingTags(@NotNull Set<? super VcsRef> allRefs, @NotNull Set<String> currentTags, @NotNull Collection<? extends VcsRef> previousRefs) {
        for (VcsRef vcsRef : previousRefs) {
            if (allRefs.contains(vcsRef) || !currentTags.contains(vcsRef.getName())) continue;
            allRefs.add((VcsRef)vcsRef);
        }
    }

    @NotNull
    private Set<String> readCurrentTagNames(@NotNull VirtualFile root) throws VcsException {
        StopWatch sw = StopWatch.start((String)("reading tags in " + root.getName()));
        Set<String> tags = GitLogProvider.newHashSet();
        tags.addAll(GitBranchUtil.getAllTags(this.myProject, root));
        sw.report();
        return tags;
    }

    @NotNull
    private static <T> Set<T> remove(@NotNull Set<? extends T> original, Set<T> ... toRemove) {
        Set<T> result2 = GitLogProvider.newHashSet(original);
        for (Set<T> set : toRemove) {
            result2.removeAll(set);
        }
        return result2;
    }

    private static <T> void addNewElements(@NotNull Collection<? super T> original, @NotNull Collection<? extends T> toAdd) {
        for (T item : toAdd) {
            if (original.contains(item)) continue;
            original.add(item);
        }
    }

    @NotNull
    private VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(@NotNull VirtualFile root, int commitCount, @NotNull Collection<String> unmatchedTags) throws VcsException {
        StopWatch sw = StopWatch.start((String)("loading commits on tagged branch in " + root.getName()));
        ArrayList<String> params = new ArrayList<String>();
        params.add("--max-count=" + commitCount);
        HashSet refs = ContainerUtil.newHashSet();
        HashSet commits2 = ContainerUtil.newHashSet();
        VcsFileUtil.foreachChunk(new ArrayList<String>(unmatchedTags), (int)1, tagsChunk -> {
            String[] parameters = ArrayUtil.toStringArray((Collection)ContainerUtil.concat((List)params, (List)tagsChunk));
            VcsLogProvider.DetailedLogData logData = GitLogUtil.collectMetadata(this.myProject, root, false, parameters);
            refs.addAll(logData.getRefs());
            commits2.addAll(logData.getCommits());
        });
        sw.report();
        return new LogDataImpl((Set)refs, (List)ContainerUtil.newArrayList((Iterable)commits2));
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (!this.isRepositoryReady(root)) {
            return LogDataImpl.empty();
        }
        ArrayList<String> parameters = new ArrayList<String>(GitLogUtil.LOG_ALL);
        parameters.add("--date-order");
        GitBekParentFixer parentFixer = GitBekParentFixer.prepare(this.myProject, root);
        Set userRegistry = GitLogProvider.newHashSet();
        Set refs = GitLogProvider.newHashSet();
        GitLogUtil.readTimedCommits(this.myProject, root, parameters, (Consumer<? super VcsUser>)new CollectConsumer(userRegistry), (Consumer<? super VcsRef>)new CollectConsumer(refs), (Consumer<? super TimedVcsCommit>)((Consumer)commit2 -> commitConsumer.consume((Object)parentFixer.fixCommit((TimedVcsCommit)commit2))));
        return new LogDataImpl(refs, userRegistry);
    }

    public void readAllFullDetails(@NotNull VirtualFile root, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (!this.isRepositoryReady(root)) {
            return;
        }
        GitLogUtil.readFullDetails(this.myProject, root, commitConsumer, this.shouldIncludeRootChanges(root), false, true, ArrayUtil.toStringArray(GitLogUtil.LOG_ALL));
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (!this.isRepositoryReady(root)) {
            return;
        }
        GitLogUtil.readFullDetailsForHashes(this.myProject, root, this.myVcs, commitConsumer, hashes2, this.shouldIncludeRootChanges(root), false, GitLogUtil.DiffRenameLimit.GIT_CONFIG);
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer, boolean isForIndexing) throws VcsException {
        if (!this.isRepositoryReady(root)) {
            return;
        }
        GitLogUtil.readFullDetailsForHashes(this.myProject, root, this.myVcs, commitConsumer, hashes2, this.shouldIncludeRootChanges(root), isForIndexing, isForIndexing ? GitLogUtil.DiffRenameLimit.REGISTRY : GitLogUtil.DiffRenameLimit.INFINITY);
    }

    private boolean shouldIncludeRootChanges(@NotNull VirtualFile root) {
        GitRepository repository = this.getRepository(root);
        if (repository == null) {
            return true;
        }
        return !repository.getInfo().isShallow();
    }

    @NotNull
    public List<? extends VcsCommitMetadata> readMetadata(@NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        return GitLogUtil.collectShortDetails(this.myProject, this.myVcs, root, hashes2);
    }

    @NotNull
    private Set<VcsRef> readBranches(@NotNull GitRepository repository) {
        Hash hash;
        StopWatch sw = StopWatch.start((String)("readBranches in " + repository.getRoot().getName()));
        VirtualFile root = repository.getRoot();
        repository.update();
        GitBranchesCollection branches2 = repository.getBranches();
        Collection<GitLocalBranch> localBranches = branches2.getLocalBranches();
        Collection<GitRemoteBranch> remoteBranches = branches2.getRemoteBranches();
        THashSet refs = new THashSet(localBranches.size() + remoteBranches.size());
        for (GitLocalBranch localBranch : localBranches) {
            hash = branches2.getHash(localBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
        }
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            hash = branches2.getHash(remoteBranch);
            assert (hash != null);
            refs.add(this.myVcsObjectsFactory.createRef(hash, remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
        }
        sw.report();
        return refs;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        return this.myRefSorter;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> roots, @NotNull VcsLogRefresher refresher) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(GitRepository.GIT_REPO_CHANGE, repository -> {
            VirtualFile root = repository.getRoot();
            if (roots.contains(root)) {
                refresher.refresh(root);
            }
        });
        return connection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Collection files;
        VcsLogStructureFilter structureFilter;
        VcsLogTextFilter textFilter;
        if (!this.isRepositoryReady(root)) {
            return Collections.emptyList();
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER);
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filterCollection.get(VcsLogFilterCollection.REVISION_FILTER);
        if (branchFilter != null || revisionFilter != null) {
            boolean atLeastOneBranchExists = false;
            if (branchFilter != null) {
                GitRepository repository = this.getRepository(root);
                assert (repository != null) : "repository is null for root " + root + " but was previously reported as 'ready'";
                ArrayList branches2 = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{repository.getBranches().getLocalBranches(), repository.getBranches().getRemoteBranches()}));
                Collection<String> branchNames = GitBranchUtil.convertBranchesToNames(branches2);
                List predefinedNames = ContainerUtil.list((Object[])new String[]{"HEAD"});
                for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, predefinedNames})) {
                    if (!branchFilter.matches(branchName)) continue;
                    filterParameters.add(branchName);
                    atLeastOneBranchExists = true;
                }
            }
            if (revisionFilter != null) {
                for (CommitId commit2 : revisionFilter.getHeads()) {
                    if (!commit2.getRoot().equals(root)) continue;
                    filterParameters.add(commit2.getHash().asString());
                    atLeastOneBranchExists = true;
                }
            }
            if (!atLeastOneBranchExists) {
                return Collections.emptyList();
            }
        } else {
            filterParameters.addAll(GitLogUtil.LOG_ALL);
        }
        VcsLogDateFilter dateFilter = (VcsLogDateFilter)filterCollection.get(VcsLogFilterCollection.DATE_FILTER);
        if (dateFilter != null) {
            if (dateFilter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", dateFilter.getAfter().toString()));
            }
            if (dateFilter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", dateFilter.getBefore().toString()));
            }
        }
        String text = (textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER)) != null ? textFilter.getText() : null;
        boolean regexp = textFilter == null || textFilter.isRegex();
        boolean caseSensitive = textFilter != null && textFilter.matchesCase();
        GitLogProvider.appendTextFilterParameters(text, regexp, caseSensitive, filterParameters);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER);
        if (userFilter != null) {
            List names = ContainerUtil.map((Collection)userFilter.getUsers(root), VcsUserUtil::toExactString);
            if (regexp) {
                List authors = ContainerUtil.map((Collection)names, (Function)UserNameRegex.EXTENDED_INSTANCE);
                if (GitVersionSpecialty.LOG_AUTHOR_FILTER_SUPPORTS_VERTICAL_BAR.existsIn(this.myVcs.getVersion())) {
                    filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.join((Collection)authors, (String)"|")));
                } else {
                    filterParameters.addAll(ContainerUtil.map((Collection)authors, a -> GitLogProvider.prepareParameter("author", a)));
                }
            } else {
                filterParameters.addAll(ContainerUtil.map((Collection)names, a -> GitLogProvider.prepareParameter("author", StringUtil.escapeBackSlashes((String)a))));
            }
        }
        if (maxCount > 0) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null && !(files = structureFilter.getFiles()).isEmpty()) {
            filterParameters.add("--full-history");
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (FilePath file : files) {
                filterParameters.add(VcsFileUtil.relativePath((VirtualFile)root, (FilePath)file));
            }
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        GitLogUtil.readTimedCommits(this.myProject, root, filterParameters, (Consumer<? super VcsUser>)EmptyConsumer.getInstance(), (Consumer<? super VcsRef>)EmptyConsumer.getInstance(), (Consumer<? super TimedVcsCommit>)new CollectConsumer((Collection)commits2));
        return commits2;
    }

    public static void appendTextFilterParameters(@Nullable String text, boolean regexp, boolean caseSensitive, @NotNull List<? super String> filterParameters) {
        if (text != null) {
            filterParameters.add(GitLogProvider.prepareParameter("grep", text));
        }
        filterParameters.add(regexp ? "--extended-regexp" : "--fixed-strings");
        if (!caseSensitive) {
            filterParameters.add("--regexp-ignore-case");
        }
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) {
        return this.myUserRegistry.getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        return GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            return null;
        }
        String currentBranchName = repository.getCurrentBranchName();
        if (currentBranchName == null && repository.getCurrentRevision() != null) {
            return "HEAD";
        }
        return currentBranchName;
    }

    @Nullable
    public VcsLogDiffHandler getDiffHandler() {
        return new GitLogDiffHandler(this.myProject);
    }

    @Nullable
    public VirtualFile getVcsRoot(@NotNull Project project, @NotNull VirtualFile detectedRoot, @NotNull FilePath path) {
        GitSubmodule submodule;
        GitRepository repository;
        if (detectedRoot.equals(path.getVirtualFile()) && (repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(detectedRoot)) != null && (submodule = GitSubmoduleKt.asSubmodule(repository)) != null) {
            return submodule.getParent().getRoot();
        }
        return detectedRoot;
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.LIGHTWEIGHT_BRANCHES) {
            return (T)Boolean.TRUE;
        }
        if (property == VcsLogProperties.SUPPORTS_INDEXING) {
            return (T)Boolean.valueOf(GitLogProvider.isIndexingOn());
        }
        return null;
    }

    public static boolean isIndexingOn() {
        return Registry.is((String)"vcs.log.index.git");
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VirtualFile root) {
        return (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
    }

    private boolean isRepositoryReady(@NotNull VirtualFile root) {
        GitRepository repository = this.getRepository(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return false;
        }
        if (repository.isFresh()) {
            LOG.info("Fresh repository: " + root);
            return false;
        }
        return true;
    }

    @NotNull
    private static <T> Set<T> newHashSet() {
        return new THashSet();
    }

    @NotNull
    private static <T> Set<T> newHashSet(@NotNull Collection<? extends T> initialCollection) {
        return new THashSet(initialCollection);
    }
}

