/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SimpleRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchType;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRefManager
implements VcsLogRefManager {
    private static final JBColor HEAD_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.headIconColor", (Color)VcsLogStandardColors.Refs.TIP);
    private static final JBColor LOCAL_BRANCH_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.localBranchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH);
    private static final JBColor REMOTE_BRANCH_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.remoteBranchIconColor", (Color)VcsLogStandardColors.Refs.BRANCH_REF);
    private static final JBColor TAG_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.tagIconColor", (Color)VcsLogStandardColors.Refs.TAG);
    private static final JBColor OTHER_COLOR = JBColor.namedColor((String)"VersionControl.GitLog.otherIconColor", (Color)VcsLogStandardColors.Refs.TAG);
    public static final VcsRefType HEAD = new SimpleRefType("HEAD", true, (Color)HEAD_COLOR);
    public static final VcsRefType LOCAL_BRANCH = new SimpleRefType("LOCAL_BRANCH", true, (Color)LOCAL_BRANCH_COLOR);
    public static final VcsRefType REMOTE_BRANCH = new SimpleRefType("REMOTE_BRANCH", true, (Color)REMOTE_BRANCH_COLOR);
    public static final VcsRefType TAG = new SimpleRefType("TAG", false, (Color)TAG_COLOR);
    public static final VcsRefType OTHER = new SimpleRefType("OTHER", false, (Color)OTHER_COLOR);
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(HEAD, LOCAL_BRANCH, REMOTE_BRANCH, TAG, OTHER);
    public static final String MASTER = "master";
    public static final String ORIGIN_MASTER = "origin/master";
    private static final Logger LOG = Logger.getInstance(GitRefManager.class);
    private static final String REMOTE_TABLE_SEPARATOR = " & ";
    private static final String SEPARATOR = "/";
    @NotNull
    private final RepositoryManager<GitRepository> myRepositoryManager;
    @NotNull
    private final Comparator<VcsRef> myLabelsComparator;
    @NotNull
    private final Comparator<VcsRef> myBranchLayoutComparator;
    @NotNull
    private final GitBranchManager myBranchManager;

    public GitRefManager(@NotNull Project project, @NotNull RepositoryManager<GitRepository> repositoryManager) {
        this.myRepositoryManager = repositoryManager;
        this.myBranchLayoutComparator = new GitBranchLayoutComparator(repositoryManager);
        this.myLabelsComparator = new GitLabelComparator(repositoryManager);
        this.myBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
    }

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        return this.myLabelsComparator;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        return this.myBranchLayoutComparator;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<? extends VcsRef> refs) {
        ArrayList simpleGroups = ContainerUtil.newArrayList();
        ArrayList localBranches = ContainerUtil.newArrayList();
        MultiMap remoteRefGroups = MultiMap.create();
        MultiMap<VirtualFile, VcsRef> refsByRoot = GitRefManager.groupRefsByRoot(refs);
        for (Map.Entry entry : refsByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List refsInRoot = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), this.myLabelsComparator);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set<String> locals = GitRefManager.getLocalBranches(repository);
            Map<String, GitRemote> allRemote = GitRefManager.getAllRemoteBranches(repository);
            for (VcsRef ref : refsInRoot) {
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                String refName = ref.getName();
                if (locals.contains(refName)) {
                    localBranches.add(ref);
                    continue;
                }
                if (allRemote.containsKey(refName)) {
                    remoteRefGroups.putValue((Object)allRemote.get(refName), (Object)ref);
                    continue;
                }
                LOG.debug("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(simpleGroups);
        if (!localBranches.isEmpty()) {
            result2.add(new SimpleRefGroup("Local", (List)localBranches, false));
        }
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            result2.add(new RemoteRefGroup((GitRemote)entry.getKey(), (Collection)entry.getValue()));
        }
        return result2;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<? extends VcsRef> references, boolean compact, boolean showTagNames) {
        GitRepository repository;
        List sortedReferences = ContainerUtil.sorted(references, this.myLabelsComparator);
        MultiMap groupedRefs = ContainerUtil.groupBy((Iterable)sortedReferences, VcsRef::getType);
        ArrayList result2 = ContainerUtil.newArrayList();
        if (groupedRefs.isEmpty()) {
            return result2;
        }
        VcsRef head = null;
        Map.Entry firstGroup = (Map.Entry)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)groupedRefs.entrySet()));
        if (((VcsRefType)firstGroup.getKey()).equals(HEAD)) {
            head = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)((Collection)firstGroup.getValue())));
            groupedRefs.remove((Object)HEAD, (Object)head);
        }
        if ((repository = this.getRepository(references)) != null) {
            result2.addAll(GitRefManager.getTrackedRefs((MultiMap<VcsRefType, VcsRef>)groupedRefs, repository));
        }
        result2.forEach(refGroup -> {
            groupedRefs.remove((Object)LOCAL_BRANCH, refGroup.getRefs().get(0));
            groupedRefs.remove((Object)REMOTE_BRANCH, refGroup.getRefs().get(1));
        });
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, (List)result2);
        if (head != null) {
            if (repository != null && !repository.isOnBranch()) {
                result2.add(0, new SimpleRefGroup("!", Collections.singletonList(head)));
            } else if (!result2.isEmpty()) {
                RefGroup first = (RefGroup)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((List)result2));
                first.getRefs().add(0, head);
            } else {
                result2.add(0, new SimpleRefGroup("", Collections.singletonList(head)));
            }
        }
        return result2;
    }

    @NotNull
    private static List<RefGroup> getTrackedRefs(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, @NotNull GitRepository repository) {
        ArrayList result2 = ContainerUtil.newArrayList();
        Collection locals = groupedRefs.get((Object)LOCAL_BRANCH);
        Collection remotes = groupedRefs.get((Object)REMOTE_BRANCH);
        for (VcsRef localRef : locals) {
            SimpleRefGroup group = GitRefManager.createTrackedGroup(repository, remotes, localRef);
            if (group == null) continue;
            result2.add(group);
        }
        return result2;
    }

    @Nullable
    private static SimpleRefGroup createTrackedGroup(@NotNull GitRepository repository, @NotNull Collection<? extends VcsRef> references, @NotNull VcsRef localRef) {
        VcsRef trackedRef;
        List remoteBranches = ContainerUtil.filter(references, ref -> ref.getType().equals(REMOTE_BRANCH));
        GitBranchTrackInfo trackInfo = (GitBranchTrackInfo)ContainerUtil.find(repository.getBranchTrackInfos(), info -> info.getLocalBranch().getName().equals(localRef.getName()));
        if (trackInfo != null && (trackedRef = (VcsRef)ContainerUtil.find((Iterable)remoteBranches, ref -> ref.getName().equals(trackInfo.getRemoteBranch().getName()))) != null) {
            return new SimpleRefGroup(trackInfo.getRemote().getName() + REMOTE_TABLE_SEPARATOR + localRef.getName(), (List)ContainerUtil.newArrayList((Object[])new VcsRef[]{localRef, trackedRef}));
        }
        List trackingCandidates = ContainerUtil.filter((Collection)remoteBranches, ref -> ref.getName().endsWith(SEPARATOR + localRef.getName()));
        for (GitRemote remote : repository.getRemotes()) {
            for (VcsRef candidate : trackingCandidates) {
                if (!candidate.getName().equals(remote.getName() + SEPARATOR + localRef.getName())) continue;
                return new SimpleRefGroup(remote.getName() + REMOTE_TABLE_SEPARATOR + localRef.getName(), (List)ContainerUtil.newArrayList((Object[])new VcsRef[]{localRef, candidate}));
            }
        }
        return null;
    }

    @Nullable
    private GitRepository getRepository(@NotNull Collection<? extends VcsRef> references) {
        if (references.isEmpty()) {
            return null;
        }
        VcsRef ref = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references));
        GitRepository repository = this.getRepository(ref);
        if (repository == null) {
            LOG.warn("No repository for root: " + ref.getRoot());
        }
        return repository;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        int id = in.readInt();
        if (id < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        return REF_TYPE_INDEX.get(id);
    }

    @NotNull
    private static GitBranchType getBranchType(@NotNull VcsRef reference) {
        return reference.getType().equals(LOCAL_BRANCH) ? GitBranchType.LOCAL : GitBranchType.REMOTE;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VcsRef reference) {
        return (GitRepository)this.myRepositoryManager.getRepositoryForRoot(reference.getRoot());
    }

    public boolean isFavorite(@NotNull VcsRef reference) {
        if (reference.getType().equals(HEAD)) {
            return true;
        }
        if (!reference.getType().isBranch()) {
            return false;
        }
        return this.myBranchManager.isFavorite(GitRefManager.getBranchType(reference), this.getRepository(reference), reference.getName());
    }

    public void setFavorite(@NotNull VcsRef reference, boolean favorite) {
        if (reference.getType().equals(HEAD)) {
            return;
        }
        if (!reference.getType().isBranch()) {
            return;
        }
        this.myBranchManager.setFavorite(GitRefManager.getBranchType(reference), this.getRepository(reference), reference.getName(), favorite);
    }

    private static Set<String> getLocalBranches(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranches().getLocalBranches(), branch -> branch.getName());
    }

    @NotNull
    private static Map<String, GitRemote> getAllRemoteBranches(@NotNull GitRepository repository) {
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashMap allRemote = ContainerUtil.newHashMap();
        for (GitRemoteBranch remoteBranch : all) {
            allRemote.put(remoteBranch.getName(), remoteBranch.getRemote());
        }
        return allRemote;
    }

    @NotNull
    private static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Iterable<? extends VcsRef> refs) {
        MultiMap grouped = MultiMap.create();
        for (VcsRef vcsRef : refs) {
            grouped.putValue((Object)vcsRef.getRoot(), (Object)vcsRef);
        }
        return grouped;
    }

    @NotNull
    public static VcsRefType getRefType(@NotNull String refName) {
        if (refName.startsWith("refs/heads/")) {
            return LOCAL_BRANCH;
        }
        if (refName.startsWith("refs/remotes/")) {
            return REMOTE_BRANCH;
        }
        if (refName.startsWith("refs/tags/")) {
            return TAG;
        }
        if (refName.startsWith("HEAD")) {
            return HEAD;
        }
        return OTHER;
    }

    private static abstract class GitRefComparator
    implements Comparator<VcsRef> {
        @NotNull
        private final RepositoryManager<GitRepository> myRepositoryManager;

        GitRefComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            this.myRepositoryManager = repositoryManager;
        }

        @Override
        public int compare(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            int power2;
            int power1 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref1)));
            if (power1 != (power2 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref2))))) {
                return power1 - power2;
            }
            int namesComparison = ref1.getName().compareTo(ref2.getName());
            if (namesComparison != 0) {
                return namesComparison;
            }
            return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }

        protected abstract RefType[] getOrderedTypes();

        @NotNull
        private RefType getType(@NotNull VcsRef ref) {
            VcsRefType type = ref.getType();
            if (type == HEAD) {
                return RefType.HEAD;
            }
            if (type == TAG) {
                return RefType.TAG;
            }
            if (type == LOCAL_BRANCH) {
                if (ref.getName().equals(GitRefManager.MASTER)) {
                    return RefType.MASTER;
                }
                return this.isTracked(ref, false) ? RefType.TRACKING_LOCAL_BRANCH : RefType.NON_TRACKING_LOCAL_BRANCH;
            }
            if (type == REMOTE_BRANCH) {
                if (ref.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                    return RefType.ORIGIN_MASTER;
                }
                return this.isTracked(ref, true) ? RefType.TRACKED_REMOTE_BRANCH : RefType.NON_TRACKED_REMOTE_BRANCH;
            }
            return RefType.OTHER;
        }

        private boolean isTracked(@NotNull VcsRef ref, boolean remoteBranch) {
            GitRepository repo = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(ref.getRoot());
            if (repo == null) {
                LOG.error("Undefined root " + ref.getRoot());
                return false;
            }
            return ContainerUtil.exists(repo.getBranchTrackInfos(), info -> remoteBranch ? info.getRemoteBranch().getNameForLocalOperations().equals(ref.getName()) : info.getLocalBranch().getName().equals(ref.getName()));
        }
    }

    private static class GitBranchLayoutComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.HEAD, RefType.OTHER};

        GitBranchLayoutComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private static class GitLabelComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.HEAD, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.OTHER};

        GitLabelComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private class RemoteRefGroup
    implements RefGroup {
        private final GitRemote myRemote;
        private final Collection<? extends VcsRef> myBranches;

        RemoteRefGroup(GitRemote remote, Collection<? extends VcsRef> branches2) {
            this.myRemote = remote;
            this.myBranches = branches2;
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public String getName() {
            return this.myRemote.getName() + "/...";
        }

        @NotNull
        public List<VcsRef> getRefs() {
            return ContainerUtil.sorted(this.myBranches, GitRefManager.this.getLabelsOrderComparator());
        }

        @NotNull
        public List<Color> getColors() {
            return Collections.singletonList(VcsLogStandardColors.Refs.BRANCH_REF);
        }
    }

    protected static enum RefType {
        OTHER,
        HEAD,
        TAG,
        NON_TRACKING_LOCAL_BRANCH,
        NON_TRACKED_REMOTE_BRANCH,
        TRACKING_LOCAL_BRANCH,
        MASTER,
        TRACKED_REMOTE_BRANCH,
        ORIGIN_MASTER;

    }
}

