/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowCommitInLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GitShowCommitInLogAction.class);

    public GitShowCommitInLogAction() {
        super(GitBundle.getString("vcs.history.action.gitlog"));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        VcsRevisionNumber revision = this.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        VcsLogContentUtil.openMainLogAndExecute((Project)project, logUi -> GitShowCommitInLogAction.jumpToRevisionUnderProgress(project, logUi, revision));
    }

    @Nullable
    protected VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        VcsRevisionNumber revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revision == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    @Nullable
    protected VcsKey getVcsKey(@NotNull AnActionEvent event) {
        return (VcsKey)event.getData(VcsDataKeys.VCS);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && VcsProjectLog.getInstance((Project)project) != null && this.getRevisionNumber(e) != null && Comparing.equal((Object)this.getVcsKey(e), (Object)GitVcs.getKey()));
    }

    private static void jumpToRevisionUnderProgress(@NotNull Project project, @NotNull VcsLogUiImpl logUi, @NotNull VcsRevisionNumber revision) {
        final Future future2 = logUi.getVcsLog().jumpToReference(revision.asString());
        if (!future2.isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Searching for revision " + revision.asString(), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        future2.get();
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }
}

