/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    @NotNull
    private final Collection<VirtualFile> myRoots;
    @NotNull
    private final Params myParams;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final AbstractVcsHelper myVcsHelper;
    @NotNull
    private final GitVcs myVcs;

    public GitConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> roots, @NotNull Params params) {
        this.myProject = project;
        this.myGit = git;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(this.myProject);
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    protected boolean proceedAfterAllMerged() throws VcsException {
        return true;
    }

    public final boolean mergeNoProceed() {
        return this.merge(true);
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, "Unresolved conflicts remaining in the project." + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning("Unresolved Conflicts Remaining", this.myParams.myErrorNotificationAdditionalDescription);
    }

    protected void notifyWarning(String title, String content) {
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, content, NotificationType.WARNING, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Resolve...", () -> {
            notification.expire();
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> this.mergeNoProceed());
        }));
        VcsNotifier.getInstance((Project)this.myProject).notify(notification);
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        try {
            Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
            if (initiallyUnmergedFiles.isEmpty()) {
                LOG.info("merge: no unmerged files");
                return mergeDialogInvokedFromNotification ? true : this.proceedIfNothingToMerge();
            }
            this.showMergeDialog(initiallyUnmergedFiles);
            Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
            if (unmergedFilesAfterResolve.isEmpty()) {
                LOG.info("merge no more unmerged files");
                return mergeDialogInvokedFromNotification ? true : this.proceedAfterAllMerged();
            }
            LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
            if (mergeDialogInvokedFromNotification) {
                this.notifyUnresolvedRemainAfterNotification();
            } else {
                this.notifyUnresolvedRemain();
            }
        }
        catch (VcsException e) {
            this.notifyException(e);
        }
        return false;
    }

    private void showMergeDialog(@NotNull Collection<VirtualFile> initiallyUnmergedFiles) {
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitMergeProvider mergeProvider = new GitMergeProvider(this.myProject, this.myParams.reverse);
            this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, this.myParams.myMergeDialogCustomizer);
        });
    }

    private void notifyException(VcsException e) {
        LOG.info("mergeFiles ", (Throwable)e);
        String description = "Couldn't check the working tree for unmerged files because of an error.";
        VcsNotifier.getInstance((Project)this.myProject).notifyError(this.myParams.myErrorNotificationTitle, "Couldn't check the working tree for unmerged files because of an error." + this.myParams.myErrorNotificationAdditionalDescription + "<br/>" + e.getLocalizedMessage());
    }

    private Collection<VirtualFile> getUnmergedFiles(@NotNull Collection<VirtualFile> roots) throws VcsException {
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(root));
        }
        return unmergedFiles;
    }

    private Collection<VirtualFile> getUnmergedFiles(@NotNull VirtualFile root) throws VcsException {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptyList();
        }
        List<File> files = GitChangeUtils.getUnmergedFiles(repository);
        return DvcsUtil.sortVirtualFilesByPresentation((Collection)DvcsUtil.findVirtualFilesWithRefresh(files));
    }

    public static class Params {
        private boolean reverse;
        private String myErrorNotificationTitle = "";
        private String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer;

        public Params() {
            this.myMergeDialogCustomizer = new MergeDialogCustomizer(){

                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    return myMergeDescription;
                }
            };
        }

        public Params(Project project) {
            GitMergeProvider provider = (GitMergeProvider)GitVcs.getInstance(project).getMergeProvider();
            this.myMergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(provider){

                @Override
                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    if (!StringUtil.isEmpty((String)myMergeDescription)) {
                        return myMergeDescription;
                    }
                    return super.getMultipleFileMergeDescription(files);
                }
            };
        }

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

