/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeUtil {
    private static final Logger LOG = Logger.getInstance(GitMergeUtil.class);
    static final int ORIGINAL_REVISION_NUM = 1;
    static final int YOURS_REVISION_NUM = 2;
    static final int THEIRS_REVISION_NUM = 3;
    public static final String DEFAULT_STRATEGY = GitBundle.getString("merge.default.strategy");

    private GitMergeUtil() {
    }

    @NonNls
    public static String[] getMergeStrategies(int branchCount) {
        if (branchCount < 0) {
            throw new IllegalArgumentException("Branch count must be non-negative: " + branchCount);
        }
        switch (branchCount) {
            case 0: {
                return new String[]{DEFAULT_STRATEGY};
            }
            case 1: {
                return new String[]{DEFAULT_STRATEGY, "resolve", "recursive", "octopus", "ours", "subtree"};
            }
        }
        return new String[]{DEFAULT_STRATEGY, "octopus", "ours"};
    }

    public static void setupStrategies(final ElementsChooser<String> branchChooser, final JComboBox strategy) {
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            private void updateStrategies(List<String> elements) {
                strategy.removeAllItems();
                for (String s : GitMergeUtil.getMergeStrategies(elements.size())) {
                    strategy.addItem(s);
                }
                strategy.setSelectedItem(DEFAULT_STRATEGY);
            }

            public void elementMarkChanged(String element, boolean isMarked) {
                List elements = branchChooser.getMarkedElements();
                if (elements.size() == 0) {
                    strategy.setEnabled(false);
                    this.updateStrategies(elements);
                } else {
                    strategy.setEnabled(true);
                    this.updateStrategies(elements);
                }
            }
        };
        listener.elementMarkChanged(null, true);
        branchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
    }

    public static void showUpdates(Project project, List<VcsException> exceptions, VirtualFile root, GitRevisionNumber currentRev, Label beforeLabel, String actionName, ActionInfo actionInfo) {
        UpdatedFiles files = UpdatedFiles.create();
        MergeChangeCollector collector = new MergeChangeCollector(project, root, currentRev);
        collector.collect(files, exceptions);
        if (!exceptions.isEmpty()) {
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            ProjectLevelVcsManagerEx manager = (ProjectLevelVcsManagerEx)ProjectLevelVcsManager.getInstance((Project)project);
            UpdateInfoTree tree = manager.showUpdateProjectInfo(files, actionName, actionInfo, false);
            if (tree != null) {
                tree.setBefore(beforeLabel);
                tree.setAfter(LocalHistory.getInstance().putSystemLabel(project, "After update"));
                ViewUpdateInfoNotification.focusUpdateInfoTree((Project)project, (UpdateInfoTree)tree);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
        Collection unmergedNames = files.getGroupById("MERGED_WITH_CONFLICTS").getFiles();
        if (!unmergedNames.isEmpty()) {
            List unmerged = ContainerUtil.mapNotNull((Collection)unmergedNames, name -> LocalFileSystem.getInstance().findFileByPath(name));
            GuiUtils.invokeLaterIfNeeded(() -> AbstractVcsHelper.getInstance((Project)project).showMergeDialog(unmerged, GitVcs.getInstance(project).getMergeProvider()), (ModalityState)ModalityState.defaultModalityState());
        }
    }

    public static MergeData loadMergeData(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, boolean isReversed) throws VcsException {
        byte[] originalContent = GitMergeUtil.loadOriginalContent(project, root, path);
        byte[] yoursContent = GitMergeUtil.loadRevisionCatchingErrors(project, root, path, 2);
        byte[] theirsContent = GitMergeUtil.loadRevisionCatchingErrors(project, root, path, 3);
        GitRevisionNumber yoursRevision = GitMergeUtil.resolveHead(project, root);
        GitRevisionNumber theirsRevision = GitMergeUtil.resolveMergeHead(project, root);
        GitRevisionNumber originalRevision = GitMergeUtil.findOriginalRevisionNumber(project, root, (VcsRevisionNumber)yoursRevision, (VcsRevisionNumber)theirsRevision);
        Trinity<String, String, String> blobs = GitMergeUtil.getAffectedBlobs(project, root, path);
        FilePath originalPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getFirst(), (VcsRevisionNumber)originalRevision);
        FilePath yoursPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getSecond(), (VcsRevisionNumber)yoursRevision);
        FilePath theirsPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getThird(), (VcsRevisionNumber)theirsRevision);
        MergeData mergeData = new MergeData();
        mergeData.ORIGINAL = originalContent;
        mergeData.CURRENT = !isReversed ? yoursContent : theirsContent;
        mergeData.LAST = isReversed ? yoursContent : theirsContent;
        mergeData.ORIGINAL_REVISION_NUMBER = originalRevision;
        mergeData.CURRENT_REVISION_NUMBER = !isReversed ? yoursRevision : theirsRevision;
        mergeData.LAST_REVISION_NUMBER = isReversed ? yoursRevision : theirsRevision;
        mergeData.ORIGINAL_FILE_PATH = originalPath;
        mergeData.CURRENT_FILE_PATH = !isReversed ? yoursPath : theirsPath;
        mergeData.LAST_FILE_PATH = isReversed ? yoursPath : theirsPath;
        return mergeData;
    }

    @Nullable
    private static GitRevisionNumber findOriginalRevisionNumber(@NotNull Project project, @NotNull VirtualFile root, @Nullable VcsRevisionNumber yoursRevision, @Nullable VcsRevisionNumber theirsRevision) {
        if (yoursRevision == null || theirsRevision == null) {
            return null;
        }
        try {
            return GitHistoryUtils.getMergeBase(project, root, yoursRevision.asString(), theirsRevision.asString());
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber resolveMergeHead(@NotNull Project project, @NotNull VirtualFile root) {
        try {
            return GitRevisionNumber.resolve(project, root, "MERGE_HEAD");
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve the MERGE_HEAD in " + root + ": " + e.getMessage());
            try {
                return GitRevisionNumber.resolve(project, root, "CHERRY_PICK_HEAD");
            }
            catch (VcsException e2) {
                LOG.info("Couldn't resolve the CHERRY_PICK_HEAD in " + root + ": " + e2.getMessage());
                GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
                assert (repository != null);
                File rebaseApply = repository.getRepositoryFiles().getRebaseApplyDir();
                GitRevisionNumber rebaseRevision = GitMergeUtil.readRevisionFromFile(project, root, new File(rebaseApply, "original-commit"));
                if (rebaseRevision != null) {
                    return rebaseRevision;
                }
                File rebaseMerge = repository.getRepositoryFiles().getRebaseMergeDir();
                GitRevisionNumber mergeRevision = GitMergeUtil.readRevisionFromFile(project, root, new File(rebaseMerge, "stopped-sha"));
                if (mergeRevision != null) {
                    return mergeRevision;
                }
                return null;
            }
        }
    }

    @Nullable
    private static GitRevisionNumber readRevisionFromFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull File file) {
        if (!file.exists()) {
            return null;
        }
        String revision = DvcsUtil.tryLoadFileOrReturn((File)file, null, (String)"UTF-8");
        if (revision == null) {
            return null;
        }
        try {
            return GitRevisionNumber.resolve(project, root, revision);
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve revision  '" + revision + "' in " + root + ": " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber resolveHead(@NotNull Project project, @NotNull VirtualFile root) {
        try {
            return GitRevisionNumber.resolve(project, root, "HEAD");
        }
        catch (VcsException e) {
            LOG.error("Couldn't resolve the HEAD in " + root, (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static byte[] loadOriginalContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path) {
        try {
            return GitMergeUtil.loadRevisionContent(project, root, path, 1);
        }
        catch (Exception ex) {
            try {
                return (byte[])ReadAction.compute(() -> {
                    VirtualFile file = path.getVirtualFile();
                    if (file == null || !file.isValid()) {
                        LOG.debug("File not found: " + path);
                        return ArrayUtil.EMPTY_BYTE_ARRAY;
                    }
                    return file.contentsToByteArray();
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
        }
    }

    @NotNull
    private static byte[] loadRevisionCatchingErrors(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, int stageNum) throws VcsException {
        try {
            return GitMergeUtil.loadRevisionContent(project, root, path, stageNum);
        }
        catch (VcsException e) {
            String m = e.getMessage().trim();
            if (m.startsWith("fatal: ambiguous argument ") || m.startsWith("fatal: Path '") && m.contains("' exists on disk, but not in '") || m.contains("is in the index, but not at stage ") || m.contains("bad revision") || m.startsWith("fatal: Not a valid object name")) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            throw e;
        }
    }

    @NotNull
    private static byte[] loadRevisionContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, int stageNum) throws VcsException {
        return GitFileUtils.getFileContent(project, root, ":" + stageNum, VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
    }

    @NotNull
    private static Trinity<String, String, String> getAffectedBlobs(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path) {
        try {
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
            h.addParameters("--exclude-standard", "--unmerged", "-z");
            h.endOptions();
            h.addRelativePaths(path);
            String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
            StringScanner s = new StringScanner(output);
            String originalBlob = null;
            String yoursBlob = null;
            String theirsBlob = null;
            while (s.hasMoreData()) {
                s.spaceToken();
                String blob = s.spaceToken();
                int source = Integer.parseInt(s.tabToken());
                s.boundedToken('\u0000');
                if (source == 1) {
                    originalBlob = blob;
                    continue;
                }
                if (source == 2) {
                    yoursBlob = blob;
                    continue;
                }
                if (source == 3) {
                    theirsBlob = blob;
                    continue;
                }
                throw new IllegalStateException("Unknown revision " + source + " for the file: " + path);
            }
            return Trinity.create(originalBlob, yoursBlob, theirsBlob);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return Trinity.create(null, null, null);
        }
    }

    @Nullable
    private static FilePath getBlobPathInRevision(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable String blob, @Nullable VcsRevisionNumber revision) {
        if (blob == null || revision == null) {
            return null;
        }
        FilePath revisionPath = GitMergeUtil.doGetBlobPathInRevision(project, root, blob, revision, path);
        if (revisionPath != null) {
            return revisionPath;
        }
        return GitMergeUtil.doGetBlobPathInRevision(project, root, blob, revision, null);
    }

    @Nullable
    private static FilePath doGetBlobPathInRevision(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull String blob, @NotNull VcsRevisionNumber revision, @Nullable FilePath path) {
        final FilePath[] result2 = new FilePath[1];
        final boolean[] pathAmbiguous = new boolean[1];
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_TREE);
        h.addParameters(revision.asString());
        if (path != null) {
            h.endOptions();
            h.addRelativePaths(path);
        } else {
            h.addParameters("-r");
            h.endOptions();
        }
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (!line.contains(blob)) {
                    return;
                }
                if (pathAmbiguous[0]) {
                    return;
                }
                GitIndexUtil.StagedFileOrDirectory stagedFile = GitIndexUtil.parseListTreeRecord(root, line);
                if (stagedFile instanceof GitIndexUtil.StagedFile && blob.equals(((GitIndexUtil.StagedFile)stagedFile).getBlobHash())) {
                    if (result2[0] == null) {
                        result2[0] = stagedFile.getPath();
                    } else {
                        pathAmbiguous[0] = true;
                    }
                }
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h);
        if (pathAmbiguous[0]) {
            return null;
        }
        return result2[0];
    }
}

