/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushParams;
import git4idea.push.GitPushParamsImpl;
import git4idea.push.GitPushProcessCustomizationFactory;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    @NotNull
    private final GitPushSupport myPushSupport;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    @Nullable
    private final GitPushTagMode myTagMode;
    private final boolean myForce;
    private final boolean mySkipHook;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitRepositoryManager myRepositoryManager;
    @Nullable
    private final GitPushProcessCustomizationFactory.GitPushProcessCustomization myPushProcessCustomization;

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, boolean force, boolean skipHook) {
        this.myProject = project;
        this.myPushSupport = pushSupport;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForce = force;
        this.mySkipHook = skipHook;
        this.myGit = Git.getInstance();
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myRepositoryManager = GitRepositoryManager.getInstance(this.myProject);
        HashMap currentHeads = ContainerUtil.newHashMap();
        for (GitRepository repository : pushSpecs.keySet()) {
            repository.update();
            String head = repository.getCurrentRevision();
            if (head == null) {
                LOG.error("This repository has no commits");
                continue;
            }
            currentHeads.put(repository, new GitRevisionNumber(head));
        }
        this.myPushProcessCustomization = this.findPushCustomization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        Boolean rebaseOverMergeProblemDetected = null;
        HashMap results = ContainerUtil.newHashMap();
        HashMap updatedRoots = ContainerUtil.newHashMap();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(this.myRepositoryManager.sortByDependency(remainingRoots));
                results.putAll(resultMap);
                GroupedPushResult result2 = GroupedPushResult.group(resultMap);
                if (!result2.errors.isEmpty() || !result2.customRejected.isEmpty()) break;
                if (!result2.rejected.isEmpty()) {
                    boolean shouldUpdate = true;
                    if (this.myForce || GitPushOperation.pushingToNotTrackedBranch(result2.rejected)) {
                        shouldUpdate = false;
                    } else if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        rebaseOverMergeProblemDetected = !this.findRootsWithMergeCommits(this.getRootsToUpdate(updateSettings, result2.rejected.keySet())).isEmpty();
                        updateSettings = this.showDialogAndGetExitCode(result2.rejected.keySet(), updateSettings, rebaseOverMergeProblemDetected);
                        if (updateSettings != null) {
                            this.savePushUpdateSettings(updateSettings, rebaseOverMergeProblemDetected);
                        } else {
                            shouldUpdate = false;
                        }
                    }
                    if (!shouldUpdate) break;
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before push");
                    }
                    Collection<GitRepository> rootsToUpdate = this.getRootsToUpdate(updateSettings, result2.rejected.keySet());
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod(), rebaseOverMergeProblemDetected == null);
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS || updateResult == GitUpdateResult.INCOMPLETE) break;
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
            if (this.myPushProcessCustomization != null) {
                this.myPushProcessCustomization.executeAfterPush(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "After push");
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        return this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
    }

    @Nullable
    private GitPushProcessCustomizationFactory.GitPushProcessCustomization findPushCustomization() {
        List customizations = StreamEx.of((Object[])GitPushProcessCustomizationFactory.GIT_PUSH_CUSTOMIZATION_FACTORY_EP.getExtensions()).map(factory -> factory.createCustomization(this.myProject, this.myPushSpecs, this.myForce)).toList();
        if (customizations.isEmpty()) {
            return null;
        }
        if (customizations.size() > 1) {
            LOG.error("Only one GitPushProcessCustomization is allowed, but more are installed: " + customizations);
            return null;
        }
        return (GitPushProcessCustomizationFactory.GitPushProcessCustomization)customizations.get(0);
    }

    @NotNull
    private Collection<GitRepository> getRootsToUpdate(@NotNull PushUpdateSettings updateSettings, @NotNull Set<GitRepository> rejectedRepositories) {
        return updateSettings.shouldUpdateAllRoots() ? this.myRepositoryManager.getRepositories() : rejectedRepositories;
    }

    @NotNull
    private Collection<VirtualFile> findRootsWithMergeCommits(@NotNull Collection<GitRepository> rootsToSearch) {
        return ContainerUtil.mapNotNull(rootsToSearch, repo -> {
            PushSpec pushSpec = this.myPushSpecs.get(repo);
            if (pushSpec == null) {
                GitPushSource source = this.myPushSupport.getSource((GitRepository)repo);
                GitPushTarget target = this.myPushSupport.getDefaultTarget((GitRepository)repo);
                if (target == null) {
                    return null;
                }
                pushSpec = new PushSpec((PushSource)source, (PushTarget)target);
            }
            String baseRef = ((GitPushTarget)pushSpec.getTarget()).getBranch().getFullName();
            String currentRef = ((GitPushSource)pushSpec.getSource()).getBranch().getFullName();
            return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo.getRoot() : null;
        });
    }

    private static boolean pushingToNotTrackedBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        return ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
            return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(((GitPushRepoResult)entry.getValue()).getTargetBranch());
        });
    }

    @NotNull
    private static List<GitRepository> getRejectedAndNotPushed(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        return ContainerUtil.filter(results.keySet(), repository -> ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED_NO_FF || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED);
    }

    @NotNull
    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        Set<GitRepository> repositories = this.myPushSpecs.keySet();
        repositories.forEach(Repository::update);
        return StreamEx.of(repositories).toMap(Repository::getCurrentRevision);
    }

    @NotNull
    private GitPushResult prepareCombinedResult(@NotNull Map<GitRepository, GitPushRepoResult> allRoots, @NotNull Map<GitRepository, GitUpdateResult> updatedRoots, @NotNull Map<GitRepository, String> preUpdatePositions, @Nullable Label beforeUpdateLabel, @Nullable Label afterUpdateLabel) {
        HashMap results = ContainerUtil.newHashMap();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        return new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel);
    }

    @NotNull
    private Map<GitRepository, GitPushRepoResult> push(@NotNull List<GitRepository> repositories) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        LinkedHashMap results = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : repositories) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(repository);
            ResultWithOutput resultWithOutput = this.doPush(repository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + resultWithOutput);
            GitLocalBranch source = ((GitPushSource)spec.getSource()).getBranch();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultWithOutput.isError()) {
                repoResult = GitPushRepoResult.error(source, target.getBranch(), resultWithOutput.getErrorAsString());
            } else {
                List nativeResults = resultWithOutput.parsedResults;
                GitPushNativeResult branchResult = GitPushOperation.getBranchResult(nativeResults);
                if (branchResult == null) {
                    LOG.error("No result for branch among: [" + nativeResults + "]\nFull result: " + resultWithOutput);
                    continue;
                }
                List tagResults = ContainerUtil.filter((Collection)nativeResults, result2 -> !result2.equals(branchResult) && (result2.getType() == GitPushNativeResult.Type.NEW_REF || result2.getType() == GitPushNativeResult.Type.FORCED_UPDATE));
                int commits2 = this.collectNumberOfPushedCommits(repository.getRoot(), branchResult);
                repoResult = GitPushRepoResult.convertFromNative(branchResult, tagResults, commits2, source, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(repository, repoResult);
        }
        if (this.myPushProcessCustomization != null) {
            return this.myPushProcessCustomization.executeAfterPushIteration(results);
        }
        for (GitRepository repository : repositories) {
            if (results.containsKey(repository)) continue;
            spec = this.myPushSpecs.get(repository);
            results.put(repository, GitPushRepoResult.notPushed(((GitPushSource)spec.getSource()).getBranch(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        return results;
    }

    @Nullable
    private static GitPushNativeResult getBranchResult(@NotNull List<GitPushNativeResult> results) {
        return (GitPushNativeResult)ContainerUtil.find(results, result2 -> result2.getSourceRef().startsWith("refs/heads/"));
    }

    private int collectNumberOfPushedCommits(@NotNull VirtualFile root, @NotNull GitPushNativeResult result2) {
        if (result2.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result2.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result2);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(@NotNull UpdatedFiles updatedFiles, @NotNull GitRepository repository, @NotNull String preUpdatePosition) {
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, repository.getRoot(), new GitRevisionNumber(preUpdatePosition));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(updatedFiles, exceptions);
        for (VcsException exception : exceptions) {
            LOG.info((Throwable)exception);
        }
    }

    @NotNull
    private ResultWithOutput doPush(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = ((GitPushSource)pushSpec.getSource()).getBranch();
        GitRemoteBranch targetBranch = target.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = target.isNewBranchCreated() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        String tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument();
        String spec = sourceBranch.getFullName() + ":" + targetBranch.getNameForRemoteOperations();
        GitRemote remote = targetBranch.getRemote();
        List<GitPushParams.ForceWithLease> forceWithLease = Collections.emptyList();
        if (this.myForce && Registry.is((String)"git.use.push.force.with.lease")) {
            Hash hash = repository.getBranches().getHash(targetBranch);
            String expectedHash = hash != null ? hash.asString() : "";
            forceWithLease = Collections.singletonList(new GitPushParamsImpl.ForceWithLeaseReference(targetBranch.getNameForRemoteOperations(), expectedHash));
        }
        GitPushParamsImpl params = new GitPushParamsImpl(remote, spec, this.myForce, setUpstream, this.mySkipHook, tagMode, forceWithLease);
        GitCommandResult res = this.myPushProcessCustomization != null ? this.myPushProcessCustomization.runPushCommand(repository, pushSpec, params, progressListener) : this.myGit.push(repository, params, progressListener);
        if (res.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
        }
        return new ResultWithOutput(res);
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, @NotNull GitLocalBranch source) {
        return ContainerUtil.exists(repository.getBranchTrackInfos(), info -> info.getLocalBranch().equals(source));
    }

    private void savePushUpdateSettings(@NotNull PushUpdateSettings settings, boolean rebaseOverMergeDetected) {
        UpdateMethod updateMethod = settings.getUpdateMethod();
        this.mySettings.setUpdateAllRootsIfPushRejected(settings.shouldUpdateAllRoots());
        if (!rebaseOverMergeDetected && this.mySettings.getUpdateType() != updateMethod && this.mySettings.getUpdateType() != UpdateMethod.BRANCH_DEFAULT) {
            this.mySettings.setUpdateType(updateMethod);
        }
    }

    @NotNull
    private PushUpdateSettings readPushUpdateSettings() {
        boolean updateAllRoots = this.mySettings.shouldUpdateAllRootsIfPushRejected();
        UpdateMethod updateMethod = this.mySettings.getUpdateType();
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(this.myPushSpecs.keySet().iterator().next());
        }
        return new PushUpdateSettings(updateAllRoots, updateMethod);
    }

    @Nullable
    private PushUpdateSettings showDialogAndGetExitCode(@NotNull Set<GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        Ref updateSettings = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRejectedPushUpdateDialog dialog = new GitRejectedPushUpdateDialog(this.myProject, repositories, initialSettings, rebaseOverMergeProblemDetected);
            DialogManager.show(dialog);
            int exitCode = dialog.getExitCode();
            if (exitCode != 1) {
                this.mySettings.setAutoUpdateIfPushRejected(dialog.shouldAutoUpdateInFuture());
                updateSettings.set((Object)new PushUpdateSettings(dialog.shouldUpdateAll(), GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    @NotNull
    private static UpdateMethod convertUpdateMethodFromDialogExitCode(int exitCode) {
        switch (exitCode) {
            case 2: {
                return UpdateMethod.MERGE;
            }
            case 3: {
                return UpdateMethod.REBASE;
            }
        }
        throw new IllegalStateException("Unexpected exit code: " + exitCode);
    }

    @NotNull
    protected GitUpdateResult update(@NotNull Collection<GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod, boolean checkForRebaseOverMergeProblem) {
        GitUpdateResult updateResult = new GitUpdateProcess(this.myProject, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create(), checkForRebaseOverMergeProblem, false).update(updateMethod);
        for (GitRepository repository : rootsToUpdate) {
            repository.getRoot().refresh(true, true);
            repository.update();
        }
        return updateResult;
    }

    private static class ResultWithOutput {
        @NotNull
        private final List<GitPushNativeResult> parsedResults;
        @NotNull
        private final GitCommandResult resultOutput;

        ResultWithOutput(@NotNull GitCommandResult resultOutput) {
            this.resultOutput = resultOutput;
            this.parsedResults = GitPushNativeResultParser.parse(resultOutput.getOutput());
        }

        boolean isError() {
            return this.parsedResults.isEmpty();
        }

        @NotNull
        String getErrorAsString() {
            return this.resultOutput.getErrorOutputAsJoinedString();
        }

        public String toString() {
            return "Parsed results: " + this.parsedResults + "\nCommand output:" + this.resultOutput;
        }
    }
}

