/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushNativeResult;
import git4idea.update.GitUpdateResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushRepoResult {
    static Comparator<Type> TYPE_COMPARATOR = (o1, o2) -> o1.ordinal() - o2.ordinal();
    @NotNull
    private final Type myType;
    private final int myCommits;
    @NotNull
    private final String mySourceBranch;
    @NotNull
    private final String myTargetBranch;
    @NotNull
    private final String myTargetRemote;
    @NotNull
    private final List<String> myPushedTags;
    @Nullable
    private final String myError;
    @Nullable
    private final GitUpdateResult myUpdateResult;

    @NotNull
    public static GitPushRepoResult convertFromNative(@NotNull GitPushNativeResult result2, @NotNull List<? extends GitPushNativeResult> tagResults, int commits2, @NotNull GitLocalBranch source, @NotNull GitRemoteBranch target) {
        List tags = ContainerUtil.map(tagResults, result1 -> result1.getSourceRef());
        String error = result2.getType() == GitPushNativeResult.Type.ERROR ? result2.getReason() : null;
        return new GitPushRepoResult(GitPushRepoResult.convertType(result2), commits2, source.getFullName(), target.getFullName(), target.getRemote().getName(), tags, error, null);
    }

    @NotNull
    public static GitPushRepoResult error(@NotNull GitLocalBranch source, @NotNull GitRemoteBranch target, @NotNull String error) {
        return new GitPushRepoResult(Type.ERROR, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), error, null);
    }

    @NotNull
    public static GitPushRepoResult notPushed(GitLocalBranch source, GitRemoteBranch target) {
        return new GitPushRepoResult(Type.NOT_PUSHED, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.emptyList(), null, null);
    }

    @NotNull
    static GitPushRepoResult addUpdateResult(GitPushRepoResult original, GitUpdateResult updateResult) {
        return new GitPushRepoResult(original.getType(), original.getNumberOfPushedCommits(), original.getSourceBranch(), original.getTargetBranch(), original.getTargetRemote(), original.getPushedTags(), original.getError(), updateResult);
    }

    private GitPushRepoResult(@NotNull Type type, int pushedCommits, @NotNull String sourceBranch, @NotNull String targetBranch, @NotNull String targetRemote, @NotNull List<String> pushedTags, @Nullable String error, @Nullable GitUpdateResult result2) {
        this.myType = type;
        this.myCommits = pushedCommits;
        this.mySourceBranch = sourceBranch;
        this.myTargetBranch = targetBranch;
        this.myTargetRemote = targetRemote;
        this.myPushedTags = pushedTags;
        this.myError = error;
        this.myUpdateResult = result2;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    @Nullable
    GitUpdateResult getUpdateResult() {
        return this.myUpdateResult;
    }

    int getNumberOfPushedCommits() {
        return this.myCommits;
    }

    @NotNull
    String getSourceBranch() {
        return this.mySourceBranch;
    }

    @NotNull
    String getTargetBranch() {
        return this.myTargetBranch;
    }

    @Nullable
    String getError() {
        return this.myError;
    }

    @NotNull
    List<String> getPushedTags() {
        return this.myPushedTags;
    }

    @NotNull
    public String getTargetRemote() {
        return this.myTargetRemote;
    }

    @NotNull
    private static Type convertType(@NotNull GitPushNativeResult nativeResult) {
        switch (nativeResult.getType()) {
            case SUCCESS: {
                return Type.SUCCESS;
            }
            case FORCED_UPDATE: {
                return Type.FORCED;
            }
            case NEW_REF: {
                return Type.NEW_BRANCH;
            }
            case REJECTED: {
                return nativeResult.isNonFFUpdate() ? Type.REJECTED_NO_FF : Type.REJECTED_OTHER;
            }
            case UP_TO_DATE: {
                return Type.UP_TO_DATE;
            }
            case ERROR: {
                return Type.ERROR;
            }
        }
        throw new IllegalArgumentException("Conversion is not supported: " + (Object)((Object)nativeResult.getType()));
    }

    public String toString() {
        return String.format("%s (%d, '%s'), update: %s}", new Object[]{this.myType, this.myCommits, this.mySourceBranch, this.myUpdateResult});
    }

    public static enum Type {
        SUCCESS,
        NEW_BRANCH,
        UP_TO_DATE,
        FORCED,
        REJECTED_NO_FF,
        REJECTED_OTHER,
        ERROR,
        NOT_PUSHED;

    }
}

