/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import org.jetbrains.annotations.NotNull;

public final class GitPushTagMode {
    public static final GitPushTagMode ALL = new GitPushTagMode("All", "--tags");
    public static final GitPushTagMode FOLLOW = new GitPushTagMode("Current Branch", "--follow-tags");
    @NotNull
    private String myTitle;
    @NotNull
    private String myArgument;

    public GitPushTagMode() {
        this(ALL.getTitle(), ALL.getArgument());
    }

    private GitPushTagMode(@NotNull String title, @NotNull String argument) {
        this.myTitle = title;
        this.myArgument = argument;
    }

    @NotNull
    public static GitPushTagMode[] getValues() {
        return new GitPushTagMode[]{ALL, FOLLOW};
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public String getArgument() {
        return this.myArgument;
    }

    public void setTitle(@NotNull String title) {
        this.myTitle = title;
    }

    public void setArgument(@NotNull String argument) {
        this.myArgument = argument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitPushTagMode mode = (GitPushTagMode)o;
        if (!this.myArgument.equals(mode.myArgument)) {
            return false;
        }
        return this.myTitle.equals(mode.myTitle);
    }

    public int hashCode() {
        int result2 = this.myTitle.hashCode();
        result2 = 31 * result2 + this.myArgument.hashCode();
        return result2;
    }
}

