/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.DialogManager;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEditor;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseUnstructuredEditor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitInteractiveRebaseEditorHandler
implements Closeable,
GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance(GitInteractiveRebaseEditorHandler.class);
    private final GitRebaseEditorService myService;
    private final Project myProject;
    private final VirtualFile myRoot;
    @NotNull
    private final UUID myHandlerNo;
    private boolean myIsClosed;
    protected boolean myRebaseEditorShown = false;
    private boolean myCommitListCancelled;
    private boolean myUnstructuredEditorCancelled;

    public GitInteractiveRebaseEditorHandler(@NotNull GitRebaseEditorService service, @NotNull Project project, @NotNull VirtualFile root) {
        this.myService = service;
        this.myProject = project;
        this.myRoot = root;
        this.myHandlerNo = service.registerHandler(this, (Disposable)project);
    }

    @Override
    public int editCommits(@NotNull String path) {
        this.ensureOpen();
        try {
            if (this.myRebaseEditorShown) {
                this.myUnstructuredEditorCancelled = !this.handleUnstructuredEditor(path);
                return this.myUnstructuredEditorCancelled ? 2 : 0;
            }
            this.setRebaseEditorShown();
            boolean success = this.handleInteractiveEditor(path);
            if (success) {
                return 0;
            }
            this.myCommitListCancelled = true;
            return 2;
        }
        catch (Exception e) {
            LOG.error("Failed to edit git rebase file: " + path, (Throwable)e);
            return 2;
        }
    }

    protected boolean handleUnstructuredEditor(@NotNull String path) throws IOException {
        File file = new File(path);
        String encoding = GitConfigUtil.getCommitEncoding(this.myProject, this.myRoot);
        String initialText = StringUtil.trimLeading((String)GitInteractiveRebaseEditorHandler.ignoreComments(FileUtil.loadFile((File)file, (String)encoding)));
        String newText = this.showUnstructuredEditor(initialText);
        if (newText == null) {
            return false;
        }
        FileUtil.writeToFile((File)file, (byte[])newText.getBytes(encoding));
        return true;
    }

    @NotNull
    private static String ignoreComments(@NotNull String text) {
        Object[] lines = StringUtil.splitByLinesKeepSeparators((String)text);
        return ((StreamEx)StreamEx.of((Object[])lines).filter(line -> !line.startsWith("\u0001"))).joining();
    }

    @Nullable
    private String showUnstructuredEditor(@NotNull String initialText) {
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRebaseUnstructuredEditor editor = new GitRebaseUnstructuredEditor(this.myProject, this.myRoot, initialText);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set((Object)editor.getText());
            }
        });
        return (String)newText.get();
    }

    protected boolean handleInteractiveEditor(@NotNull String path) throws IOException {
        GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(this.myProject, this.myRoot, path);
        try {
            List<GitRebaseEntry> entries = rebaseFile.load();
            List<GitRebaseEntry> newEntries = this.showInteractiveRebaseEditor(entries);
            if (newEntries != null) {
                rebaseFile.save(newEntries);
                return true;
            }
            rebaseFile.cancel();
            return false;
        }
        catch (GitInteractiveRebaseFile.NoopException e) {
            return this.confirmNoopRebase();
        }
    }

    @Nullable
    private List<GitRebaseEntry> showInteractiveRebaseEditor(@NotNull List<GitRebaseEntry> entries) {
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRebaseEditor editor = new GitRebaseEditor(this.myProject, this.myRoot, entries);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set(editor.getEntries());
            }
        });
        return (List)newText.get();
    }

    private boolean confirmNoopRebase() {
        LOG.info("Noop situation while rebasing " + this.myRoot);
        String message = "There are no commits to rebase because the current branch is directly below the base branch, or they point to the same commit (the 'noop' situation).\nDo you want to continue (this will reset the current branch to the base branch)?";
        Ref result2 = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)(0 == DialogManager.showOkCancelDialog(this.myProject, message, "Git Rebase", CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) ? 1 : 0)));
        return (Boolean)result2.get();
    }

    public void setRebaseEditorShown() {
        this.myRebaseEditorShown = true;
    }

    private void ensureOpen() {
        if (this.myIsClosed) {
            throw new IllegalStateException("The handler was already closed");
        }
    }

    @Override
    public void close() {
        this.ensureOpen();
        this.myIsClosed = true;
        this.myService.unregisterHandler(this.myHandlerNo);
    }

    @Override
    @NotNull
    public UUID getHandlerNo() {
        return this.myHandlerNo;
    }

    @Override
    public boolean wasCommitListEditorCancelled() {
        return this.myCommitListCancelled;
    }

    @Override
    public boolean wasUnstructuredEditorCancelled() {
        return this.myUnstructuredEditorCancelled;
    }
}

