/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GitInteractiveRebaseFile {
    @NonNls
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final String myFile;

    GitInteractiveRebaseFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String rebaseFilePath) {
        this.myProject = project;
        this.myRoot = root;
        this.myFile = GitInteractiveRebaseFile.adjustFilePath(rebaseFilePath);
    }

    @NotNull
    public List<GitRebaseEntry> load() throws IOException, NoopException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        ArrayList entries = ContainerUtil.newArrayList();
        StringScanner s = new StringScanner(FileUtil.loadFile((File)new File(this.myFile), (String)encoding));
        boolean noop = false;
        while (s.hasMoreData()) {
            if (s.isEol() || this.isComment(s)) {
                s.nextLine();
                continue;
            }
            if (s.startsWith("noop")) {
                noop = true;
                s.nextLine();
                continue;
            }
            String action = s.spaceToken();
            String hash = s.spaceToken();
            String comment = s.line();
            entries.add(new GitRebaseEntry(action, hash, comment));
        }
        if (noop && entries.isEmpty()) {
            throw new NoopException();
        }
        return entries;
    }

    private boolean isComment(@NotNull StringScanner s) {
        String commentChar = GitVersionSpecialty.KNOWS_CORE_COMMENT_CHAR.existsIn(this.myProject) ? "\u0001" : "#";
        return s.startsWith(commentChar);
    }

    public void cancel() throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(this.myFile));){
            out.println("# rebase is cancelled");
        }
    }

    public void save(@NotNull List<GitRebaseEntry> entries) throws IOException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), encoding));){
            for (GitRebaseEntry e : entries) {
                if (e.getAction() == GitRebaseEntry.Action.SKIP.INSTANCE) continue;
                out.println(e.getAction().toString() + " " + e.getCommit() + " " + e.getSubject());
            }
        }
    }

    @NotNull
    private static String adjustFilePath(@NotNull String file) {
        if (SystemInfo.isWindows && file.startsWith(CYGDRIVE_PREFIX)) {
            int prefixSize = CYGDRIVE_PREFIX.length();
            return file.substring(prefixSize, prefixSize + 1) + ":" + file.substring(prefixSize + 1);
        }
        return file;
    }

    static class NoopException
    extends Exception {
        NoopException() {
        }
    }
}

