/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.GitRevisionNumber;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitTag;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitRebaseSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.GitReferenceValidator;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitRebaseDialog.class);
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    protected ComboBox myGitRootComboBox;
    protected ComboBox myBranchComboBox;
    protected ComboBox myFromComboBox;
    private JButton myFromValidateButton;
    protected ComboBox myOntoComboBox;
    private JButton myOntoValidateButton;
    private JCheckBox myShowTagsCheckBox;
    protected JCheckBox myInteractiveCheckBox;
    private JPanel myPanel;
    private JCheckBox myPreserveMergesCheckBox;
    protected final Project myProject;
    protected final List<GitBranch> myLocalBranches;
    protected final List<GitBranch> myRemoteBranches;
    @Nullable
    protected GitBranch myCurrentBranch;
    protected final List<GitTag> myTags;
    private final GitReferenceValidator myOntoValidator;
    private final GitReferenceValidator myFromValidator;
    @NotNull
    private final GitRebaseSettings mySettings;
    @Nullable
    private final String myOriginalOntoBranch;

    public GitRebaseDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myLocalBranches = new ArrayList<GitBranch>();
        this.myRemoteBranches = new ArrayList<GitBranch>();
        this.myTags = new ArrayList<GitTag>();
        this.setTitle(GitBundle.getString("rebase.title"));
        this.setOKButtonText(GitBundle.getString("rebase.button"));
        this.init();
        this.myProject = project;
        this.mySettings = (GitRebaseSettings)ServiceManager.getService((Project)this.myProject, GitRebaseSettings.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        Runnable validateRunnable = () -> this.validateFields();
        this.myOntoValidator = new GitReferenceValidator(this.myProject, (JComboBox)this.myGitRootComboBox, GitUIUtil.getTextField((JComboBox)this.myOntoComboBox), this.myOntoValidateButton, validateRunnable);
        this.myFromValidator = new GitReferenceValidator(this.myProject, (JComboBox)this.myGitRootComboBox, GitUIUtil.getTextField((JComboBox)this.myFromComboBox), this.myFromValidateButton, validateRunnable);
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, (JComboBox)this.myGitRootComboBox, null);
        this.myGitRootComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.validateFields();
            }
        });
        this.myInteractiveCheckBox.setSelected(this.mySettings.isInteractive());
        this.myPreserveMergesCheckBox.setSelected(this.mySettings.isPreserveMerges());
        this.myShowTagsCheckBox.setSelected(this.mySettings.showTags());
        this.setupBranches();
        this.overwriteOntoForCurrentBranch(this.mySettings);
        this.myOriginalOntoBranch = GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText();
        this.validateFields();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myOntoComboBox;
    }

    private void overwriteOntoForCurrentBranch(@NotNull GitRebaseSettings settings) {
        String onto = settings.getOnto();
        if (onto != null && !onto.equals(this.myBranchComboBox.getSelectedItem())) {
            if (!this.isValidRevision(onto)) {
                this.mySettings.setOnto(null);
            } else {
                this.myOntoComboBox.setSelectedItem((Object)onto);
            }
        }
    }

    private boolean isValidRevision(@NotNull String revisionExpression) {
        try {
            GitRevisionNumber.resolve(this.myProject, this.gitRoot(), revisionExpression);
            return true;
        }
        catch (VcsException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    protected void doOKAction() {
        try {
            this.rememberFields();
        }
        finally {
            super.doOKAction();
        }
    }

    private void rememberFields() {
        this.mySettings.setInteractive(this.myInteractiveCheckBox.isSelected());
        this.mySettings.setPreserveMerges(this.myPreserveMergesCheckBox.isSelected());
        this.mySettings.setShowTags(this.myShowTagsCheckBox.isSelected());
        String onto = StringUtil.nullize((String)GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText(), (boolean)true);
        if (onto != null && !onto.equals(this.myOriginalOntoBranch)) {
            this.mySettings.setOnto(onto);
        }
    }

    private void validateFields() {
        if (GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        if (this.myOntoValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("rebase.invalid.onto"), (JComponent)this.myOntoComboBox);
            this.setOKActionEnabled(false);
            return;
        }
        if (GitUIUtil.getTextField((JComboBox)this.myFromComboBox).getText().length() != 0 && this.myFromValidator.isInvalid()) {
            this.setErrorText(GitBundle.getString("rebase.invalid.from"), (JComponent)this.myFromComboBox);
            this.setOKActionEnabled(false);
            return;
        }
        if (GitRebaseUtils.isRebaseInTheProgress(this.myProject, this.gitRoot())) {
            this.setErrorText(GitBundle.getString("rebase.in.progress"));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    private void setupBranches() {
        GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                GitRebaseDialog.this.validateFields();
            }
        });
        ActionListener rootListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.loadRefs();
                GitRebaseDialog.this.updateBranches();
            }
        };
        ActionListener showListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.updateOntoFrom();
            }
        };
        this.myShowTagsCheckBox.addActionListener(showListener);
        rootListener.actionPerformed(null);
        this.myGitRootComboBox.addActionListener(rootListener);
        this.myBranchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRebaseDialog.this.updateTrackedBranch();
            }
        });
    }

    private void updateBranches() {
        this.myBranchComboBox.removeAllItems();
        for (GitBranch b : this.myLocalBranches) {
            this.myBranchComboBox.addItem((Object)b.getName());
        }
        if (this.myCurrentBranch != null) {
            this.myBranchComboBox.setSelectedItem((Object)this.myCurrentBranch.getName());
        } else {
            this.myBranchComboBox.setSelectedItem((Object)0);
        }
        this.updateOntoFrom();
        this.updateTrackedBranch();
    }

    protected void updateOntoFrom() {
        String onto = GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText();
        String from = GitUIUtil.getTextField((JComboBox)this.myFromComboBox).getText();
        this.myFromComboBox.removeAllItems();
        this.myOntoComboBox.removeAllItems();
        this.addRefsToOntoAndFrom(this.myLocalBranches);
        this.addRefsToOntoAndFrom(this.myRemoteBranches);
        if (this.myShowTagsCheckBox.isSelected()) {
            this.addRefsToOntoAndFrom(this.myTags);
        }
        GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).setText(onto);
        GitUIUtil.getTextField((JComboBox)this.myFromComboBox).setText(from);
    }

    private void addRefsToOntoAndFrom(Collection<? extends GitReference> refs) {
        for (GitReference gitReference : refs) {
            this.myFromComboBox.addItem((Object)gitReference);
            this.myOntoComboBox.addItem((Object)gitReference);
        }
    }

    protected void loadRefs() {
        try {
            this.myLocalBranches.clear();
            this.myRemoteBranches.clear();
            this.myTags.clear();
            VirtualFile root = this.gitRoot();
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            if (repository != null) {
                this.myLocalBranches.addAll(GitBranchUtil.sortBranchesByName(repository.getBranches().getLocalBranches()));
                this.myRemoteBranches.addAll(GitBranchUtil.sortBranchesByName(repository.getBranches().getRemoteBranches()));
                this.myCurrentBranch = repository.getCurrentBranch();
            } else {
                LOG.error("Repository is null for root " + root);
            }
            this.myTags.addAll(GitTag.list(this.myProject, root));
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, "git branch -a");
        }
    }

    private void updateTrackedBranch() {
        try {
            VirtualFile root = this.gitRoot();
            String currentBranch = (String)this.myBranchComboBox.getSelectedItem();
            GitBranch trackedBranch = null;
            if (currentBranch != null) {
                String remote = GitConfigUtil.getValue(this.myProject, root, "branch." + currentBranch + ".remote");
                String mergeBranch = GitConfigUtil.getValue(this.myProject, root, "branch." + currentBranch + ".merge");
                if (remote == null || mergeBranch == null) {
                    trackedBranch = ((GitRepository)this.myRepositoryManager.getRepositoryForRoot(root)).getBranches().findBranchByName("master");
                } else {
                    mergeBranch = GitBranchUtil.stripRefsPrefix(mergeBranch);
                    if (remote.equals(".")) {
                        trackedBranch = new GitSvnRemoteBranch(mergeBranch);
                    } else {
                        GitRemote r = GitBranchUtil.findRemoteByNameOrLogError(this.myProject, root, remote);
                        if (r != null) {
                            trackedBranch = new GitStandardRemoteBranch(r, mergeBranch);
                        }
                    }
                }
            }
            if (trackedBranch != null) {
                this.myOntoComboBox.setSelectedItem(trackedBranch);
            } else {
                GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).setText("");
            }
            GitUIUtil.getTextField((JComboBox)this.myFromComboBox).setText("");
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(this.myProject, e, "git config");
        }
    }

    public VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRootComboBox.getSelectedItem();
    }

    @NotNull
    public GitRepository getSelectedRepository() {
        return (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(this.gitRoot()));
    }

    @NotNull
    public GitRebaseParams getSelectedParams() {
        String newBase;
        String upstream;
        String selectedBranch = (String)this.myBranchComboBox.getSelectedItem();
        String branch = this.myCurrentBranch != null && !this.myCurrentBranch.getName().equals(selectedBranch) ? selectedBranch : null;
        String from = GitUIUtil.getTextField((JComboBox)this.myFromComboBox).getText();
        String onto = GitUIUtil.getTextField((JComboBox)this.myOntoComboBox).getText();
        if (StringUtil.isEmptyOrSpaces((String)from)) {
            upstream = onto;
            newBase = null;
        } else {
            upstream = from;
            newBase = onto;
        }
        return new GitRebaseParams(GitVcs.getInstance(this.myProject).getVersion(), branch, newBase, upstream, this.myInteractiveCheckBox.isSelected(), this.myPreserveMergesCheckBox.isSelected());
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Rebase";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JButton jButton;
        ComboBox comboBox;
        JButton jButton2;
        ComboBox comboBox2;
        ComboBox comboBox3;
        ComboBox comboBox4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGitRootComboBox = comboBox4 = new ComboBox();
        comboBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add((Component)comboBox4, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.branch"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchComboBox = comboBox3 = new ComboBox();
        comboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.branch.tooltip"));
        jPanel.add((Component)comboBox3, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOntoComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        comboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myOntoValidateButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.onto.validate"));
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.valdate.onto.tooltip"));
        jPanel.add((Component)jButton2, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.from"));
        jPanel.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFromComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        comboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.from.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFromValidateButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.validate.from"));
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.validate.from.tooltip"));
        jPanel.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 2, 0, 3, 7, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPreserveMergesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.preserve.merges"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.preserve.merges.tooltip"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInteractiveCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(true);
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.interactive"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.interactive.tooltip"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myShowTagsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("regase.show.tags"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.show.tags.tooltip"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor((Component)comboBox4);
        jLabel2.setLabelFor((Component)comboBox3);
        jLabel3.setLabelFor((Component)comboBox2);
        jLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

