/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorMain;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public class GitRebaseEditorService {
    private String myEditorCommand;
    private final Object myScriptLock = new Object();
    private final Map<UUID, GitRebaseEditorHandler> myHandlers = ContainerUtil.newHashMap();
    private final Object myHandlersLock = new Object();
    @NonNls
    private static final String GIT_REBASE_EDITOR_PREFIX = "git-rebase-editor-";

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ServiceManager.getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        return service;
    }

    private void addInternalHandler() {
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler("Git4ideaRebaseEditorHandler")) {
            xmlRpcServer.addHandler("Git4ideaRebaseEditorHandler", (Object)new InternalHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized String getEditorCommand() {
        Object object = this.myScriptLock;
        synchronized (object) {
            if (this.myEditorCommand == null) {
                ScriptGenerator generator = new ScriptGenerator(GIT_REBASE_EDITOR_PREFIX, GitRebaseEditorMain.class);
                generator.addInternal(Integer.toString(BuiltInServerManager.getInstance().getPort()));
                generator.addClasses(XmlRpcClientLite.class, DecoderException.class);
                this.myEditorCommand = generator.commandLine();
            }
            return this.myEditorCommand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UUID registerHandler(@NotNull GitRebaseEditorHandler handler, @NotNull Disposable parentDisposable) {
        this.addInternalHandler();
        Object object = this.myHandlersLock;
        synchronized (object) {
            final UUID key = UUID.randomUUID();
            this.myHandlers.put(key, handler);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    GitRebaseEditorService.this.myHandlers.remove(key);
                }
            });
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(@NotNull UUID handlerNo) {
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    GitRebaseEditorHandler getHandler(@NotNull UUID handlerNo) {
        Object object = this.myHandlersLock;
        synchronized (object) {
            GitRebaseEditorHandler h = this.myHandlers.get(handlerNo);
            if (h == null) {
                throw new IllegalStateException("The handler " + handlerNo + " is not registered");
            }
            return h;
        }
    }

    public void configureHandler(GitLineHandler h, @NotNull UUID editorNo) {
        h.addCustomEnvironmentVariable("GIT_EDITOR", this.getEditorCommand());
        h.addCustomEnvironmentVariable("IDEA_REBASE_HANDER_NO", editorNo.toString());
        try {
            h.addCustomEnvironmentVariable("GIT_REBASE_TOKEN", BuiltinWebServerAccess.getUserAuthenticationToken());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to set authentication for git rebase action", e);
        }
    }

    public class InternalHandler {
        public int editCommits(@NotNull String handlerNo, String path) {
            GitRebaseEditorHandler editor = GitRebaseEditorService.this.getHandler(UUID.fromString(handlerNo));
            return editor.editCommits(path);
        }
    }
}

